/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.commons.lang3.StringUtils;

@Command(name="repair", description="Repair one or more tables")
public class Repair
extends NodeTool.NodeToolCmd {
    public static final Set<String> ONLY_EXPLICITLY_REPAIRED = Sets.newHashSet("system_distributed");
    @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
    private List<String> args = new ArrayList<String>();
    @Option(title="seqential", name={"-seq", "--sequential"}, description="Use -seq to carry out a sequential repair")
    private boolean sequential = false;
    @Option(title="dc parallel", name={"-dcpar", "--dc-parallel"}, description="Use -dcpar to repair data centers in parallel.")
    private boolean dcParallel = false;
    @Option(title="local_dc", name={"-local", "--in-local-dc"}, description="Use -local to only repair against nodes in the same datacenter")
    private boolean localDC = false;
    @Option(title="specific_dc", name={"-dc", "--in-dc"}, description="Use -dc to repair specific datacenters")
    private List<String> specificDataCenters = new ArrayList<String>();
    @Option(title="specific_host", name={"-hosts", "--in-hosts"}, description="Use -hosts to repair specific hosts")
    private List<String> specificHosts = new ArrayList<String>();
    @Option(title="start_token", name={"-st", "--start-token"}, description="Use -st to specify a token at which the repair range starts")
    private String startToken = "";
    @Option(title="end_token", name={"-et", "--end-token"}, description="Use -et to specify a token at which repair range ends")
    private String endToken = "";
    @Option(title="primary_range", name={"-pr", "--partitioner-range"}, description="Use -pr to repair only the first range returned by the partitioner")
    private boolean primaryRange = false;
    @Option(title="full", name={"-full", "--full"}, description="Use -full to issue a full repair.")
    private boolean fullRepair = false;
    @Option(title="job_threads", name={"-j", "--job-threads"}, description="Number of threads to run repair jobs. Usually this means number of CFs to repair concurrently. WARNING: increasing this puts more load on repairing nodes, so be careful. (default: 1, max: 4)")
    private int numJobThreads = 1;
    @Option(title="trace_repair", name={"-tr", "--trace"}, description="Use -tr to trace the repair. Traces are logged to system_traces.events.")
    private boolean trace = false;

    @Override
    public void execute(NodeProbe probe) {
        List<String> keyspaces = this.parseOptionalKeyspace(this.args, probe);
        Object[] cfnames = this.parseOptionalTables(this.args);
        if (!(!this.primaryRange || this.specificDataCenters.isEmpty() && this.specificHosts.isEmpty())) {
            throw new RuntimeException("Primary range repair should be performed on all nodes in the cluster.");
        }
        for (String keyspace : keyspaces) {
            if ((this.args == null || this.args.isEmpty()) && ONLY_EXPLICITLY_REPAIRED.contains(keyspace)) continue;
            HashMap<String, String> options = new HashMap<String, String>();
            RepairParallelism parallelismDegree = RepairParallelism.PARALLEL;
            if (this.sequential) {
                parallelismDegree = RepairParallelism.SEQUENTIAL;
            } else if (this.dcParallel) {
                parallelismDegree = RepairParallelism.DATACENTER_AWARE;
            }
            options.put("parallelism", parallelismDegree.getName());
            options.put("primaryRange", Boolean.toString(this.primaryRange));
            options.put("incremental", Boolean.toString(!this.fullRepair));
            options.put("jobThreads", Integer.toString(this.numJobThreads));
            options.put("trace", Boolean.toString(this.trace));
            options.put("columnFamilies", StringUtils.join(cfnames, ","));
            if (!this.startToken.isEmpty() || !this.endToken.isEmpty()) {
                options.put("ranges", this.startToken + ":" + this.endToken);
            }
            if (this.localDC) {
                options.put("dataCenters", StringUtils.join(Lists.newArrayList(probe.getDataCenter()), ","));
            } else {
                options.put("dataCenters", StringUtils.join(this.specificDataCenters, ","));
            }
            options.put("hosts", StringUtils.join(this.specificHosts, ","));
            try {
                probe.repairAsync(System.out, keyspace, options);
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred during repair", e);
            }
        }
    }
}

