/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.Retention;

public class DataRetentionsMapper
implements Function<ResultSet, Set<Retention>> {
    private final String tenantId;
    private final MetricType<?> type;

    public DataRetentionsMapper(String tenantId, MetricType<?> type) {
        this.tenantId = tenantId;
        this.type = type;
    }

    @Override
    public Set<Retention> apply(ResultSet resultSet) {
        HashSet<Retention> dataRetentions = new HashSet<Retention>();
        for (Row row : resultSet) {
            dataRetentions.add(new Retention(new MetricId(this.tenantId, this.type, row.getString(2)), row.getInt(3)));
        }
        return dataRetentions;
    }
}

