/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompactionParams {
    private static final Logger logger = LoggerFactory.getLogger(CompactionParams.class);
    public static final int DEFAULT_MIN_THRESHOLD = 4;
    public static final int DEFAULT_MAX_THRESHOLD = 32;
    public static final boolean DEFAULT_ENABLED = true;
    public static final Map<String, String> DEFAULT_THRESHOLDS = ImmutableMap.of(Option.MIN_THRESHOLD.toString(), Integer.toString(4), Option.MAX_THRESHOLD.toString(), Integer.toString(32));
    public static final CompactionParams DEFAULT = new CompactionParams(SizeTieredCompactionStrategy.class, DEFAULT_THRESHOLDS, true);
    private final Class<? extends AbstractCompactionStrategy> klass;
    private final ImmutableMap<String, String> options;
    private final boolean isEnabled;

    private CompactionParams(Class<? extends AbstractCompactionStrategy> klass, Map<String, String> options, boolean isEnabled) {
        this.klass = klass;
        this.options = ImmutableMap.copyOf(options);
        this.isEnabled = isEnabled;
    }

    public static CompactionParams create(Class<? extends AbstractCompactionStrategy> klass, Map<String, String> options) {
        boolean isEnabled = options.containsKey(Option.ENABLED.toString()) ? Boolean.parseBoolean(options.get(Option.ENABLED.toString())) : true;
        HashMap<String, String> allOptions = new HashMap<String, String>(options);
        if (CompactionParams.supportsThresholdParams(klass)) {
            allOptions.putIfAbsent(Option.MIN_THRESHOLD.toString(), Integer.toString(4));
            allOptions.putIfAbsent(Option.MAX_THRESHOLD.toString(), Integer.toString(32));
        }
        return new CompactionParams(klass, allOptions, isEnabled);
    }

    public static CompactionParams scts(Map<String, String> options) {
        return CompactionParams.create(SizeTieredCompactionStrategy.class, options);
    }

    public static CompactionParams lcs(Map<String, String> options) {
        return CompactionParams.create(LeveledCompactionStrategy.class, options);
    }

    public int minCompactionThreshold() {
        String threshold = this.options.get(Option.MIN_THRESHOLD.toString());
        return threshold == null ? 4 : Integer.parseInt(threshold);
    }

    public int maxCompactionThreshold() {
        String threshold = this.options.get(Option.MAX_THRESHOLD.toString());
        return threshold == null ? 32 : Integer.parseInt(threshold);
    }

    public void validate() {
        try {
            Map unknownOptions = (Map)this.klass.getMethod("validateOptions", Map.class).invoke(null, this.options);
            if (!unknownOptions.isEmpty()) {
                throw new ConfigurationException(String.format("Properties specified %s are not understood by %s", unknownOptions.keySet(), this.klass.getSimpleName()));
            }
        }
        catch (NoSuchMethodException e) {
            logger.warn("Compaction strategy {} does not have a static validateOptions method. Validation ignored", (Object)this.klass.getName());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getTargetException();
            }
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw new ConfigurationException(String.format("%s.validateOptions() threw an error: %s %s", this.klass.getName(), cause.getClass().getName(), cause.getMessage()), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Cannot access method validateOptions in " + this.klass.getName(), e);
        }
        String minThreshold = this.options.get(Option.MIN_THRESHOLD.toString());
        if (minThreshold != null && !StringUtils.isNumeric(minThreshold)) {
            throw new ConfigurationException(String.format("Invalid value %s for '%s' compaction sub-option - must be an integer", new Object[]{minThreshold, Option.MIN_THRESHOLD}));
        }
        String maxThreshold = this.options.get(Option.MAX_THRESHOLD.toString());
        if (maxThreshold != null && !StringUtils.isNumeric(maxThreshold)) {
            throw new ConfigurationException(String.format("Invalid value %s for '%s' compaction sub-option - must be an integer", new Object[]{maxThreshold, Option.MAX_THRESHOLD}));
        }
        if (this.minCompactionThreshold() <= 0 || this.maxCompactionThreshold() <= 0) {
            throw new ConfigurationException("Disabling compaction by setting compaction thresholds to 0 has been removed, set the compaction option 'enabled' to false instead.");
        }
        if (this.minCompactionThreshold() <= 1) {
            throw new ConfigurationException(String.format("Min compaction threshold cannot be less than 2 (got %d)", this.minCompactionThreshold()));
        }
        if (this.minCompactionThreshold() > this.maxCompactionThreshold()) {
            throw new ConfigurationException(String.format("Min compaction threshold (got %d) cannot be greater than max compaction threshold (got %d)", this.minCompactionThreshold(), this.maxCompactionThreshold()));
        }
    }

    double defaultBloomFilterFbChance() {
        return this.klass.equals(LeveledCompactionStrategy.class) ? 0.1 : 0.01;
    }

    public Class<? extends AbstractCompactionStrategy> klass() {
        return this.klass;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static CompactionParams fromMap(Map<String, String> map) {
        HashMap<String, String> options = new HashMap<String, String>(map);
        String className = (String)options.remove(Option.CLASS.toString());
        if (className == null) {
            throw new ConfigurationException(String.format("Missing sub-option '%s' for the '%s' option", new Object[]{Option.CLASS, TableParams.Option.COMPACTION}));
        }
        return CompactionParams.create(CompactionParams.classFromName(className), options);
    }

    private static Class<? extends AbstractCompactionStrategy> classFromName(String name) {
        String className = name.contains(".") ? name : "org.apache.cassandra.db.compaction." + name;
        Class strategyClass = FBUtilities.classForName(className, "compaction strategy");
        if (!AbstractCompactionStrategy.class.isAssignableFrom(strategyClass)) {
            throw new ConfigurationException(String.format("Compaction strategy class %s is not derived from AbstractReplicationStrategy", className));
        }
        return strategyClass;
    }

    public static boolean supportsThresholdParams(Class<? extends AbstractCompactionStrategy> klass) {
        try {
            Map unrecognizedOptions = (Map)klass.getMethod("validateOptions", Map.class).invoke(null, DEFAULT_THRESHOLDS);
            return unrecognizedOptions.isEmpty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.options());
        map.put(Option.CLASS.toString(), this.klass.getName());
        return map;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("class", this.klass.getName()).add("options", this.options).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompactionParams)) {
            return false;
        }
        CompactionParams cp = (CompactionParams)o;
        return this.klass.equals(cp.klass) && this.options.equals(cp.options);
    }

    public int hashCode() {
        return Objects.hash(this.klass, this.options);
    }

    public static enum Option {
        CLASS,
        ENABLED,
        MIN_THRESHOLD,
        MAX_THRESHOLD;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

