/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Multimap;
import io.airlift.command.Command;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="tpstats", description="Print usage statistics of thread pools")
public class TpStats
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        System.out.printf("%-25s%10s%10s%15s%10s%18s%n", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
        Multimap<String, String> threadPools = probe.getThreadPools();
        for (Map.Entry<String, String> entry : threadPools.entries()) {
            System.out.printf("%-25s%10s%10s%15s%10s%18s%n", entry.getValue(), probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "ActiveTasks"), probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "PendingTasks"), probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "CompletedTasks"), probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "CurrentlyBlockedTasks"), probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "TotalBlockedTasks"));
        }
        System.out.printf("%n%-20s%10s%n", "Message type", "Dropped");
        for (Map.Entry<String, Object> entry : probe.getDroppedMessages().entrySet()) {
            System.out.printf("%-20s%10s%n", entry.getKey(), entry.getValue());
        }
    }
}

