/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import com.datastax.driver.core.Row;
import fi.iki.yak.ts.compression.gorilla.ByteBufferBitInput;
import fi.iki.yak.ts.compression.gorilla.Decompressor;
import fi.iki.yak.ts.compression.gorilla.Pair;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.core.service.compress.TagsDeserializer;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.MetricType;
import rx.Observable;

public class DataPointDecompressTransformer<T>
implements Observable.Transformer<Row, DataPoint<T>> {
    private Order order;
    private int limit;
    private long start;
    private long end;
    private MetricType<T> metricType;

    public DataPointDecompressTransformer(MetricType<T> metricType, Order order, int limit, long start, long end) {
        this.order = order;
        this.limit = limit;
        this.start = start;
        this.end = end;
        this.metricType = metricType;
    }

    public Observable<DataPoint<T>> call(Observable<Row> rows) {
        Observable datapoints = rows.flatMap(r -> {
            Stream.Builder<DataPoint<Object>> dataPointStreamBuilder = Stream.builder();
            ByteBuffer tagsBuffer = r.getBytes("tags");
            ByteBuffer compressedValue = r.getBytes("c_value");
            if (compressedValue != null) {
                Pair pair;
                compressedValue.get();
                ByteBufferBitInput in = new ByteBufferBitInput(compressedValue);
                Map<Long, Map<String, String>> tagMap = null;
                if (tagsBuffer != null) {
                    long blockStart = r.getTimestamp("time").toInstant().toEpochMilli();
                    TagsDeserializer deserializer = new TagsDeserializer(blockStart);
                    tagMap = deserializer.deserialize(tagsBuffer);
                }
                Decompressor d = new Decompressor(in);
                while ((pair = d.readPair()) != null) {
                    Long key;
                    if (pair.getTimestamp() < this.start || pair.getTimestamp() >= this.end) continue;
                    DataPoint<Object> dataPoint = null;
                    switch (this.metricType.getCode()) {
                        case 0: {
                            dataPoint = new DataPoint<Double>(pair.getTimestamp(), pair.getDoubleValue());
                            break;
                        }
                        case 1: {
                            dataPoint = new DataPoint<AvailabilityType>(pair.getTimestamp(), AvailabilityType.fromByte(Double.valueOf(pair.getDoubleValue()).byteValue()));
                            break;
                        }
                        case 2: {
                            dataPoint = new DataPoint<Long>(pair.getTimestamp(), Double.valueOf(pair.getDoubleValue()).longValue());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Metric of type " + this.metricType.getText() + " is not supported in decompression");
                        }
                    }
                    if (tagMap != null && tagMap.containsKey(key = Long.valueOf(pair.getTimestamp()))) {
                        Map<String, String> dpTags = tagMap.get(key);
                        dataPoint = new DataPoint<Object>(dataPoint.getTimestamp(), dataPoint.getValue(), dpTags);
                    }
                    dataPointStreamBuilder.add(dataPoint);
                }
            }
            return Observable.from((Iterable)dataPointStreamBuilder.build().sorted((d1, d2) -> {
                if (this.order == Order.ASC) {
                    return d1.getTimestamp() > d2.getTimestamp() ? 1 : -1;
                }
                return d1.getTimestamp() < d2.getTimestamp() ? 1 : -1;
            }).collect(Collectors.toList()));
        });
        if (this.limit > 0) {
            datapoints = datapoints.take(this.limit);
        }
        return datapoints;
    }
}

