/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.Map;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.Tenant;
import org.hawkular.metrics.model.fasterxml.jackson.MetricTypeKeyDeserializer;
import org.hawkular.metrics.model.fasterxml.jackson.MetricTypeKeySerializer;

@ApiModel(value="Tenant", description="The definition of a tenant")
public class TenantDefinition {
    private final String id;
    private final Map<MetricType<?>, Integer> retentionSettings;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public TenantDefinition(@JsonProperty(value="id") String id, @JsonProperty(value="retentions") @JsonDeserialize(keyUsing=MetricTypeKeyDeserializer.class) Map<MetricType<?>, Integer> retentionSettings) {
        Preconditions.checkArgument(id != null, "Tenant id is null");
        this.id = id;
        this.retentionSettings = retentionSettings == null ? Collections.emptyMap() : Collections.unmodifiableMap(retentionSettings);
    }

    public TenantDefinition(Tenant tenant) {
        this.id = tenant.getId();
        this.retentionSettings = tenant.getRetentionSettings();
    }

    @ApiModelProperty(value="Identifier of the tenant", required=true)
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Retention settings for metrics, expressed in days")
    @JsonProperty(value="retentions")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY, keyUsing=MetricTypeKeySerializer.class)
    public Map<MetricType<?>, Integer> getRetentionSettings() {
        return this.retentionSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantDefinition that = (TenantDefinition)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).omitNullValues().toString();
    }

    public Tenant toTenant() {
        return new Tenant(this.id, this.retentionSettings);
    }
}

