/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.sysconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Configuration {
    private String id;
    private Map<String, String> properties;

    public Configuration(String id) {
        this.id = id;
        this.properties = new HashMap<String, String>();
    }

    public Configuration(String id, Map<String, String> properties) {
        this.id = id;
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String get(String name) {
        return this.properties.get(name);
    }

    public String get(String name, String defaultValue) {
        return this.properties.getOrDefault(name, defaultValue);
    }

    public void set(String name, String value) {
        this.properties.put(name, value);
    }
}

