/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class FileUtils {
    private FileUtils() {
    }

    public static File tempFile(String suffix) throws IOException {
        File file = File.createTempFile("jmh", suffix);
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractFromResource(String name) throws IOException {
        InputStream fis = null;
        FileOutputStream fos = null;
        try {
            int read;
            File temp = FileUtils.tempFile("extracted");
            fis = FileUtils.class.getResourceAsStream(name);
            fos = new FileOutputStream(temp);
            byte[] buf = new byte[8192];
            while ((read = fis.read(buf)) != -1) {
                ((OutputStream)fos).write(buf, 0, read);
            }
            ((OutputStream)fos).close();
            File file = temp;
            return file;
        }
        finally {
            FileUtils.safelyClose(fis);
            FileUtils.safelyClose(fos);
        }
    }

    public static String createTempFileWithLines(String suffix, Iterable<String> lines) throws IOException {
        File file = FileUtils.tempFile(suffix);
        PrintWriter pw = new PrintWriter(file);
        for (String l : lines) {
            pw.println(l);
        }
        pw.close();
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> tail(File file, int num) throws IOException {
        FileInputStream fis = null;
        try {
            String line;
            fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            LinkedList<String> lines = new LinkedList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
                if (lines.size() <= num) continue;
                lines.remove(0);
            }
            LinkedList<String> linkedList = lines;
            return linkedList;
        }
        finally {
            FileUtils.safelyClose(fis);
        }
    }

    public static Collection<String> readAllLines(Reader src) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(src);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public static Collection<String> readAllLines(File file) throws IOException {
        FileReader fr = null;
        try {
            fr = new FileReader(file);
            Collection<String> collection = FileUtils.readAllLines(fr);
            return collection;
        }
        finally {
            FileUtils.safelyClose(fr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, Collection<String> lines) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(file);
            for (String line : lines) {
                pw.println(line);
            }
            pw.close();
        }
        finally {
            FileUtils.safelyClose(pw);
        }
    }

    public static void appendLines(File file, Collection<String> lines) throws IOException {
        ArrayList<String> newLines = new ArrayList<String>();
        try {
            newLines.addAll(FileUtils.readAllLines(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        newLines.addAll(lines);
        FileUtils.writeLines(file, newLines);
    }

    public static Collection<File> getClasses(File root) {
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<File> newDirs = new ArrayList<File>();
        newDirs.add(root);
        while (!newDirs.isEmpty()) {
            ArrayList<File> add = new ArrayList<File>();
            for (File dir : newDirs) {
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (f.isDirectory()) {
                        add.add(f);
                        continue;
                    }
                    if (!f.getName().endsWith(".class")) continue;
                    result.add(f);
                }
            }
            newDirs.clear();
            newDirs = add;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String src, String dst) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int read;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dst);
            byte[] buf = new byte[8192];
            while ((read = fis.read(buf)) != -1) {
                fos.write(buf, 0, read);
            }
            fos.close();
        }
        finally {
            FileUtils.safelyClose(fis);
            FileUtils.safelyClose(fos);
        }
    }

    public static <T extends Flushable & Closeable> void safelyClose(T obj) {
        if (obj != null) {
            try {
                obj.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ((Closeable)obj).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static <T extends Closeable> void safelyClose(T obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void touch(String f) throws IOException {
        File file = new File(f);
        try {
            if (file.createNewFile() || file.canWrite()) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new IOException("The file is not writable: " + f);
    }
}

