/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.AbstractRestriction;
import org.apache.cassandra.cql3.restrictions.MultiColumnRestriction;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.TermSlice;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.MultiCBuilder;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SecondaryIndexManager;

public abstract class SingleColumnRestriction
extends AbstractRestriction {
    protected final ColumnDefinition columnDef;

    public SingleColumnRestriction(ColumnDefinition columnDef) {
        this.columnDef = columnDef;
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return Collections.singletonList(this.columnDef);
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.columnDef;
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.columnDef;
    }

    @Override
    public boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        for (Index index : indexManager.listIndexes()) {
            if (!this.isSupportedBy(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Restriction mergeWith(Restriction otherRestriction) throws InvalidRequestException {
        if (otherRestriction.isMultiColumn() && this.canBeConvertedToMultiColumnRestriction()) {
            return this.toMultiColumnRestriction().mergeWith(otherRestriction);
        }
        return this.doMergeWith(otherRestriction);
    }

    protected abstract Restriction doMergeWith(Restriction var1) throws InvalidRequestException;

    abstract MultiColumnRestriction toMultiColumnRestriction();

    boolean canBeConvertedToMultiColumnRestriction() {
        return true;
    }

    protected abstract boolean isSupportedBy(Index var1);

    public static final class IsNotNullRestriction
    extends SingleColumnRestriction {
        public IsNotNullRestriction(ColumnDefinition columnDef) {
            super(columnDef);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        MultiColumnRestriction toMultiColumnRestriction() {
            return new MultiColumnRestriction.NotNullRestriction(Collections.singletonList(this.columnDef));
        }

        @Override
        public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) {
            throw new UnsupportedOperationException("Secondary indexes do not support IS NOT NULL restrictions");
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            throw new UnsupportedOperationException("Cannot use IS NOT NULL restriction for slicing");
        }

        public String toString() {
            return "IS NOT NULL";
        }

        @Override
        public Restriction doMergeWith(Restriction otherRestriction) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("%s cannot be restricted by a relation if it includes an IS NOT NULL", this.columnDef.name);
        }

        @Override
        protected boolean isSupportedBy(Index index) {
            return index.supportsExpression(this.columnDef, Operator.IS_NOT);
        }
    }

    public static final class ContainsRestriction
    extends SingleColumnRestriction {
        private List<Term> values = new ArrayList<Term>();
        private List<Term> keys = new ArrayList<Term>();
        private List<Term> entryKeys = new ArrayList<Term>();
        private List<Term> entryValues = new ArrayList<Term>();

        public ContainsRestriction(ColumnDefinition columnDef, Term t, boolean isKey) {
            super(columnDef);
            if (isKey) {
                this.keys.add(t);
            } else {
                this.values.add(t);
            }
        }

        public ContainsRestriction(ColumnDefinition columnDef, Term mapKey, Term mapValue) {
            super(columnDef);
            this.entryKeys.add(mapKey);
            this.entryValues.add(mapValue);
        }

        @Override
        MultiColumnRestriction toMultiColumnRestriction() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean canBeConvertedToMultiColumnRestriction() {
            return false;
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isContains() {
            return true;
        }

        @Override
        public Restriction doMergeWith(Restriction otherRestriction) throws InvalidRequestException {
            RequestValidations.checkTrue(otherRestriction.isContains(), "Collection column %s can only be restricted by CONTAINS, CONTAINS KEY, or map-entry equality", this.columnDef.name);
            ContainsRestriction newContains = new ContainsRestriction(this.columnDef);
            ContainsRestriction.copyKeysAndValues(this, newContains);
            ContainsRestriction.copyKeysAndValues((ContainsRestriction)otherRestriction, newContains);
            return newContains;
        }

        @Override
        public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
            for (ByteBuffer value : ContainsRestriction.bindAndGet(this.values, options)) {
                filter.add(this.columnDef, Operator.CONTAINS, value);
            }
            for (ByteBuffer key : ContainsRestriction.bindAndGet(this.keys, options)) {
                filter.add(this.columnDef, Operator.CONTAINS_KEY, key);
            }
            List<ByteBuffer> eks = ContainsRestriction.bindAndGet(this.entryKeys, options);
            List<ByteBuffer> evs = ContainsRestriction.bindAndGet(this.entryValues, options);
            assert (eks.size() == evs.size());
            for (int i = 0; i < eks.size(); ++i) {
                filter.addMapEquality(this.columnDef, eks.get(i), Operator.EQ, evs.get(i));
            }
        }

        @Override
        protected boolean isSupportedBy(Index index) {
            boolean supported = false;
            if (this.numberOfValues() > 0) {
                supported |= index.supportsExpression(this.columnDef, Operator.CONTAINS);
            }
            if (this.numberOfKeys() > 0) {
                supported |= index.supportsExpression(this.columnDef, Operator.CONTAINS_KEY);
            }
            if (this.numberOfEntries() > 0) {
                supported |= index.supportsExpression(this.columnDef, Operator.EQ);
            }
            return supported;
        }

        public int numberOfValues() {
            return this.values.size();
        }

        public int numberOfKeys() {
            return this.keys.size();
        }

        public int numberOfEntries() {
            return this.entryKeys.size();
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.values, functions);
            Terms.addFunctions(this.keys, functions);
            Terms.addFunctions(this.entryKeys, functions);
            Terms.addFunctions(this.entryValues, functions);
        }

        public String toString() {
            return String.format("CONTAINS(values=%s, keys=%s, entryKeys=%s, entryValues=%s)", this.values, this.keys, this.entryKeys, this.entryValues);
        }

        @Override
        public boolean hasBound(Bound b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MultiCBuilder appendBoundTo(MultiCBuilder builder, Bound bound, QueryOptions options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInclusive(Bound b) {
            throw new UnsupportedOperationException();
        }

        private static List<ByteBuffer> bindAndGet(List<Term> terms, QueryOptions options) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(terms.size());
            for (Term value : terms) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        private static void copyKeysAndValues(ContainsRestriction from, ContainsRestriction to) {
            to.values.addAll(from.values);
            to.keys.addAll(from.keys);
            to.entryKeys.addAll(from.entryKeys);
            to.entryValues.addAll(from.entryValues);
        }

        private ContainsRestriction(ColumnDefinition columnDef) {
            super(columnDef);
        }
    }

    public static class SliceRestriction
    extends SingleColumnRestriction {
        private final TermSlice slice;

        public SliceRestriction(ColumnDefinition columnDef, Bound bound, boolean inclusive, Term term) {
            super(columnDef);
            this.slice = TermSlice.newInstance(bound, inclusive, term);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.slice.addFunctionsTo(functions);
        }

        @Override
        MultiColumnRestriction toMultiColumnRestriction() {
            return new MultiColumnRestriction.SliceRestriction(Collections.singletonList(this.columnDef), this.slice);
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasBound(Bound b) {
            return this.slice.hasBound(b);
        }

        @Override
        public MultiCBuilder appendBoundTo(MultiCBuilder builder, Bound bound, QueryOptions options) {
            Bound b = SliceRestriction.reverseBoundIfNeeded(this.getFirstColumn(), bound);
            if (!this.hasBound(b)) {
                return builder;
            }
            ByteBuffer value = this.slice.bound(b).bindAndGet(options);
            RequestValidations.checkBindValueSet(value, "Invalid unset value for column %s", this.columnDef.name);
            return builder.addElementToAll(value);
        }

        @Override
        public boolean isInclusive(Bound b) {
            return this.slice.isInclusive(b);
        }

        @Override
        public Restriction doMergeWith(Restriction otherRestriction) throws InvalidRequestException {
            RequestValidations.checkTrue(otherRestriction.isSlice(), "Column \"%s\" cannot be restricted by both an equality and an inequality relation", this.columnDef.name);
            SliceRestriction otherSlice = (SliceRestriction)otherRestriction;
            RequestValidations.checkFalse(this.hasBound(Bound.START) && otherSlice.hasBound(Bound.START), "More than one restriction was found for the start bound on %s", this.columnDef.name);
            RequestValidations.checkFalse(this.hasBound(Bound.END) && otherSlice.hasBound(Bound.END), "More than one restriction was found for the end bound on %s", this.columnDef.name);
            return new SliceRestriction(this.columnDef, this.slice.merge(otherSlice.slice));
        }

        @Override
        public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
            for (Bound b : Bound.values()) {
                if (!this.hasBound(b)) continue;
                filter.add(this.columnDef, this.slice.getIndexOperator(b), this.slice.bound(b).bindAndGet(options));
            }
        }

        @Override
        protected boolean isSupportedBy(Index index) {
            return this.slice.isSupportedBy(this.columnDef, index);
        }

        public String toString() {
            return String.format("SLICE%s", this.slice);
        }

        private SliceRestriction(ColumnDefinition columnDef, TermSlice slice) {
            super(columnDef);
            this.slice = slice;
        }
    }

    public static class InRestrictionWithMarker
    extends INRestriction {
        protected final AbstractMarker marker;

        public InRestrictionWithMarker(ColumnDefinition columnDef, AbstractMarker marker) {
            super(columnDef);
            this.marker = marker;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
        }

        @Override
        MultiColumnRestriction toMultiColumnRestriction() {
            return new MultiColumnRestriction.InRestrictionWithMarker(Collections.singletonList(this.columnDef), this.marker);
        }

        @Override
        protected List<ByteBuffer> getValues(QueryOptions options) throws InvalidRequestException {
            Term.Terminal term = this.marker.bind(options);
            RequestValidations.checkNotNull(term, "Invalid null value for column %s", this.columnDef.name);
            RequestValidations.checkFalse(term == Constants.UNSET_VALUE, "Invalid unset value for column %s", this.columnDef.name);
            Term.MultiItemTerminal lval = (Term.MultiItemTerminal)term;
            return lval.getElements();
        }

        public String toString() {
            return "IN ?";
        }
    }

    public static class InRestrictionWithValues
    extends INRestriction {
        protected final List<Term> values;

        public InRestrictionWithValues(ColumnDefinition columnDef, List<Term> values) {
            super(columnDef);
            this.values = values;
        }

        @Override
        MultiColumnRestriction toMultiColumnRestriction() {
            return new MultiColumnRestriction.InRestrictionWithValues(Collections.singletonList(this.columnDef), this.values);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.values, functions);
        }

        @Override
        protected List<ByteBuffer> getValues(QueryOptions options) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
            for (Term value : this.values) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        public String toString() {
            return String.format("IN(%s)", this.values);
        }
    }

    public static abstract class INRestriction
    extends SingleColumnRestriction {
        public INRestriction(ColumnDefinition columnDef) {
            super(columnDef);
        }

        @Override
        public final boolean isIN() {
            return true;
        }

        @Override
        public final Restriction doMergeWith(Restriction otherRestriction) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes a IN", this.columnDef.name);
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            builder.addEachElementToAll(this.getValues(options));
            RequestValidations.checkFalse(builder.containsNull(), "Invalid null value in condition for column %s", this.columnDef.name);
            RequestValidations.checkFalse(builder.containsUnset(), "Invalid unset value for column %s", this.columnDef.name);
            return builder;
        }

        @Override
        public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
            List<ByteBuffer> values = this.getValues(options);
            RequestValidations.checkTrue(values.size() == 1, "IN restrictions are not supported on indexed columns");
            filter.add(this.columnDef, Operator.EQ, values.get(0));
        }

        @Override
        protected final boolean isSupportedBy(Index index) {
            return index.supportsExpression(this.columnDef, Operator.IN);
        }

        protected abstract List<ByteBuffer> getValues(QueryOptions var1) throws InvalidRequestException;
    }

    public static final class EQRestriction
    extends SingleColumnRestriction {
        private final Term value;

        public EQRestriction(ColumnDefinition columnDef, Term value) {
            super(columnDef);
            this.value = value;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.value.addFunctionsTo(functions);
        }

        @Override
        public boolean isEQ() {
            return true;
        }

        @Override
        MultiColumnRestriction toMultiColumnRestriction() {
            return new MultiColumnRestriction.EQRestriction(Collections.singletonList(this.columnDef), this.value);
        }

        @Override
        public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) {
            filter.add(this.columnDef, Operator.EQ, this.value.bindAndGet(options));
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            builder.addElementToAll(this.value.bindAndGet(options));
            RequestValidations.checkFalse(builder.containsNull(), "Invalid null value in condition for column %s", this.columnDef.name);
            RequestValidations.checkFalse(builder.containsUnset(), "Invalid unset value for column %s", this.columnDef.name);
            return builder;
        }

        public String toString() {
            return String.format("EQ(%s)", this.value);
        }

        @Override
        public Restriction doMergeWith(Restriction otherRestriction) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes an Equal", this.columnDef.name);
        }

        @Override
        protected boolean isSupportedBy(Index index) {
            return index.supportsExpression(this.columnDef, Operator.EQ);
        }
    }
}

