/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.dropwizard.MetricNameService;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import rx.Completable;
import rx.Observable;

public class MetricsInitializer {
    private static Logger logger = Logger.getLogger(MetricsInitializer.class);
    private MetricsService metricsService;
    private MetricRegistry metricRegistry;
    private MetricNameService metricNameService;

    public MetricsInitializer(MetricRegistry metricRegistry, MetricsService metricsService, MetricNameService metricNameService) {
        this.metricRegistry = metricRegistry;
        this.metricsService = metricsService;
        this.metricNameService = metricNameService;
    }

    public void run() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info((Object)"Creating metrics");
        ArrayList gaugeMetrics = new ArrayList();
        ArrayList counterMetrics = new ArrayList();
        this.metricRegistry.getMeters(this.metricNameService).entrySet().forEach(entry -> {
            String tenantId = this.metricNameService.getTenantId();
            String metricName = (String)entry.getKey();
            Map<String, String> tags = this.getTags(metricName);
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-1min"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-5min"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-15min"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-mean"), tags));
            counterMetrics.add(new Metric<Long>(new MetricId<Long>(tenantId, MetricType.COUNTER, metricName), tags));
        });
        this.metricRegistry.getTimers(this.metricNameService).entrySet().forEach(entry -> {
            String tenantId = this.metricNameService.getTenantId();
            String metricName = (String)entry.getKey();
            Map<String, String> tags = this.getTags(metricName);
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-1min"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-5min"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-15min"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-mean"), tags));
            counterMetrics.add(new Metric<Long>(new MetricId<Long>(tenantId, MetricType.COUNTER, metricName), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-median"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-max"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-min"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-stdDev"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-75p"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-95p"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-99p"), tags));
            gaugeMetrics.add(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-999p"), tags));
        });
        Completable gaugesCreated = this.createMetrics(gaugeMetrics);
        Completable countersCreated = this.createMetrics(counterMetrics);
        Completable.merge((Completable[])new Completable[]{gaugesCreated, countersCreated}).subscribe(() -> {
            stopwatch.stop();
            logger.infof("Finished creating metrics in %d ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }, t -> logger.warn((Object)"Failed to create metrics", t));
    }

    private Map<String, String> getTags(String metricName) {
        return ImmutableMap.of("hostname", this.metricNameService.getHostName(), "baseMetric", metricName, "component", "org.hawkular.metrics");
    }

    private <T> Completable createMetrics(List<Metric<T>> metrics) {
        return Observable.from(metrics).flatMap(metric -> this.metricsService.createMetric((Metric<?>)metric, true).doOnNext(aVoid -> logger.debugf("Created %s", metric))).toCompletable();
    }
}

