/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.hawkular.metrics.core.service.log.CoreLogger;
import org.hawkular.metrics.core.service.log.CoreLogging;

public class MetricsThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    private static final CoreLogger log = CoreLogging.getCoreLogger(MetricsThreadFactory.class);
    private static final String METRICS_THREAD_POOL = "MetricsThreadPool";
    private AtomicInteger threadNumber = new AtomicInteger(0);

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, "MetricsThreadPool-" + this.threadNumber.getAndIncrement());
        t.setDaemon(false);
        t.setUncaughtExceptionHandler(this);
        return t;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable t) {
        log.errorUncaughtExceptionOnScheduledThread(thread.getName(), t);
    }
}

