/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitInput;
import java.nio.ByteBuffer;

public class ByteBufferBitInput
implements BitInput {
    private ByteBuffer bb;
    private byte b;
    private int bitsLeft = 0;

    public ByteBufferBitInput(ByteBuffer buf) {
        this.bb = buf;
        this.flipByte();
    }

    public ByteBufferBitInput(byte[] input) {
        this(ByteBuffer.wrap(input));
    }

    @Override
    public boolean readBit() {
        boolean bit = (this.b >> this.bitsLeft - 1 & 1) == 1;
        --this.bitsLeft;
        this.flipByte();
        return bit;
    }

    @Override
    public long getLong(int bits) {
        long value = 0L;
        while (bits > 0) {
            byte d;
            if (bits > this.bitsLeft || bits == 8) {
                d = (byte)(this.b & (1 << this.bitsLeft) - 1);
                value = (value << this.bitsLeft) + (long)(d & 0xFF);
                bits -= this.bitsLeft;
                this.bitsLeft = 0;
            } else {
                d = (byte)(this.b >>> this.bitsLeft - bits & (1 << bits) - 1);
                value = (value << bits) + (long)(d & 0xFF);
                this.bitsLeft -= bits;
                bits = 0;
            }
            this.flipByte();
        }
        return value;
    }

    private void flipByte() {
        if (this.bitsLeft == 0) {
            this.b = this.bb.get();
            this.bitsLeft = 8;
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }
}

