/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla.benchmark;

import fi.iki.yak.ts.compression.gorilla.ByteBufferBitInput;
import fi.iki.yak.ts.compression.gorilla.ByteBufferBitOutput;
import fi.iki.yak.ts.compression.gorilla.Compressor;
import fi.iki.yak.ts.compression.gorilla.Decompressor;
import fi.iki.yak.ts.compression.gorilla.Pair;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class EncodingBenchmark {
    @Benchmark
    @OperationsPerInvocation(value=100000)
    public void encodingBenchmark(DataGenerator dg) {
        ByteBufferBitOutput output = new ByteBufferBitOutput();
        Compressor c = new Compressor(dg.blockStart, output);
        for (int j = 0; j < dg.amountOfPoints; ++j) {
            c.addValue(dg.uncompressedBuffer.getLong(), dg.uncompressedBuffer.getDouble());
        }
        c.close();
        dg.uncompressedBuffer.rewind();
    }

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public void decodingDoubleBenchmark(DataGenerator dg, Blackhole bh) throws Exception {
        Pair pair;
        ByteBuffer duplicate = dg.compressedBuffer.duplicate();
        ByteBufferBitInput input = new ByteBufferBitInput(duplicate);
        Decompressor d = new Decompressor(input);
        while ((pair = d.readPair()) != null) {
            bh.consume(pair);
        }
    }

    @State(value=Scope.Benchmark)
    public static class DataGenerator {
        public List<Pair> insertList;
        @Param(value={"100000"})
        public int amountOfPoints;
        public long blockStart;
        public ByteBuffer uncompressedBuffer;
        public ByteBuffer compressedBuffer;

        @Setup(value=Level.Trial)
        public void setup() {
            this.blockStart = LocalDateTime.now().truncatedTo(ChronoUnit.HOURS).toInstant(ZoneOffset.UTC).toEpochMilli();
            long now = this.blockStart + 60L;
            this.insertList = new ArrayList<Pair>(this.amountOfPoints);
            ByteBuffer bb = ByteBuffer.allocate(this.amountOfPoints * 2 * 8);
            for (int i = 0; i < this.amountOfPoints; ++i) {
                bb.putLong(now += 60L);
                bb.putDouble(i);
            }
            if (bb.hasArray()) {
                this.uncompressedBuffer = bb.duplicate();
                this.uncompressedBuffer.flip();
            }
            ByteBufferBitOutput output = new ByteBufferBitOutput();
            Compressor c = new Compressor(this.blockStart, output);
            bb.flip();
            for (int j = 0; j < this.amountOfPoints; ++j) {
                c.addValue(bb.getLong(), bb.getDouble());
            }
            c.close();
            ByteBuffer byteBuffer = output.getByteBuffer();
            byteBuffer.flip();
            this.compressedBuffer = byteBuffer;
        }
    }
}

