/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategyOptions;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeWindowCompactionStrategyOptions {
    private static final Logger logger = LoggerFactory.getLogger(TimeWindowCompactionStrategyOptions.class);
    protected static final TimeUnit DEFAULT_TIMESTAMP_RESOLUTION = TimeUnit.MICROSECONDS;
    protected static final TimeUnit DEFAULT_COMPACTION_WINDOW_UNIT = TimeUnit.DAYS;
    protected static final int DEFAULT_COMPACTION_WINDOW_SIZE = 1;
    protected static final int DEFAULT_EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS = 600;
    protected static final String TIMESTAMP_RESOLUTION_KEY = "timestamp_resolution";
    protected static final String COMPACTION_WINDOW_UNIT_KEY = "compaction_window_unit";
    protected static final String COMPACTION_WINDOW_SIZE_KEY = "compaction_window_size";
    protected static final String EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY = "expired_sstable_check_frequency_seconds";
    protected final int sstableWindowSize;
    protected final TimeUnit sstableWindowUnit;
    protected final TimeUnit timestampResolution;
    protected final long expiredSSTableCheckFrequency;
    SizeTieredCompactionStrategyOptions stcsOptions;
    protected static final ImmutableList<TimeUnit> validTimestampTimeUnits = ImmutableList.of(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS);
    protected static final ImmutableList<TimeUnit> validWindowTimeUnits = ImmutableList.of(TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS);

    public TimeWindowCompactionStrategyOptions(Map<String, String> options) {
        String optionValue = options.get(TIMESTAMP_RESOLUTION_KEY);
        TimeUnit timeUnit = this.timestampResolution = optionValue == null ? DEFAULT_TIMESTAMP_RESOLUTION : TimeUnit.valueOf(optionValue);
        if (this.timestampResolution != DEFAULT_TIMESTAMP_RESOLUTION) {
            logger.warn("Using a non-default timestamp_resolution {} - are you really doing inserts with USING TIMESTAMP <non_microsecond_timestamp> (or driver equivalent)?", (Object)this.timestampResolution.toString());
        }
        this.sstableWindowUnit = (optionValue = options.get(COMPACTION_WINDOW_UNIT_KEY)) == null ? DEFAULT_COMPACTION_WINDOW_UNIT : TimeUnit.valueOf(optionValue);
        optionValue = options.get(COMPACTION_WINDOW_SIZE_KEY);
        this.sstableWindowSize = optionValue == null ? 1 : Integer.parseInt(optionValue);
        optionValue = options.get(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        this.expiredSSTableCheckFrequency = TimeUnit.MILLISECONDS.convert(optionValue == null ? 600L : Long.parseLong(optionValue), TimeUnit.SECONDS);
        this.stcsOptions = new SizeTieredCompactionStrategyOptions(options);
    }

    public TimeWindowCompactionStrategyOptions() {
        this.sstableWindowUnit = DEFAULT_COMPACTION_WINDOW_UNIT;
        this.timestampResolution = DEFAULT_TIMESTAMP_RESOLUTION;
        this.sstableWindowSize = 1;
        this.expiredSSTableCheckFrequency = TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS);
        this.stcsOptions = new SizeTieredCompactionStrategyOptions();
    }

    public static Map<String, String> validateOptions(Map<String, String> options, Map<String, String> uncheckedOptions) throws ConfigurationException {
        String optionValue = options.get(TIMESTAMP_RESOLUTION_KEY);
        try {
            if (optionValue != null && !validTimestampTimeUnits.contains((Object)TimeUnit.valueOf(optionValue))) {
                throw new ConfigurationException(String.format("%s is not valid for %s", optionValue, TIMESTAMP_RESOLUTION_KEY));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("%s is not valid for %s", optionValue, TIMESTAMP_RESOLUTION_KEY));
        }
        optionValue = options.get(COMPACTION_WINDOW_UNIT_KEY);
        try {
            if (optionValue != null && !validWindowTimeUnits.contains((Object)TimeUnit.valueOf(optionValue))) {
                throw new ConfigurationException(String.format("%s is not valid for %s", optionValue, COMPACTION_WINDOW_UNIT_KEY));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("%s is not valid for %s", optionValue, COMPACTION_WINDOW_UNIT_KEY), e);
        }
        optionValue = options.get(COMPACTION_WINDOW_SIZE_KEY);
        try {
            int sstableWindowSize;
            int n = sstableWindowSize = optionValue == null ? 1 : Integer.parseInt(optionValue);
            if (sstableWindowSize < 1) {
                throw new ConfigurationException(String.format("%s must be greater than 1", 1, sstableWindowSize));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, 1), e);
        }
        optionValue = options.get(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        try {
            long expiredCheckFrequency;
            long l = expiredCheckFrequency = optionValue == null ? 600L : Long.parseLong(optionValue);
            if (expiredCheckFrequency < 0L) {
                throw new ConfigurationException(String.format("%s must not be negative, but was %d", EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY, expiredCheckFrequency));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY), e);
        }
        uncheckedOptions.remove(COMPACTION_WINDOW_SIZE_KEY);
        uncheckedOptions.remove(COMPACTION_WINDOW_UNIT_KEY);
        uncheckedOptions.remove(TIMESTAMP_RESOLUTION_KEY);
        uncheckedOptions.remove(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        uncheckedOptions = SizeTieredCompactionStrategyOptions.validateOptions(options, uncheckedOptions);
        return uncheckedOptions;
    }
}

