/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Arrays;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplittingSizeTieredCompactionWriter
extends CompactionAwareWriter {
    private static final Logger logger = LoggerFactory.getLogger(SplittingSizeTieredCompactionWriter.class);
    public static final long DEFAULT_SMALLEST_SSTABLE_BYTES = 50000000L;
    private final double[] ratios;
    private final long totalSize;
    private final Set<SSTableReader> allSSTables;
    private long currentBytesToWrite;
    private int currentRatioIndex = 0;

    public SplittingSizeTieredCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        this(cfs, directories, txn, nonExpiredSSTables, 50000000L);
    }

    public SplittingSizeTieredCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long smallestSSTable) {
        super(cfs, directories, txn, nonExpiredSSTables, false, false);
        this.allSSTables = txn.originals();
        this.totalSize = cfs.getExpectedCompactedFileSize(nonExpiredSSTables, txn.opType());
        double[] potentialRatios = new double[20];
        double currentRatio = 1.0;
        for (int i = 0; i < potentialRatios.length; ++i) {
            potentialRatios[i] = currentRatio /= 2.0;
        }
        int noPointIndex = 0;
        for (double ratio : potentialRatios) {
            ++noPointIndex;
            if (ratio * (double)this.totalSize < (double)smallestSSTable) break;
        }
        this.ratios = Arrays.copyOfRange(potentialRatios, 0, noPointIndex);
        long currentPartitionsToWrite = Math.round((double)this.estimatedTotalKeys * this.ratios[this.currentRatioIndex]);
        this.currentBytesToWrite = Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex]);
        this.switchCompactionLocation(this.getWriteDirectory(this.currentBytesToWrite));
        logger.trace("Ratios={}, expectedKeys = {}, totalSize = {}, currentPartitionsToWrite = {}, currentBytesToWrite = {}", this.ratios, this.estimatedTotalKeys, this.totalSize, currentPartitionsToWrite, this.currentBytesToWrite);
    }

    @Override
    public boolean realAppend(UnfilteredRowIterator partition) {
        RowIndexEntry rie = this.sstableWriter.append(partition);
        if (this.sstableWriter.currentWriter().getOnDiskFilePointer() > this.currentBytesToWrite && this.currentRatioIndex < this.ratios.length - 1) {
            ++this.currentRatioIndex;
            this.currentBytesToWrite = Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex]);
            this.switchCompactionLocation(this.getWriteDirectory(Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex])));
        }
        return rie != null;
    }

    @Override
    public void switchCompactionLocation(Directories.DataDirectory location) {
        long currentPartitionsToWrite = Math.round(this.ratios[this.currentRatioIndex] * (double)this.estimatedTotalKeys);
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(this.cfs.getSSTablePath(this.getDirectories().getLocationForDisk(location))), currentPartitionsToWrite, (Long)this.minRepairedAt, this.cfs.metadata, new MetadataCollector(this.allSSTables, this.cfs.metadata.comparator, 0), SerializationHeader.make(this.cfs.metadata, this.nonExpiredSSTables), this.txn);
        logger.trace("Switching writer, currentPartitionsToWrite = {}", (Object)currentPartitionsToWrite);
        this.sstableWriter.switchWriter(writer);
    }
}

