/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.StreamStateStore;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.TokenAllocation;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventNotifierSupport;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrapper
extends ProgressEventNotifierSupport {
    private static final Logger logger = LoggerFactory.getLogger(BootStrapper.class);
    protected final InetAddress address;
    protected final Collection<Token> tokens;
    protected final TokenMetadata tokenMetadata;

    public BootStrapper(InetAddress address, Collection<Token> tokens, TokenMetadata tmd) {
        assert (address != null);
        assert (tokens != null && !tokens.isEmpty());
        this.address = address;
        this.tokens = tokens;
        this.tokenMetadata = tmd;
    }

    public ListenableFuture<StreamState> bootstrap(StreamStateStore stateStore, boolean useStrictConsistency) {
        logger.trace("Beginning bootstrap process");
        RangeStreamer streamer = new RangeStreamer(this.tokenMetadata, this.tokens, this.address, "Bootstrap", useStrictConsistency, DatabaseDescriptor.getEndpointSnitch(), stateStore);
        streamer.addSourceFilter(new RangeStreamer.FailureDetectorSourceFilter(FailureDetector.instance));
        streamer.addSourceFilter(new RangeStreamer.ExcludeLocalNodeFilter());
        for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces()) {
            AbstractReplicationStrategy strategy = Keyspace.open(keyspaceName).getReplicationStrategy();
            streamer.addRanges(keyspaceName, strategy.getPendingAddressRanges(this.tokenMetadata, this.tokens, this.address));
        }
        StreamResultFuture bootstrapStreamResult = streamer.fetchAsync();
        bootstrapStreamResult.addEventListener(new StreamEventHandler(){
            private final AtomicInteger receivedFiles = new AtomicInteger();
            private final AtomicInteger totalFilesToReceive = new AtomicInteger();

            @Override
            public void handleStreamEvent(StreamEvent event) {
                switch (event.eventType) {
                    case STREAM_PREPARED: {
                        StreamEvent.SessionPreparedEvent prepared = (StreamEvent.SessionPreparedEvent)event;
                        int currentTotal = this.totalFilesToReceive.addAndGet((int)prepared.session.getTotalFilesToReceive());
                        ProgressEvent prepareProgress = new ProgressEvent(ProgressEventType.PROGRESS, this.receivedFiles.get(), currentTotal, "prepare with " + prepared.session.peer + " complete");
                        BootStrapper.this.fireProgressEvent("bootstrap", prepareProgress);
                        break;
                    }
                    case FILE_PROGRESS: {
                        StreamEvent.ProgressEvent progress = (StreamEvent.ProgressEvent)event;
                        if (!progress.progress.isCompleted()) break;
                        int received = this.receivedFiles.incrementAndGet();
                        ProgressEvent currentProgress = new ProgressEvent(ProgressEventType.PROGRESS, received, this.totalFilesToReceive.get(), "received file " + progress.progress.fileName);
                        BootStrapper.this.fireProgressEvent("bootstrap", currentProgress);
                        break;
                    }
                    case STREAM_COMPLETE: {
                        StreamEvent.SessionCompleteEvent completeEvent = (StreamEvent.SessionCompleteEvent)event;
                        ProgressEvent completeProgress = new ProgressEvent(ProgressEventType.PROGRESS, this.receivedFiles.get(), this.totalFilesToReceive.get(), "session with " + completeEvent.peer + " complete");
                        BootStrapper.this.fireProgressEvent("bootstrap", completeProgress);
                    }
                }
            }

            @Override
            public void onSuccess(StreamState streamState) {
                String message;
                ProgressEventType type;
                if (streamState.hasFailedSession()) {
                    type = ProgressEventType.ERROR;
                    message = "Some bootstrap stream failed";
                } else {
                    type = ProgressEventType.SUCCESS;
                    message = "Bootstrap streaming success";
                }
                ProgressEvent currentProgress = new ProgressEvent(type, this.receivedFiles.get(), this.totalFilesToReceive.get(), message);
                BootStrapper.this.fireProgressEvent("bootstrap", currentProgress);
            }

            @Override
            public void onFailure(Throwable throwable) {
                ProgressEvent currentProgress = new ProgressEvent(ProgressEventType.ERROR, this.receivedFiles.get(), this.totalFilesToReceive.get(), throwable.getMessage());
                BootStrapper.this.fireProgressEvent("bootstrap", currentProgress);
            }
        });
        return bootstrapStreamResult;
    }

    public static Collection<Token> getBootstrapTokens(TokenMetadata metadata, InetAddress address) throws ConfigurationException {
        String allocationKeyspace = DatabaseDescriptor.getAllocateTokensForKeyspace();
        Collection<String> initialTokens = DatabaseDescriptor.getInitialTokens();
        if (initialTokens.size() > 0 && allocationKeyspace != null) {
            logger.warn("manually specified tokens override automatic allocation");
        }
        if (initialTokens.size() > 0) {
            return BootStrapper.getSpecifiedTokens(metadata, initialTokens);
        }
        int numTokens = DatabaseDescriptor.getNumTokens();
        if (numTokens < 1) {
            throw new ConfigurationException("num_tokens must be >= 1");
        }
        if (allocationKeyspace != null) {
            return BootStrapper.allocateTokens(metadata, address, allocationKeyspace, numTokens);
        }
        if (numTokens == 1) {
            logger.warn("Picking random token for a single vnode.  You should probably add more vnodes and/or use the automatic token allocation mechanism.");
        }
        return BootStrapper.getRandomTokens(metadata, numTokens);
    }

    private static Collection<Token> getSpecifiedTokens(TokenMetadata metadata, Collection<String> initialTokens) {
        logger.trace("tokens manually specified as {}", (Object)initialTokens);
        ArrayList<Token> tokens = new ArrayList<Token>(initialTokens.size());
        for (String tokenString : initialTokens) {
            Token token = metadata.partitioner.getTokenFactory().fromString(tokenString);
            if (metadata.getEndpoint(token) != null) {
                throw new ConfigurationException("Bootstrapping to existing token " + tokenString + " is not allowed (decommission/removenode the old node first).");
            }
            tokens.add(token);
        }
        return tokens;
    }

    static Collection<Token> allocateTokens(TokenMetadata metadata, InetAddress address, String allocationKeyspace, int numTokens) {
        Keyspace ks = Keyspace.open(allocationKeyspace);
        if (ks == null) {
            throw new ConfigurationException("Problem opening token allocation keyspace " + allocationKeyspace);
        }
        AbstractReplicationStrategy rs = ks.getReplicationStrategy();
        return TokenAllocation.allocateTokens(metadata, rs, address, numTokens);
    }

    public static Collection<Token> getRandomTokens(TokenMetadata metadata, int numTokens) {
        HashSet<Token> tokens = new HashSet<Token>(numTokens);
        while (tokens.size() < numTokens) {
            Token token = metadata.partitioner.getRandomToken();
            if (metadata.getEndpoint(token) != null) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static class StringSerializer
    implements IVersionedSerializer<String> {
        public static final StringSerializer instance = new StringSerializer();

        @Override
        public void serialize(String s, DataOutputPlus out, int version) throws IOException {
            out.writeUTF(s);
        }

        @Override
        public String deserialize(DataInputPlus in, int version) throws IOException {
            return in.readUTF();
        }

        @Override
        public long serializedSize(String s, int version) {
            return TypeSizes.sizeof(s);
        }
    }
}

