/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.StreamingHistogram;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class StatsMetadata
extends MetadataComponent {
    public static final IMetadataComponentSerializer serializer = new StatsMetadataSerializer();
    public static final ISerializer<IntervalSet<ReplayPosition>> replayPositionSetSerializer = IntervalSet.serializer(ReplayPosition.serializer);
    public final EstimatedHistogram estimatedPartitionSize;
    public final EstimatedHistogram estimatedColumnCount;
    public final IntervalSet<ReplayPosition> commitLogIntervals;
    public final long minTimestamp;
    public final long maxTimestamp;
    public final int minLocalDeletionTime;
    public final int maxLocalDeletionTime;
    public final int minTTL;
    public final int maxTTL;
    public final double compressionRatio;
    public final StreamingHistogram estimatedTombstoneDropTime;
    public final int sstableLevel;
    public final List<ByteBuffer> minClusteringValues;
    public final List<ByteBuffer> maxClusteringValues;
    public final boolean hasLegacyCounterShards;
    public final long repairedAt;
    public final long totalColumnsSet;
    public final long totalRows;

    public StatsMetadata(EstimatedHistogram estimatedPartitionSize, EstimatedHistogram estimatedColumnCount, IntervalSet<ReplayPosition> commitLogIntervals, long minTimestamp, long maxTimestamp, int minLocalDeletionTime, int maxLocalDeletionTime, int minTTL, int maxTTL, double compressionRatio, StreamingHistogram estimatedTombstoneDropTime, int sstableLevel, List<ByteBuffer> minClusteringValues, List<ByteBuffer> maxClusteringValues, boolean hasLegacyCounterShards, long repairedAt, long totalColumnsSet, long totalRows) {
        this.estimatedPartitionSize = estimatedPartitionSize;
        this.estimatedColumnCount = estimatedColumnCount;
        this.commitLogIntervals = commitLogIntervals;
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.minLocalDeletionTime = minLocalDeletionTime;
        this.maxLocalDeletionTime = maxLocalDeletionTime;
        this.minTTL = minTTL;
        this.maxTTL = maxTTL;
        this.compressionRatio = compressionRatio;
        this.estimatedTombstoneDropTime = estimatedTombstoneDropTime;
        this.sstableLevel = sstableLevel;
        this.minClusteringValues = minClusteringValues;
        this.maxClusteringValues = maxClusteringValues;
        this.hasLegacyCounterShards = hasLegacyCounterShards;
        this.repairedAt = repairedAt;
        this.totalColumnsSet = totalColumnsSet;
        this.totalRows = totalRows;
    }

    @Override
    public MetadataType getType() {
        return MetadataType.STATS;
    }

    public double getEstimatedDroppableTombstoneRatio(int gcBefore) {
        long estimatedColumnCount = this.estimatedColumnCount.mean() * this.estimatedColumnCount.count();
        if (estimatedColumnCount > 0L) {
            double droppable = this.getDroppableTombstonesBefore(gcBefore);
            return droppable / (double)estimatedColumnCount;
        }
        return 0.0;
    }

    public double getDroppableTombstonesBefore(int gcBefore) {
        return this.estimatedTombstoneDropTime.sum(gcBefore);
    }

    public StatsMetadata mutateLevel(int newLevel) {
        return new StatsMetadata(this.estimatedPartitionSize, this.estimatedColumnCount, this.commitLogIntervals, this.minTimestamp, this.maxTimestamp, this.minLocalDeletionTime, this.maxLocalDeletionTime, this.minTTL, this.maxTTL, this.compressionRatio, this.estimatedTombstoneDropTime, newLevel, this.minClusteringValues, this.maxClusteringValues, this.hasLegacyCounterShards, this.repairedAt, this.totalColumnsSet, this.totalRows);
    }

    public StatsMetadata mutateRepairedAt(long newRepairedAt) {
        return new StatsMetadata(this.estimatedPartitionSize, this.estimatedColumnCount, this.commitLogIntervals, this.minTimestamp, this.maxTimestamp, this.minLocalDeletionTime, this.maxLocalDeletionTime, this.minTTL, this.maxTTL, this.compressionRatio, this.estimatedTombstoneDropTime, this.sstableLevel, this.minClusteringValues, this.maxClusteringValues, this.hasLegacyCounterShards, newRepairedAt, this.totalColumnsSet, this.totalRows);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsMetadata that = (StatsMetadata)o;
        return new EqualsBuilder().append(this.estimatedPartitionSize, that.estimatedPartitionSize).append(this.estimatedColumnCount, that.estimatedColumnCount).append(this.commitLogIntervals, that.commitLogIntervals).append(this.minTimestamp, that.minTimestamp).append(this.maxTimestamp, that.maxTimestamp).append(this.minLocalDeletionTime, that.minLocalDeletionTime).append(this.maxLocalDeletionTime, that.maxLocalDeletionTime).append(this.minTTL, that.minTTL).append(this.maxTTL, that.maxTTL).append(this.compressionRatio, that.compressionRatio).append(this.estimatedTombstoneDropTime, that.estimatedTombstoneDropTime).append(this.sstableLevel, that.sstableLevel).append(this.repairedAt, that.repairedAt).append(this.maxClusteringValues, that.maxClusteringValues).append(this.minClusteringValues, that.minClusteringValues).append(this.hasLegacyCounterShards, that.hasLegacyCounterShards).append(this.totalColumnsSet, that.totalColumnsSet).append(this.totalRows, that.totalRows).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.estimatedPartitionSize).append(this.estimatedColumnCount).append(this.commitLogIntervals).append(this.minTimestamp).append(this.maxTimestamp).append(this.minLocalDeletionTime).append(this.maxLocalDeletionTime).append(this.minTTL).append(this.maxTTL).append(this.compressionRatio).append(this.estimatedTombstoneDropTime).append(this.sstableLevel).append(this.repairedAt).append(this.maxClusteringValues).append(this.minClusteringValues).append(this.hasLegacyCounterShards).append(this.totalColumnsSet).append(this.totalRows).build();
    }

    public static class StatsMetadataSerializer
    implements IMetadataComponentSerializer<StatsMetadata> {
        @Override
        public int serializedSize(Version version, StatsMetadata component) throws IOException {
            int size = 0;
            size = (int)((long)size + EstimatedHistogram.serializer.serializedSize(component.estimatedPartitionSize));
            size = (int)((long)size + EstimatedHistogram.serializer.serializedSize(component.estimatedColumnCount));
            size = (int)((long)size + ReplayPosition.serializer.serializedSize(component.commitLogIntervals.upperBound().orElse(ReplayPosition.NONE)));
            size = version.storeRows() ? (size += 48) : (size += 36);
            size = (int)((long)size + StreamingHistogram.serializer.serializedSize(component.estimatedTombstoneDropTime));
            size += TypeSizes.sizeof(component.sstableLevel);
            size += 4;
            for (ByteBuffer value : component.minClusteringValues) {
                size += 2 + value.remaining();
            }
            size += 4;
            for (ByteBuffer value : component.maxClusteringValues) {
                size += 2 + value.remaining();
            }
            size += TypeSizes.sizeof(component.hasLegacyCounterShards);
            if (version.storeRows()) {
                size += 16;
            }
            if (version.hasCommitLogLowerBound()) {
                size = (int)((long)size + ReplayPosition.serializer.serializedSize(component.commitLogIntervals.lowerBound().orElse(ReplayPosition.NONE)));
            }
            if (version.hasCommitLogIntervals()) {
                size = (int)((long)size + replayPositionSetSerializer.serializedSize(component.commitLogIntervals));
            }
            return size;
        }

        @Override
        public void serialize(Version version, StatsMetadata component, DataOutputPlus out) throws IOException {
            EstimatedHistogram.serializer.serialize(component.estimatedPartitionSize, out);
            EstimatedHistogram.serializer.serialize(component.estimatedColumnCount, out);
            ReplayPosition.serializer.serialize(component.commitLogIntervals.upperBound().orElse(ReplayPosition.NONE), out);
            out.writeLong(component.minTimestamp);
            out.writeLong(component.maxTimestamp);
            if (version.storeRows()) {
                out.writeInt(component.minLocalDeletionTime);
            }
            out.writeInt(component.maxLocalDeletionTime);
            if (version.storeRows()) {
                out.writeInt(component.minTTL);
                out.writeInt(component.maxTTL);
            }
            out.writeDouble(component.compressionRatio);
            StreamingHistogram.serializer.serialize(component.estimatedTombstoneDropTime, out);
            out.writeInt(component.sstableLevel);
            out.writeLong(component.repairedAt);
            out.writeInt(component.minClusteringValues.size());
            for (ByteBuffer value : component.minClusteringValues) {
                ByteBufferUtil.writeWithShortLength(value, out);
            }
            out.writeInt(component.maxClusteringValues.size());
            for (ByteBuffer value : component.maxClusteringValues) {
                ByteBufferUtil.writeWithShortLength(value, out);
            }
            out.writeBoolean(component.hasLegacyCounterShards);
            if (version.storeRows()) {
                out.writeLong(component.totalColumnsSet);
                out.writeLong(component.totalRows);
            }
            if (version.hasCommitLogLowerBound()) {
                ReplayPosition.serializer.serialize(component.commitLogIntervals.lowerBound().orElse(ReplayPosition.NONE), out);
            }
            if (version.hasCommitLogIntervals()) {
                replayPositionSetSerializer.serialize(component.commitLogIntervals, out);
            }
        }

        @Override
        public StatsMetadata deserialize(Version version, DataInputPlus in) throws IOException {
            long totalRows;
            EstimatedHistogram partitionSizes = EstimatedHistogram.serializer.deserialize(in);
            EstimatedHistogram columnCounts = EstimatedHistogram.serializer.deserialize(in);
            ReplayPosition commitLogLowerBound = ReplayPosition.NONE;
            ReplayPosition commitLogUpperBound = ReplayPosition.serializer.deserialize(in);
            long minTimestamp = in.readLong();
            long maxTimestamp = in.readLong();
            int minLocalDeletionTime = version.storeRows() ? in.readInt() : Integer.MAX_VALUE;
            int maxLocalDeletionTime = in.readInt();
            int minTTL = version.storeRows() ? in.readInt() : 0;
            int maxTTL = version.storeRows() ? in.readInt() : Integer.MAX_VALUE;
            double compressionRatio = in.readDouble();
            StreamingHistogram tombstoneHistogram = StreamingHistogram.serializer.deserialize(in);
            int sstableLevel = in.readInt();
            long repairedAt = 0L;
            if (version.hasRepairedAt()) {
                repairedAt = in.readLong();
            }
            int colCount = in.readInt();
            ArrayList<ByteBuffer> minClusteringValues = new ArrayList<ByteBuffer>(colCount);
            for (int i = 0; i < colCount; ++i) {
                minClusteringValues.add(ByteBufferUtil.readWithShortLength(in));
            }
            colCount = in.readInt();
            ArrayList<ByteBuffer> maxClusteringValues = new ArrayList<ByteBuffer>(colCount);
            for (int i = 0; i < colCount; ++i) {
                maxClusteringValues.add(ByteBufferUtil.readWithShortLength(in));
            }
            boolean hasLegacyCounterShards = true;
            if (version.tracksLegacyCounterShards()) {
                hasLegacyCounterShards = in.readBoolean();
            }
            long totalColumnsSet = version.storeRows() ? in.readLong() : -1L;
            long l = totalRows = version.storeRows() ? in.readLong() : -1L;
            if (version.hasCommitLogLowerBound()) {
                commitLogLowerBound = ReplayPosition.serializer.deserialize(in);
            }
            IntervalSet<ReplayPosition> commitLogIntervals = version.hasCommitLogIntervals() ? replayPositionSetSerializer.deserialize(in) : new IntervalSet<ReplayPosition>(commitLogLowerBound, commitLogUpperBound);
            return new StatsMetadata(partitionSizes, columnCounts, commitLogIntervals, minTimestamp, maxTimestamp, minLocalDeletionTime, maxLocalDeletionTime, minTTL, maxTTL, compressionRatio, tombstoneHistogram, sstableLevel, minClusteringValues, maxClusteringValues, hasLegacyCounterShards, repairedAt, totalColumnsSet, totalRows);
        }
    }
}

