/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractWriteResponseHandler;

public class DatacenterSyncWriteResponseHandler<T>
extends AbstractWriteResponseHandler<T> {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private final Map<String, AtomicInteger> responses = new HashMap<String, AtomicInteger>();
    private final AtomicInteger acks = new AtomicInteger(0);

    public DatacenterSyncWriteResponseHandler(Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Keyspace keyspace, Runnable callback, WriteType writeType) {
        super(keyspace, naturalEndpoints, pendingEndpoints, consistencyLevel, callback, writeType);
        assert (consistencyLevel == ConsistencyLevel.EACH_QUORUM);
        NetworkTopologyStrategy strategy = (NetworkTopologyStrategy)keyspace.getReplicationStrategy();
        for (String dc : strategy.getDatacenters()) {
            int rf = strategy.getReplicationFactor(dc);
            this.responses.put(dc, new AtomicInteger(rf / 2 + 1));
        }
        for (InetAddress pending : pendingEndpoints) {
            this.responses.get(snitch.getDatacenter(pending)).incrementAndGet();
        }
    }

    @Override
    public void response(MessageIn<T> message) {
        String dataCenter = message == null ? DatabaseDescriptor.getLocalDataCenter() : snitch.getDatacenter(message.from);
        this.responses.get(dataCenter).getAndDecrement();
        this.acks.incrementAndGet();
        for (AtomicInteger i : this.responses.values()) {
            if (i.get() <= 0) continue;
            return;
        }
        this.signal();
    }

    @Override
    protected int ackCount() {
        return this.acks.get();
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

