/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MetricNameService
implements MetricFilter {
    private static final String separator = ":";
    private final String adminTenant;
    private final String hostname;

    public MetricNameService() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to get hostname", e);
        }
        this.adminTenant = "admin";
    }

    public MetricNameService(String adminTenant) {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to get hostname", e);
        }
        this.adminTenant = adminTenant;
    }

    public MetricNameService(String hostname, String adminTenant) {
        this.hostname = hostname;
        this.adminTenant = adminTenant;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getTenantId() {
        return this.adminTenant;
    }

    public String createMetricName(String metric) {
        Preconditions.checkArgument(!metric.contains(separator), metric + " is an invalid metric name. Metric names cannot include " + separator);
        return this.hostname + separator + metric;
    }

    public String getMetricName(String metric) {
        Preconditions.checkArgument(metric.startsWith(this.hostname + separator), "%s is not a supported metric name format", metric);
        return metric.substring((this.hostname + separator).length());
    }

    @Override
    public boolean matches(String name, Metric metric) {
        return name.startsWith(this.hostname + separator);
    }
}

