/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.rx.cassandra.driver.RxSession;
import rx.Completable;
import rx.functions.Func1;

public class DeleteMetric
implements Func1<JobDetails, Completable> {
    private RxSession session;
    private PreparedStatement deleteData;
    private PreparedStatement deleteFromMetricsIndex;

    public DeleteMetric(RxSession session) {
        this.session = session;
        this.deleteData = session.getSession().prepare("DELETE FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = 0");
        this.deleteFromMetricsIndex = session.getSession().prepare("DELETE FROM metrics_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
    }

    private Completable deleteData(String tenantId, MetricType<?> type, String metricName) {
        return this.session.execute((Statement)this.deleteData.bind(tenantId, type.getCode(), metricName)).toCompletable();
    }

    private Completable deleteFromMetricsIndex(String tenantId, MetricType<?> type, String metricName) {
        return this.session.execute((Statement)this.deleteFromMetricsIndex.bind(tenantId, type.getCode(), metricName)).toCompletable();
    }

    public Completable call(JobDetails jobDetails) {
        String tenantId = jobDetails.getParameters().get("tenantId");
        MetricType<?> type = MetricType.fromTextCode(jobDetails.getParameters().get("metricType"));
        String metricName = jobDetails.getParameters().get("metricName");
        return this.deleteData(tenantId, type, metricName).mergeWith(this.deleteFromMetricsIndex(tenantId, type, metricName));
    }
}

