/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.compress;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class TagsSerializer {
    private ByteBuffer bb = ByteBuffer.allocate(135168);
    private int MAX_SIZE = 255;
    private long blockStart;
    public static byte SIMPLE_SERIALIZER = (byte)16;

    public TagsSerializer(long blockStart) {
        this.bb.put(SIMPLE_SERIALIZER);
        this.blockStart = blockStart;
    }

    public void addDataPointTags(long timestamp, Map<String, String> tags) {
        if (tags.entrySet().size() > this.MAX_SIZE) {
            throw new RuntimeException("Single datapoint can only store max of " + this.MAX_SIZE + " tags");
        }
        long delta = timestamp - this.blockStart;
        this.bb.putInt((int)delta);
        this.bb.put((byte)tags.entrySet().size());
        for (Map.Entry<String, String> tagEntry : tags.entrySet()) {
            byte[] key = tagEntry.getKey().getBytes(StandardCharsets.UTF_8);
            byte[] value = tagEntry.getValue().getBytes(StandardCharsets.UTF_8);
            if (key.length > this.MAX_SIZE || value.length > this.MAX_SIZE) {
                throw new RuntimeException("Could not store pair key->" + tagEntry.getKey() + ", value->" + tagEntry.getValue() + ", they exceed max length of " + this.MAX_SIZE + " bytes");
            }
            this.bb.put((byte)key.length);
            this.bb.put((byte)value.length);
            this.bb.put(key);
            this.bb.put(value);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }
}

