/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.hawkular.metrics.core.service.PercentileWrapper;
import org.hawkular.metrics.core.service.transformers.NumericDataPointCollector;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Percentile;
import org.hawkular.metrics.model.TaggedBucketPoint;

public class TaggedDataPointCollector {
    private Map<String, String> tags;
    private int samples = 0;
    private Min min = new Min();
    private Mean average = new Mean();
    private Max max = new Max();
    private Sum sum = new Sum();
    private List<PercentileWrapper> percentiles;
    private List<Percentile> percentileList;

    public TaggedDataPointCollector(Map<String, String> tags, List<Percentile> percentilesList) {
        this.tags = tags;
        this.percentiles = new ArrayList<PercentileWrapper>(percentilesList.size() + 1);
        this.percentileList = percentilesList;
        percentilesList.stream().forEach(d -> this.percentiles.add(NumericDataPointCollector.createPercentile.apply(d.getQuantile())));
        this.percentiles.add(NumericDataPointCollector.createPercentile.apply(50.0));
    }

    public void increment(DataPoint<? extends Number> dataPoint) {
        Number value = dataPoint.getValue();
        this.min.increment(value.doubleValue());
        this.average.increment(value.doubleValue());
        this.max.increment(value.doubleValue());
        this.sum.increment(value.doubleValue());
        ++this.samples;
        this.percentiles.stream().forEach(p -> p.addValue(value.doubleValue()));
    }

    public TaggedBucketPoint toBucketPoint() {
        ArrayList<Percentile> percentileReturns = new ArrayList<Percentile>(this.percentileList.size());
        if (this.percentileList.size() > 0) {
            for (int i = 0; i < this.percentileList.size(); ++i) {
                Percentile p = this.percentileList.get(i);
                PercentileWrapper pw = this.percentiles.get(i);
                percentileReturns.add(new Percentile(p.getOriginalQuantile(), pw.getResult()));
            }
        }
        return new TaggedBucketPoint(this.tags, this.min.getResult(), this.average.getResult(), this.percentiles.get(this.percentiles.size() - 1).getResult(), this.max.getResult(), this.sum.getResult(), this.samples, percentileReturns);
    }
}

