/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model.param;

import com.google.common.base.MoreObjects;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.model.Utils;
import org.hawkular.metrics.model.param.Duration;

public class TimeRange {
    static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    private long start;
    private long end;
    private boolean valid;
    private String problem;

    public TimeRange(String start, String end) {
        long now = System.currentTimeMillis();
        try {
            this.start = start == null || start.isEmpty() ? now - EIGHT_HOURS : this.handleOffsets(start);
            long l = this.end = end == null || end.isEmpty() ? now : this.handleOffsets(end);
            if (!Utils.isValidTimeRange(this.start, this.end)) {
                this.valid = false;
                this.problem = "Range end must be strictly greater than start";
            } else {
                this.valid = true;
                this.problem = null;
            }
        }
        catch (NumberFormatException e) {
            this.valid = false;
            this.problem = "The start (" + start + ") or end (" + end + ") value does not correspond to a valid number.";
        }
        catch (IllegalArgumentException e) {
            this.valid = false;
            this.problem = "The start (" + start + ") or end (" + end + ") value does not correspond to a valid duration.";
        }
    }

    private Long handleOffsets(String number) throws NumberFormatException, IllegalArgumentException {
        long now = System.currentTimeMillis();
        if (number.startsWith("+")) {
            String offset = number.substring(1).trim();
            Duration duration = new Duration(offset);
            return now + duration.toMillis();
        }
        if (number.startsWith("-")) {
            String offset = number.substring(1).trim();
            Duration duration = new Duration(offset);
            return now - duration.toMillis();
        }
        return Long.parseLong(number);
    }

    public TimeRange(Long start, Long end) {
        this(start == null ? null : start.toString(), end == null ? null : end.toString());
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getProblem() {
        return this.problem;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("start", this.start).add("end", this.end).add("valid", this.valid).add("problem", this.problem).omitNullValues().toString();
    }
}

