/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.ObjectUtils;

public class Range<T extends RingPosition<T>>
extends AbstractBounds<T>
implements Comparable<Range<T>>,
Serializable {
    public static final long serialVersionUID = 1L;

    public Range(T left, T right) {
        super(left, right);
    }

    public static <T extends RingPosition<T>> boolean contains(T left, T right, T point) {
        if (Range.isWrapAround(left, right)) {
            if (point.compareTo(left) > 0) {
                return true;
            }
            return right.compareTo(point) >= 0;
        }
        return point.compareTo(left) > 0 && right.compareTo(point) >= 0;
    }

    @Override
    public boolean contains(Range<T> that) {
        boolean thatwraps;
        if (this.left.equals(this.right)) {
            return true;
        }
        boolean thiswraps = Range.isWrapAround(this.left, this.right);
        if (thiswraps == (thatwraps = Range.isWrapAround(that.left, that.right))) {
            return this.left.compareTo(that.left) <= 0 && that.right.compareTo(this.right) <= 0;
        }
        if (thiswraps) {
            return this.left.compareTo(that.left) <= 0 || that.right.compareTo(this.right) <= 0;
        }
        return false;
    }

    @Override
    public boolean contains(T point) {
        return Range.contains(this.left, this.right, point);
    }

    public boolean intersects(Range<T> that) {
        return this.intersectionWith(that).size() > 0;
    }

    public boolean intersects(AbstractBounds<T> that) {
        if (that instanceof Range) {
            return this.intersects((Range)that);
        }
        if (that instanceof Bounds) {
            return this.intersects((Bounds)that);
        }
        throw new UnsupportedOperationException("Intersection is only supported for Bounds and Range objects; found " + that.getClass());
    }

    public boolean intersects(Bounds<T> that) {
        return this.contains(that.left) || !that.left.equals(that.right) && this.intersects(new Range<RingPosition>(that.left, that.right));
    }

    @SafeVarargs
    public static <T extends RingPosition<T>> Set<Range<T>> rangeSet(Range<T> ... ranges) {
        return Collections.unmodifiableSet(new HashSet<Range<T>>(Arrays.asList(ranges)));
    }

    public static <T extends RingPosition<T>> Set<Range<T>> rangeSet(Range<T> range) {
        return Collections.singleton(range);
    }

    public Set<Range<T>> intersectionWith(Range<T> that) {
        if (that.contains(this)) {
            return Range.rangeSet(this);
        }
        if (this.contains((T)that)) {
            return Range.rangeSet(that);
        }
        boolean thiswraps = Range.isWrapAround(this.left, this.right);
        boolean thatwraps = Range.isWrapAround(that.left, that.right);
        if (!thiswraps && !thatwraps) {
            if (this.left.compareTo(that.right) >= 0 || that.left.compareTo(this.right) >= 0) {
                return Collections.emptySet();
            }
            return Range.rangeSet(new Range<RingPosition>((RingPosition)ObjectUtils.max((Comparable[])new RingPosition[]{this.left, that.left}), (RingPosition)ObjectUtils.min((Comparable[])new RingPosition[]{this.right, that.right})));
        }
        if (thiswraps && thatwraps) {
            assert (!this.left.equals(that.left));
            return this.left.compareTo(that.left) < 0 ? Range.intersectionBothWrapping(this, that) : Range.intersectionBothWrapping(that, this);
        }
        if (thiswraps && !thatwraps) {
            return Range.intersectionOneWrapping(this, that);
        }
        assert (!thiswraps && thatwraps);
        return Range.intersectionOneWrapping(that, this);
    }

    private static <T extends RingPosition<T>> Set<Range<T>> intersectionBothWrapping(Range<T> first, Range<T> that) {
        HashSet<Range<RingPosition>> intersection = new HashSet<Range<RingPosition>>(2);
        if (that.right.compareTo(first.left) > 0) {
            intersection.add(new Range<RingPosition>(first.left, that.right));
        }
        intersection.add(new Range<RingPosition>(that.left, first.right));
        return Collections.unmodifiableSet(intersection);
    }

    private static <T extends RingPosition<T>> Set<Range<T>> intersectionOneWrapping(Range<T> wrapping, Range<T> other) {
        HashSet<Range<RingPosition>> intersection = new HashSet<Range<RingPosition>>(2);
        if (other.contains(wrapping.right)) {
            intersection.add(new Range<RingPosition>(other.left, wrapping.right));
        }
        if (other.contains(wrapping.left) && wrapping.left.compareTo(other.right) < 0) {
            intersection.add(new Range<RingPosition>(wrapping.left, other.right));
        }
        return Collections.unmodifiableSet(intersection);
    }

    @Override
    public Pair<AbstractBounds<T>, AbstractBounds<T>> split(T position) {
        assert (this.contains(position) || this.left.equals(position));
        if (position.equals(this.left) || position.equals(this.right)) {
            return null;
        }
        Range<RingPosition> lb = new Range<RingPosition>(this.left, (RingPosition)position);
        Range<RingPosition> rb = new Range<RingPosition>((RingPosition)position, this.right);
        return Pair.create(lb, rb);
    }

    @Override
    public boolean inclusiveLeft() {
        return false;
    }

    @Override
    public boolean inclusiveRight() {
        return true;
    }

    @Override
    public List<Range<T>> unwrap() {
        Object minValue = this.right.minValue();
        if (!this.isWrapAround() || this.right.equals(minValue)) {
            return Arrays.asList(this);
        }
        ArrayList<Range<T>> unwrapped = new ArrayList<Range<T>>(2);
        unwrapped.add(new Range<RingPosition>(this.left, (RingPosition)minValue));
        unwrapped.add(new Range<RingPosition>((RingPosition)minValue, this.right));
        return unwrapped;
    }

    public static <T extends RingPosition<T>> boolean isWrapAround(T left, T right) {
        return left.compareTo(right) >= 0;
    }

    @Override
    public int compareTo(Range<T> rhs) {
        boolean rhsWrap;
        boolean lhsWrap = Range.isWrapAround(this.left, this.right);
        if (lhsWrap != (rhsWrap = Range.isWrapAround(rhs.left, rhs.right))) {
            return Boolean.compare(!lhsWrap, !rhsWrap);
        }
        return this.right.compareTo(rhs.right);
    }

    private ArrayList<Range<T>> subtractContained(Range<T> contained) {
        ArrayList<Range<T>> difference = new ArrayList<Range<T>>(2);
        if (!this.left.equals(contained.left)) {
            difference.add(new Range<RingPosition>(this.left, contained.left));
        }
        if (!this.right.equals(contained.right)) {
            difference.add(new Range<RingPosition>(contained.right, this.right));
        }
        return difference;
    }

    public Set<Range<T>> subtract(Range<T> rhs) {
        return rhs.differenceToFetch(this);
    }

    public Set<Range<T>> subtractAll(Collection<Range<T>> ranges) {
        Set<Range<T>> result = new HashSet<Range<T>>();
        result.add(this);
        for (Range<T> range : ranges) {
            result = Range.substractAllFromToken(result, range);
        }
        return result;
    }

    private static <T extends RingPosition<T>> Set<Range<T>> substractAllFromToken(Set<Range<T>> ranges, Range<T> subtract) {
        HashSet<Range<T>> result = new HashSet<Range<T>>();
        for (Range<T> range : ranges) {
            result.addAll(range.subtract(subtract));
        }
        return result;
    }

    public Set<Range<T>> differenceToFetch(Range<T> rhs) {
        HashSet<Range<T>> result;
        Set<Range<Range>> intersectionSet = this.intersectionWith(rhs);
        if (intersectionSet.isEmpty()) {
            result = new HashSet<Range<T>>();
            result.add(rhs);
        } else {
            Range[] intersections = new Range[intersectionSet.size()];
            intersectionSet.toArray(intersections);
            if (intersections.length == 1) {
                result = new HashSet<Range<T>>(super.subtractContained(intersections[0]));
            } else {
                Range first = intersections[0];
                Range second = intersections[1];
                ArrayList<Range<T>> temp = super.subtractContained(first);
                Range<T> single = temp.get(0);
                result = new HashSet<Range<T>>(super.subtractContained(second));
            }
        }
        return result;
    }

    public static <T extends RingPosition<T>> boolean isInRanges(T token, Iterable<Range<T>> ranges) {
        assert (ranges != null);
        for (Range<T> range : ranges) {
            if (!range.contains(token)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Range)) {
            return false;
        }
        Range rhs = (Range)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "(" + this.left + "," + this.right + "]";
    }

    @Override
    protected String getOpeningString() {
        return "(";
    }

    @Override
    protected String getClosingString() {
        return "]";
    }

    @Override
    public boolean isStartInclusive() {
        return false;
    }

    @Override
    public boolean isEndInclusive() {
        return true;
    }

    public List<String> asList() {
        ArrayList<String> ret = new ArrayList<String>(2);
        ret.add(this.left.toString());
        ret.add(this.right.toString());
        return ret;
    }

    public boolean isWrapAround() {
        return Range.isWrapAround(this.left, this.right);
    }

    public static <T extends RingPosition<T>> List<Range<T>> normalize(Collection<Range<T>> ranges) {
        ArrayList<Range<T>> output = new ArrayList<Range<T>>(ranges.size());
        for (Range<T> range : ranges) {
            output.addAll(range.unwrap());
        }
        Collections.sort(output, new Comparator<Range<T>>(){

            @Override
            public int compare(Range<T> b1, Range<T> b2) {
                return b1.left.compareTo(b2.left);
            }
        });
        return Range.deoverlap(output);
    }

    private static <T extends RingPosition<T>> List<Range<T>> deoverlap(List<Range<T>> ranges) {
        if (ranges.isEmpty()) {
            return ranges;
        }
        ArrayList<Range<T>> output = new ArrayList<Range<T>>();
        Iterator<Range<T>> iter2 = ranges.iterator();
        Range<Object> current = iter2.next();
        Object min = current.left.minValue();
        while (iter2.hasNext()) {
            if (current.right.equals(min)) {
                if (current.left.equals(min)) {
                    return Collections.singletonList(current);
                }
                output.add(new Range<RingPosition>(current.left, (RingPosition)min));
                return output;
            }
            Range<T> next = iter2.next();
            if (next.left.compareTo(current.right) <= 0) {
                if (!next.right.equals(min) && current.right.compareTo(next.right) >= 0) continue;
                current = new Range<RingPosition>(current.left, next.right);
                continue;
            }
            output.add(current);
            current = next;
        }
        output.add(current);
        return output;
    }

    @Override
    public AbstractBounds<T> withNewRight(T newRight) {
        return new Range<RingPosition>(this.left, (RingPosition)newRight);
    }

    public static Range<PartitionPosition> makeRowRange(Token left, Token right) {
        return new Range<PartitionPosition>(left.maxKeyBound(), right.maxKeyBound());
    }

    public static Range<PartitionPosition> makeRowRange(Range<Token> tokenBounds) {
        return Range.makeRowRange((Token)tokenBounds.left, (Token)tokenBounds.right);
    }

    public static class OrderedRangeContainmentChecker {
        private final Iterator<Range<Token>> normalizedRangesIterator;
        private Token lastToken = null;
        private Range<Token> currentRange;

        public OrderedRangeContainmentChecker(Collection<Range<Token>> ranges) {
            this.normalizedRangesIterator = Range.normalize(ranges).iterator();
            assert (this.normalizedRangesIterator.hasNext());
            this.currentRange = this.normalizedRangesIterator.next();
        }

        public boolean contains(Token t) {
            assert (this.lastToken == null || this.lastToken.compareTo(t) <= 0);
            this.lastToken = t;
            while (t.compareTo(this.currentRange.left) > 0) {
                if (t.compareTo(this.currentRange.right) <= 0 || ((Token)this.currentRange.right).compareTo(this.currentRange.left) <= 0) {
                    return true;
                }
                if (!this.normalizedRangesIterator.hasNext()) {
                    return false;
                }
                this.currentRange = this.normalizedRangesIterator.next();
            }
            return false;
        }
    }
}

