/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.dropwizard.MetricNameService;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import rx.Observable;

public class DropWizardReporter
extends ScheduledReporter {
    private static Logger logger = Logger.getLogger(DropWizardReporter.class);
    public static final String REPORTER_NAME = "hawkular-metrics-reporter";
    private MetricNameService metricNameService;
    private MetricsService metricsService;

    public DropWizardReporter(MetricRegistry registry, MetricNameService metricNameService, MetricsService metricsService) {
        super(registry, REPORTER_NAME, metricNameService, TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.metricsService = metricsService;
        this.metricNameService = metricNameService;
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = System.currentTimeMillis();
        Observable gaugeObservable = Observable.from(gauges.entrySet()).map(entry -> new Metric<Double>(this.getMetricId((String)entry.getKey(), MetricType.GAUGE), Collections.singletonList(new DataPoint<Double>(timestamp, (Double)((Gauge)entry.getValue()).getValue()))));
        ArrayList countersList = new ArrayList();
        ArrayList gaugesList = new ArrayList();
        meters.entrySet().forEach(entry -> {
            MetricId<Double> gaugeId = this.getMetricId((String)entry.getKey(), MetricType.GAUGE);
            MetricId<Long> counterId = this.getMetricId((String)entry.getKey(), MetricType.COUNTER);
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-1min"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Meter)entry.getValue()).getOneMinuteRate()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-5min"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Meter)entry.getValue()).getFiveMinuteRate()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-15min"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Meter)entry.getValue()).getFifteenMinuteRate()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-mean"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Meter)entry.getValue()).getMeanRate()))));
            countersList.add(new Metric<Long>(counterId, Collections.singletonList(new DataPoint<Long>(timestamp, ((Meter)entry.getValue()).getCount()))));
        });
        timers.entrySet().forEach(entry -> {
            MetricId<Double> gaugeId = this.getMetricId((String)entry.getKey(), MetricType.GAUGE);
            MetricId<Long> counterId = this.getMetricId((String)entry.getKey(), MetricType.COUNTER);
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-1min"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getOneMinuteRate()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-5min"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getFiveMinuteRate()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-15min"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getFifteenMinuteRate()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-mean"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getMeanRate()))));
            countersList.add(new Metric<Long>(counterId, Collections.singletonList(new DataPoint<Long>(timestamp, ((Timer)entry.getValue()).getCount()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-median"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getSnapshot().getMedian()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-max"), Collections.singletonList(new DataPoint<Double>(timestamp, Double.valueOf(((Timer)entry.getValue()).getSnapshot().getMax())))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-min"), Collections.singletonList(new DataPoint<Double>(timestamp, Double.valueOf(((Timer)entry.getValue()).getSnapshot().getMin())))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-stdDev"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getSnapshot().getStdDev()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-75p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getSnapshot().get75thPercentile()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-95p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getSnapshot().get95thPercentile()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-98p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getSnapshot().get98thPercentile()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-99p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getSnapshot().get99thPercentile()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-999p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Timer)entry.getValue()).getSnapshot().get999thPercentile()))));
        });
        gauges.entrySet().forEach(entry -> {
            MetricId<Double> gaugeId = this.getMetricId((String)entry.getKey(), MetricType.GAUGE);
            gaugesList.add(new Metric<Double>(gaugeId, Collections.singletonList(new DataPoint<Double>(timestamp, Double.parseDouble(((Gauge)entry.getValue()).getValue().toString())))));
        });
        counters.entrySet().forEach(entry -> {
            MetricId<Long> counterId = this.getMetricId((String)entry.getKey(), MetricType.COUNTER);
            countersList.add(new Metric<Long>(counterId, Collections.singletonList(new DataPoint<Long>(timestamp, ((Counter)entry.getValue()).getCount()))));
        });
        histograms.entrySet().forEach(entry -> {
            MetricId<Double> gaugeId = this.getMetricId((String)entry.getKey(), MetricType.GAUGE);
            MetricId<Long> counterId = this.getMetricId((String)entry.getKey(), MetricType.COUNTER);
            countersList.add(new Metric<Long>(counterId, Collections.singletonList(new DataPoint<Long>(timestamp, ((Histogram)entry.getValue()).getCount()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-median"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Histogram)entry.getValue()).getSnapshot().getMedian()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-max"), Collections.singletonList(new DataPoint<Double>(timestamp, Double.valueOf(((Histogram)entry.getValue()).getSnapshot().getMax())))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-min"), Collections.singletonList(new DataPoint<Double>(timestamp, Double.valueOf(((Histogram)entry.getValue()).getSnapshot().getMin())))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-stdDev"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Histogram)entry.getValue()).getSnapshot().getStdDev()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-75p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Histogram)entry.getValue()).getSnapshot().get75thPercentile()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-95p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Histogram)entry.getValue()).getSnapshot().get95thPercentile()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-98p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Histogram)entry.getValue()).getSnapshot().get98thPercentile()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-99p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Histogram)entry.getValue()).getSnapshot().get99thPercentile()))));
            gaugesList.add(new Metric<Double>(new MetricId<Double>(gaugeId.getTenantId(), MetricType.GAUGE, gaugeId.getName() + "-999p"), Collections.singletonList(new DataPoint<Double>(timestamp, ((Histogram)entry.getValue()).getSnapshot().get999thPercentile()))));
        });
        Observable<Void> insertedGauges = this.metricsService.addDataPoints(MetricType.GAUGE, Observable.from(gaugesList));
        Observable<Void> insertedCounters = this.metricsService.addDataPoints(MetricType.COUNTER, Observable.from(countersList));
        Observable.merge(insertedGauges, insertedCounters).subscribe(aVoid -> {}, t -> logger.warn((Object)"Persisting metrics failed", t), () -> logger.debug((Object)"Finished persisting metrics"));
    }

    private <T> MetricId<T> getMetricId(String metric, MetricType<T> type) {
        String tenantId = this.metricNameService.getTenantId();
        return new MetricId<T>(tenantId, type, metric);
    }
}

