/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.openjdk.jmh.util.AbstractStatistics;

public class ListStatistics
extends AbstractStatistics {
    private static final long serialVersionUID = -90642978235578197L;
    private double[] values = new double[0];
    private int count = 0;

    public ListStatistics() {
    }

    public ListStatistics(double[] samples) {
        this();
        for (double d : samples) {
            this.addValue(d);
        }
    }

    public ListStatistics(long[] samples) {
        this();
        for (long l : samples) {
            this.addValue(l);
        }
    }

    public void addValue(double d) {
        if (this.count >= this.values.length) {
            this.values = Arrays.copyOf(this.values, Math.max(1, this.values.length << 1));
        }
        this.values[this.count] = d;
        ++this.count;
    }

    @Override
    public double getMax() {
        if (this.count > 0) {
            double m = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.count; ++i) {
                m = Math.max(m, this.values[i]);
            }
            return m;
        }
        return Double.NaN;
    }

    @Override
    public double getMin() {
        if (this.count > 0) {
            double m = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.count; ++i) {
                m = Math.min(m, this.values[i]);
            }
            return m;
        }
        return Double.NaN;
    }

    @Override
    public long getN() {
        return this.count;
    }

    @Override
    public double getSum() {
        if (this.count > 0) {
            double s = 0.0;
            for (int i = 0; i < this.count; ++i) {
                s += this.values[i];
            }
            return s;
        }
        return Double.NaN;
    }

    @Override
    public double getPercentile(double rank) {
        if (this.count == 0) {
            return Double.NaN;
        }
        if (rank == 0.0) {
            return this.getMin();
        }
        this.values = Arrays.copyOf(this.values, this.count);
        Percentile p = new Percentile();
        return p.evaluate(this.values, rank);
    }

    @Override
    public int[] getHistogram(double[] levels) {
        if (levels.length < 2) {
            throw new IllegalArgumentException("Expected more than two levels");
        }
        double[] vs = Arrays.copyOf(this.values, this.count);
        Arrays.sort(vs);
        int[] result = new int[levels.length - 1];
        int c = 0;
        block0: for (double v : vs) {
            while (levels[c] > v || v >= levels[c + 1]) {
                if (++c <= levels.length - 2) continue;
                break block0;
            }
            int n = c;
            result[n] = result[n] + 1;
        }
        return result;
    }

    @Override
    public double getVariance() {
        if (this.count > 1) {
            double v = 0.0;
            double m = this.getMean();
            for (int i = 0; i < this.count; ++i) {
                v += Math.pow(this.values[i] - m, 2.0);
            }
            return v / (double)(this.count - 1);
        }
        return Double.NaN;
    }
}

