/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.util;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import com.google.common.base.Stopwatch;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import rx.Completable;
import rx.Observable;
import rx.subjects.PublishSubject;

public class GCGraceSecondsManager
implements SchemaChangeListener {
    public static int DEFAULT_GC_GRACE_SECONDS = 604800;
    private static Logger logger = Logger.getLogger(GCGraceSecondsManager.class);
    private RxSession session;
    private PreparedStatement getGCGraceSeconds;
    private String keyspace;
    private ConfigurationService configurationService;
    private Optional<PublishSubject<Throwable>> updatesFinished;

    public GCGraceSecondsManager(RxSession session, String keyspace, ConfigurationService configurationService) {
        this.session = session;
        this.keyspace = keyspace;
        this.getGCGraceSeconds = session.getSession().prepare("SELECT table_name, gc_grace_seconds FROM system_schema.tables WHERE keyspace_name = ?");
        this.configurationService = configurationService;
        session.getCluster().register(this);
        this.updatesFinished = Optional.empty();
    }

    public void maybeUpdateGCGraceSeconds() {
        logger.info((Object)("Checking tables in " + this.keyspace + " to see if gc_grace_seconds needs to be updated"));
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map<String, String> replication = this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getReplication();
        String replicationFactor = replication.get("replication_factor");
        Completable check = this.getClusterSize() == 1 || replicationFactor.equals("1") ? this.updateAllGCGraceSeconds(0) : Completable.merge((Observable)this.configurationService.load("org.hawkular.metrics", "gcGraceSeconds").switchIfEmpty(Observable.just((Object)Integer.toString(DEFAULT_GC_GRACE_SECONDS))).map(property -> {
            int gcGraceSeconds = Integer.parseInt(property);
            return this.updateAllGCGraceSeconds(gcGraceSeconds);
        }));
        check.subscribe(() -> {
            stopwatch.stop();
            logger.info((Object)("Finished gc_grace_seconds updates in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            this.updatesFinished.ifPresent(subject -> subject.onNext(null));
        }, t -> {
            logger.warn((Object)"There was an error checking and updating gc_grace_seconds");
            this.updatesFinished.ifPresent(subject -> subject.onNext(t));
        });
    }

    protected int getClusterSize() {
        return this.session.getCluster().getMetadata().getAllHosts().size();
    }

    void setUpdatesFinishedSubject(PublishSubject<Throwable> updatesFinishedSubject) {
        this.updatesFinished = Optional.of(updatesFinishedSubject);
    }

    private Completable updateAllGCGraceSeconds(int gcGraceSeconds) {
        return Completable.concat((Observable)this.getGCGraceSeconds().map(metaData -> {
            if (((TableMetaData)metaData).tableName.equals("data_compressed")) {
                if (((TableMetaData)metaData).gcGraceSeconds == 0) {
                    return Completable.complete();
                }
                logger.info((Object)("gc_grace_seconds for " + ((TableMetaData)metaData).tableName + " is set to " + ((TableMetaData)metaData).gcGraceSeconds + ". Resetting back to zero."));
                return this.updateGCGraceSeconds(((TableMetaData)metaData).tableName, 0);
            }
            if (((TableMetaData)metaData).gcGraceSeconds != gcGraceSeconds) {
                logger.info((Object)("gc_grace_seconds for " + ((TableMetaData)metaData).tableName + " is set to " + ((TableMetaData)metaData).gcGraceSeconds + ". Resetting to " + gcGraceSeconds));
                return this.updateGCGraceSeconds(((TableMetaData)metaData).tableName, gcGraceSeconds);
            }
            return Completable.complete();
        }));
    }

    private Observable<TableMetaData> getGCGraceSeconds() {
        return this.session.executeAndFetch((Statement)this.getGCGraceSeconds.bind(this.keyspace)).map(row -> new TableMetaData(row.getString(0), row.getInt(1)));
    }

    private Completable updateGCGraceSeconds(String table, int seconds) {
        return this.session.execute("ALTER TABLE " + this.keyspace + "." + table + " WITH gc_grace_seconds = " + seconds).toCompletable();
    }

    @Override
    public void onRegister(Cluster cluster) {
    }

    @Override
    public void onUnregister(Cluster cluster) {
    }

    @Override
    public void onKeyspaceAdded(KeyspaceMetadata keyspace) {
    }

    @Override
    public void onKeyspaceRemoved(KeyspaceMetadata keyspace) {
    }

    @Override
    public void onKeyspaceChanged(KeyspaceMetadata current, KeyspaceMetadata previous) {
        String newReplicationFactor;
        if (!current.getName().equals(this.keyspace)) {
            return;
        }
        String oldReplicationFactor = previous.getReplication().get("replication_factor");
        if (!oldReplicationFactor.equals(newReplicationFactor = current.getReplication().get("replication_factor"))) {
            logger.info((Object)("replication_factor of " + this.keyspace + " has changed from " + oldReplicationFactor + " to " + newReplicationFactor));
            this.maybeUpdateGCGraceSeconds();
        }
    }

    @Override
    public void onTableAdded(TableMetadata table) {
    }

    @Override
    public void onTableRemoved(TableMetadata table) {
    }

    @Override
    public void onTableChanged(TableMetadata current, TableMetadata previous) {
    }

    @Override
    public void onUserTypeAdded(UserType type) {
    }

    @Override
    public void onUserTypeRemoved(UserType type) {
    }

    @Override
    public void onUserTypeChanged(UserType current, UserType previous) {
    }

    @Override
    public void onFunctionAdded(FunctionMetadata function) {
    }

    @Override
    public void onFunctionRemoved(FunctionMetadata function) {
    }

    @Override
    public void onFunctionChanged(FunctionMetadata current, FunctionMetadata previous) {
    }

    @Override
    public void onAggregateAdded(AggregateMetadata aggregate) {
    }

    @Override
    public void onAggregateRemoved(AggregateMetadata aggregate) {
    }

    @Override
    public void onAggregateChanged(AggregateMetadata current, AggregateMetadata previous) {
    }

    @Override
    public void onMaterializedViewAdded(MaterializedViewMetadata view) {
    }

    @Override
    public void onMaterializedViewRemoved(MaterializedViewMetadata view) {
    }

    @Override
    public void onMaterializedViewChanged(MaterializedViewMetadata current, MaterializedViewMetadata previous) {
    }

    private static class TableMetaData {
        private final String tableName;
        private final int gcGraceSeconds;

        public TableMetaData(String tableName, int gcGraceSeconds) {
            this.tableName = tableName;
            this.gcGraceSeconds = gcGraceSeconds;
        }
    }
}

