/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitInput;
import fi.iki.yak.ts.compression.gorilla.Pair;

public class Decompressor {
    private int storedLeadingZeros = Integer.MAX_VALUE;
    private int storedTrailingZeros = 0;
    private long storedVal = 0L;
    private long storedTimestamp = 0L;
    private long storedDelta = 0L;
    private long blockTimestamp = 0L;
    private boolean endOfStream = false;
    private BitInput in;

    public Decompressor(BitInput input) {
        this.in = input;
        this.readHeader();
    }

    private void readHeader() {
        this.blockTimestamp = this.in.getLong(64);
    }

    public Pair readPair() {
        this.next();
        if (this.endOfStream) {
            return null;
        }
        return new Pair(this.storedTimestamp, this.storedVal);
    }

    private void next() {
        if (this.storedTimestamp == 0L) {
            this.storedDelta = this.in.getLong(27);
            if (this.storedDelta == 0x7FFFFFFL) {
                this.endOfStream = true;
                return;
            }
            this.storedVal = this.in.getLong(64);
            this.storedTimestamp = this.blockTimestamp + this.storedDelta;
        } else {
            this.nextTimestamp();
            this.nextValue();
        }
    }

    private int bitsToRead() {
        int toRead = 0;
        if (this.in.readBit()) {
            toRead = !this.in.readBit() ? 7 : (!this.in.readBit() ? 9 : (!this.in.readBit() ? 12 : 32));
        }
        return toRead;
    }

    private void nextTimestamp() {
        long deltaDelta = 0L;
        int toRead = this.bitsToRead();
        if (toRead > 0) {
            deltaDelta = this.in.getLong(toRead);
            if (toRead == 32) {
                if ((int)deltaDelta == -1) {
                    this.endOfStream = true;
                    return;
                }
            } else if (deltaDelta > (long)(1 << toRead - 1)) {
                deltaDelta -= (long)(1 << toRead);
            }
            deltaDelta = (int)deltaDelta;
        }
        this.storedDelta += deltaDelta;
        this.storedTimestamp = this.storedDelta + this.storedTimestamp;
    }

    private void nextValue() {
        if (this.in.readBit()) {
            if (this.in.readBit()) {
                this.storedLeadingZeros = (int)this.in.getLong(5);
                int significantBits = (int)this.in.getLong(6);
                if (significantBits == 0) {
                    significantBits = 64;
                }
                this.storedTrailingZeros = 64 - significantBits - this.storedLeadingZeros;
            }
            long value = this.in.getLong(64 - this.storedLeadingZeros - this.storedTrailingZeros);
            value <<= this.storedTrailingZeros;
            this.storedVal = value = this.storedVal ^ value;
        }
    }
}

