/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ObjectSizes;

public class RowIndexEntry<T>
implements IMeasurableMemory {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RowIndexEntry(0L));
    public final long position;

    public RowIndexEntry(long position) {
        this.position = position;
    }

    protected int promotedSize(IndexHelper.IndexInfo.Serializer idxSerializer) {
        return 0;
    }

    public static RowIndexEntry<IndexHelper.IndexInfo> create(long position, DeletionTime deletionTime, ColumnIndex index) {
        assert (index != null);
        assert (deletionTime != null);
        if (index.columnsIndex.size() > 1) {
            return new IndexedEntry(position, deletionTime, index.partitionHeaderLength, index.columnsIndex);
        }
        return new RowIndexEntry<IndexHelper.IndexInfo>(position);
    }

    public boolean isIndexed() {
        return !this.columnsIndex().isEmpty();
    }

    public DeletionTime deletionTime() {
        throw new UnsupportedOperationException();
    }

    public long headerOffset() {
        return 0L;
    }

    public long headerLength() {
        throw new UnsupportedOperationException();
    }

    public List<T> columnsIndex() {
        return Collections.emptyList();
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    private static class IndexedEntry
    extends RowIndexEntry<IndexHelper.IndexInfo> {
        private final DeletionTime deletionTime;
        private final long headerLength;
        private final List<IndexHelper.IndexInfo> columnsIndex;
        private static final long BASE_SIZE = ObjectSizes.measure(new IndexedEntry(0L, DeletionTime.LIVE, 0L, Arrays.asList(null, null))) + ObjectSizes.measure(new ArrayList(1));

        private IndexedEntry(long position, DeletionTime deletionTime, long headerLength, List<IndexHelper.IndexInfo> columnsIndex) {
            super(position);
            assert (deletionTime != null);
            assert (columnsIndex != null && columnsIndex.size() > 1);
            this.deletionTime = deletionTime;
            this.headerLength = headerLength;
            this.columnsIndex = columnsIndex;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public long headerLength() {
            return this.headerLength;
        }

        @Override
        public List<IndexHelper.IndexInfo> columnsIndex() {
            return this.columnsIndex;
        }

        @Override
        protected int promotedSize(IndexHelper.IndexInfo.Serializer idxSerializer) {
            long size = (long)TypeSizes.sizeofUnsignedVInt(this.headerLength) + DeletionTime.serializer.serializedSize(this.deletionTime) + (long)TypeSizes.sizeofUnsignedVInt(this.columnsIndex.size());
            for (IndexHelper.IndexInfo info : this.columnsIndex) {
                size += idxSerializer.serializedSize(info);
            }
            return Ints.checkedCast(size += (long)(this.columnsIndex.size() * TypeSizes.sizeof(0)));
        }

        @Override
        public long unsharedHeapSize() {
            long entrySize = 0L;
            for (IndexHelper.IndexInfo idx : this.columnsIndex) {
                entrySize += idx.unsharedHeapSize();
            }
            return BASE_SIZE + entrySize + this.deletionTime.unsharedHeapSize() + ObjectSizes.sizeOfReferenceArray(this.columnsIndex.size());
        }
    }

    public static class Serializer
    implements IndexSerializer<IndexHelper.IndexInfo> {
        private final IndexHelper.IndexInfo.Serializer idxSerializer;
        private final Version version;

        public Serializer(CFMetaData metadata, Version version, SerializationHeader header) {
            this.idxSerializer = new IndexHelper.IndexInfo.Serializer(metadata, version, header);
            this.version = version;
        }

        @Override
        public void serialize(RowIndexEntry<IndexHelper.IndexInfo> rie, DataOutputPlus out) throws IOException {
            assert (this.version.storeRows()) : "We read old index files but we should never write them";
            out.writeUnsignedVInt(rie.position);
            out.writeUnsignedVInt(rie.promotedSize(this.idxSerializer));
            if (rie.isIndexed()) {
                out.writeUnsignedVInt(rie.headerLength());
                DeletionTime.serializer.serialize(rie.deletionTime(), out);
                out.writeUnsignedVInt(rie.columnsIndex().size());
                int[] offsets = new int[rie.columnsIndex().size()];
                if (out.hasPosition()) {
                    long start = out.position();
                    int i = 0;
                    for (IndexHelper.IndexInfo info : rie.columnsIndex()) {
                        offsets[i] = i == 0 ? 0 : (int)(out.position() - start);
                        ++i;
                        this.idxSerializer.serialize(info, out);
                    }
                } else {
                    int i = 0;
                    int offset = 0;
                    for (IndexHelper.IndexInfo info : rie.columnsIndex()) {
                        offsets[i++] = offset;
                        this.idxSerializer.serialize(info, out);
                        offset = (int)((long)offset + this.idxSerializer.serializedSize(info));
                    }
                }
                for (int off : offsets) {
                    out.writeInt(off);
                }
            }
        }

        @Override
        public RowIndexEntry<IndexHelper.IndexInfo> deserialize(DataInputPlus in) throws IOException {
            if (!this.version.storeRows()) {
                long position = in.readLong();
                int size = in.readInt();
                if (size > 0) {
                    DeletionTime deletionTime = DeletionTime.serializer.deserialize(in);
                    int entries = in.readInt();
                    ArrayList<IndexHelper.IndexInfo> columnsIndex = new ArrayList<IndexHelper.IndexInfo>(entries);
                    long headerLength = 0L;
                    for (int i = 0; i < entries; ++i) {
                        IndexHelper.IndexInfo info = this.idxSerializer.deserialize(in);
                        columnsIndex.add(info);
                        if (i != 0) continue;
                        headerLength = info.offset;
                    }
                    return new IndexedEntry(position, deletionTime, headerLength, columnsIndex);
                }
                return new RowIndexEntry<IndexHelper.IndexInfo>(position);
            }
            long position = in.readUnsignedVInt();
            int size = (int)in.readUnsignedVInt();
            if (size > 0) {
                long headerLength = in.readUnsignedVInt();
                DeletionTime deletionTime = DeletionTime.serializer.deserialize(in);
                int entries = (int)in.readUnsignedVInt();
                ArrayList<IndexHelper.IndexInfo> columnsIndex = new ArrayList<IndexHelper.IndexInfo>(entries);
                for (int i = 0; i < entries; ++i) {
                    columnsIndex.add(this.idxSerializer.deserialize(in));
                }
                in.skipBytesFully(entries * TypeSizes.sizeof(0));
                return new IndexedEntry(position, deletionTime, headerLength, columnsIndex);
            }
            return new RowIndexEntry<IndexHelper.IndexInfo>(position);
        }

        public static long readPosition(DataInputPlus in, Version version) throws IOException {
            return version.storeRows() ? in.readUnsignedVInt() : in.readLong();
        }

        public static void skip(DataInputPlus in, Version version) throws IOException {
            Serializer.readPosition(in, version);
            Serializer.skipPromotedIndex(in, version);
        }

        private static void skipPromotedIndex(DataInputPlus in, Version version) throws IOException {
            int size;
            int n = size = version.storeRows() ? (int)in.readUnsignedVInt() : in.readInt();
            if (size <= 0) {
                return;
            }
            in.skipBytesFully(size);
        }

        @Override
        public int serializedSize(RowIndexEntry<IndexHelper.IndexInfo> rie) {
            assert (this.version.storeRows()) : "We read old index files but we should never write them";
            int indexedSize = 0;
            if (rie.isIndexed()) {
                List<IndexHelper.IndexInfo> index = rie.columnsIndex();
                indexedSize += TypeSizes.sizeofUnsignedVInt(rie.headerLength());
                indexedSize = (int)((long)indexedSize + DeletionTime.serializer.serializedSize(rie.deletionTime()));
                indexedSize += TypeSizes.sizeofUnsignedVInt(index.size());
                for (IndexHelper.IndexInfo info : index) {
                    indexedSize = (int)((long)indexedSize + this.idxSerializer.serializedSize(info));
                }
                indexedSize += index.size() * TypeSizes.sizeof(0);
            }
            return TypeSizes.sizeofUnsignedVInt(rie.position) + TypeSizes.sizeofUnsignedVInt(indexedSize) + indexedSize;
        }
    }

    public static interface IndexSerializer<T> {
        public void serialize(RowIndexEntry<T> var1, DataOutputPlus var2) throws IOException;

        public RowIndexEntry<T> deserialize(DataInputPlus var1) throws IOException;

        public int serializedSize(RowIndexEntry<T> var1);
    }
}

