/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.compaction.writers.MaxSSTableSizeWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class SSTableSplitter {
    private final SplittingCompactionTask task;
    private CompactionInfo.Holder info;

    public SSTableSplitter(ColumnFamilyStore cfs, LifecycleTransaction transaction, int sstableSizeInMB) {
        this.task = new SplittingCompactionTask(cfs, transaction, sstableSizeInMB);
    }

    public void split() {
        this.task.execute(new StatsCollector());
    }

    public static class SplitController
    extends CompactionController {
        public SplitController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MIN_VALUE);
        }

        @Override
        public long maxPurgeableTimestamp(DecoratedKey key) {
            return Long.MIN_VALUE;
        }
    }

    public static class SplittingCompactionTask
    extends CompactionTask {
        private final int sstableSizeInMB;

        public SplittingCompactionTask(ColumnFamilyStore cfs, LifecycleTransaction transaction, int sstableSizeInMB) {
            super(cfs, transaction, Integer.MIN_VALUE, true, false);
            this.sstableSizeInMB = sstableSizeInMB;
            if (sstableSizeInMB <= 0) {
                throw new IllegalArgumentException("Invalid target size for SSTables, must be > 0 (got: " + sstableSizeInMB + ")");
            }
        }

        @Override
        protected CompactionController getCompactionController(Set<SSTableReader> toCompact) {
            return new SplitController(this.cfs);
        }

        @Override
        public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
            return new MaxSSTableSizeWriter(cfs, directories, txn, nonExpiredSSTables, (long)this.sstableSizeInMB * 1024L * 1024L, 0, true, false);
        }

        @Override
        protected boolean partialCompactionsAcceptable() {
            return true;
        }
    }

    public class StatsCollector
    implements CompactionManager.CompactionExecutorStatsCollector {
        @Override
        public void beginCompaction(CompactionInfo.Holder ci) {
            SSTableSplitter.this.info = ci;
        }

        @Override
        public void finishCompaction(CompactionInfo.Holder ci) {
        }
    }
}

