/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.apache.cassandra.utils.concurrent.Locks;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.HeapAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public class AtomicBTreePartition
extends AbstractBTreePartition {
    public static final long EMPTY_SIZE = ObjectSizes.measure(new AtomicBTreePartition(CFMetaData.createFake("keyspace", "table"), DatabaseDescriptor.getPartitioner().decorateKey(ByteBuffer.allocate(1)), null));
    private static final int TRACKER_NEVER_WASTED = 0;
    private static final int TRACKER_PESSIMISTIC_LOCKING = Integer.MAX_VALUE;
    private static final int ALLOCATION_GRANULARITY_BYTES = 1024;
    private static final long EXCESS_WASTE_BYTES = 0xA00000L;
    private static final int EXCESS_WASTE_OFFSET = 10240;
    private static final int CLOCK_SHIFT = 17;
    private static final AtomicIntegerFieldUpdater<AtomicBTreePartition> wasteTrackerUpdater = AtomicIntegerFieldUpdater.newUpdater(AtomicBTreePartition.class, "wasteTracker");
    private static final AtomicReferenceFieldUpdater<AtomicBTreePartition, AbstractBTreePartition.Holder> refUpdater = AtomicReferenceFieldUpdater.newUpdater(AtomicBTreePartition.class, AbstractBTreePartition.Holder.class, "ref");
    private volatile int wasteTracker = 0;
    private final MemtableAllocator allocator;
    private volatile AbstractBTreePartition.Holder ref;

    public AtomicBTreePartition(CFMetaData metadata, DecoratedKey partitionKey, MemtableAllocator allocator) {
        super(metadata, partitionKey);
        this.allocator = allocator;
        this.ref = EMPTY;
    }

    @Override
    protected AbstractBTreePartition.Holder holder() {
        return this.ref;
    }

    @Override
    protected boolean canHaveShadowedData() {
        return true;
    }

    public long[] addAllWithSizeDelta(PartitionUpdate update, OpOrder.Group writeOp, UpdateTransaction indexer) {
        RowUpdater updater = new RowUpdater(this, this.allocator, writeOp, indexer);
        DeletionInfo inputDeletionInfoCopy = null;
        boolean monitorOwned = false;
        try {
            if (this.usePessimisticLocking()) {
                Locks.monitorEnterUnsafe(this);
                monitorOwned = true;
            }
            indexer.start();
            while (true) {
                DeletionInfo deletionInfo;
                AbstractBTreePartition.Holder current;
                updater.ref = current = this.ref;
                updater.reset();
                if (!update.deletionInfo().getPartitionDeletion().isLive()) {
                    indexer.onPartitionDeletion(update.deletionInfo().getPartitionDeletion());
                }
                if (update.deletionInfo().hasRanges()) {
                    update.deletionInfo().rangeIterator(false).forEachRemaining(indexer::onRangeTombstone);
                }
                if (update.deletionInfo().mayModify(current.deletionInfo)) {
                    if (inputDeletionInfoCopy == null) {
                        inputDeletionInfoCopy = update.deletionInfo().copy(HeapAllocator.instance);
                    }
                    deletionInfo = current.deletionInfo.mutableCopy().add(inputDeletionInfoCopy);
                    updater.allocated(deletionInfo.unsharedHeapSize() - current.deletionInfo.unsharedHeapSize());
                } else {
                    deletionInfo = current.deletionInfo;
                }
                PartitionColumns columns = update.columns().mergeTo(current.columns);
                Row newStatic = update.staticRow();
                Row staticRow = newStatic.isEmpty() ? current.staticRow : (current.staticRow.isEmpty() ? updater.apply(newStatic) : updater.apply(current.staticRow, newStatic));
                Object[] tree = BTree.update(current.tree, update.metadata().comparator, update, update.rowCount(), updater);
                EncodingStats newStats = current.stats.mergeWith(update.stats());
                if (tree != null && refUpdater.compareAndSet(this, current, new AbstractBTreePartition.Holder(columns, tree, deletionInfo, staticRow, newStats))) {
                    updater.finish();
                    long[] lArray = new long[]{updater.dataSize, updater.colUpdateTimeDelta};
                    return lArray;
                }
                if (monitorOwned) continue;
                boolean shouldLock = this.usePessimisticLocking();
                if (!shouldLock) {
                    shouldLock = this.updateWastedAllocationTracker(updater.heapSize);
                }
                if (!shouldLock) continue;
                Locks.monitorEnterUnsafe(this);
                monitorOwned = true;
            }
        }
        finally {
            indexer.commit();
            if (monitorOwned) {
                Locks.monitorExitUnsafe(this);
            }
        }
    }

    public boolean usePessimisticLocking() {
        return this.wasteTracker == Integer.MAX_VALUE;
    }

    private boolean updateWastedAllocationTracker(long wastedBytes) {
        if (wastedBytes < 0xA00000L) {
            int oldTrackerValue;
            int wastedAllocation = (int)(wastedBytes + 1024L - 1L) / 1024;
            while (Integer.MAX_VALUE != (oldTrackerValue = this.wasteTracker)) {
                int time = (int)(System.nanoTime() >>> 17);
                int delta = oldTrackerValue - time;
                if (oldTrackerValue == 0 || delta >= 0 || delta < -10240) {
                    delta = -10240;
                }
                if ((delta += wastedAllocation) >= 0) break;
                if (!wasteTrackerUpdater.compareAndSet(this, oldTrackerValue, AtomicBTreePartition.avoidReservedValues(time + delta))) continue;
                return false;
            }
        }
        wasteTrackerUpdater.set(this, Integer.MAX_VALUE);
        return true;
    }

    private static int avoidReservedValues(int wasteTracker) {
        if (wasteTracker == 0 || wasteTracker == Integer.MAX_VALUE) {
            return wasteTracker + 1;
        }
        return wasteTracker;
    }

    private static final class RowUpdater
    implements UpdateFunction<Row, Row> {
        final AtomicBTreePartition updating;
        final MemtableAllocator allocator;
        final OpOrder.Group writeOp;
        final UpdateTransaction indexer;
        final int nowInSec;
        AbstractBTreePartition.Holder ref;
        Row.Builder regularBuilder;
        long dataSize;
        long heapSize;
        long colUpdateTimeDelta = Long.MAX_VALUE;
        final MemtableAllocator.DataReclaimer reclaimer;
        List<Row> inserted;

        private RowUpdater(AtomicBTreePartition updating, MemtableAllocator allocator, OpOrder.Group writeOp, UpdateTransaction indexer) {
            this.updating = updating;
            this.allocator = allocator;
            this.writeOp = writeOp;
            this.indexer = indexer;
            this.nowInSec = FBUtilities.nowInSeconds();
            this.reclaimer = allocator.reclaimer();
        }

        private Row.Builder builder(Clustering clustering) {
            boolean isStatic;
            boolean bl = isStatic = clustering == Clustering.STATIC_CLUSTERING;
            if (isStatic) {
                return this.allocator.rowBuilder(this.writeOp);
            }
            if (this.regularBuilder == null) {
                this.regularBuilder = this.allocator.rowBuilder(this.writeOp);
            }
            return this.regularBuilder;
        }

        @Override
        public Row apply(Row insert) {
            Row data = Rows.copy(insert, this.builder(insert.clustering())).build();
            this.indexer.onInserted(insert);
            this.dataSize += (long)data.dataSize();
            this.heapSize += data.unsharedHeapSizeExcludingData();
            if (this.inserted == null) {
                this.inserted = new ArrayList<Row>();
            }
            this.inserted.add(data);
            return data;
        }

        @Override
        public Row apply(Row existing, Row update) {
            Row.Builder builder = this.builder(existing.clustering());
            this.colUpdateTimeDelta = Math.min(this.colUpdateTimeDelta, Rows.merge(existing, update, builder, this.nowInSec));
            Row reconciled = builder.build();
            this.indexer.onUpdated(existing, reconciled);
            this.dataSize += (long)(reconciled.dataSize() - existing.dataSize());
            this.heapSize += reconciled.unsharedHeapSizeExcludingData() - existing.unsharedHeapSizeExcludingData();
            if (this.inserted == null) {
                this.inserted = new ArrayList<Row>();
            }
            this.inserted.add(reconciled);
            this.discard(existing);
            return reconciled;
        }

        protected void reset() {
            this.dataSize = 0L;
            this.heapSize = 0L;
            if (this.inserted != null) {
                for (Row row : this.inserted) {
                    this.abort(row);
                }
                this.inserted.clear();
            }
            this.reclaimer.cancel();
        }

        protected void abort(Row abort) {
            this.reclaimer.reclaimImmediately(abort);
        }

        protected void discard(Row discard) {
            this.reclaimer.reclaim(discard);
        }

        @Override
        public boolean abortEarly() {
            return this.updating.ref != this.ref;
        }

        @Override
        public void allocated(long heapSize) {
            this.heapSize += heapSize;
        }

        protected void finish() {
            this.allocator.onHeap().adjust(this.heapSize, this.writeOp);
            this.reclaimer.commit();
        }
    }
}

