/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CompactionMetrics
implements CompactionManager.CompactionExecutorStatsCollector {
    public static final MetricNameFactory factory = new DefaultNameFactory("Compaction");
    private static final Set<CompactionInfo.Holder> compactions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    public final Gauge<Integer> pendingTasks = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PendingTasks"), new Gauge<Integer>(){

        @Override
        public Integer getValue() {
            int n = 0;
            for (String keyspaceName : Schema.instance.getKeyspaces()) {
                for (ColumnFamilyStore cfs : Keyspace.open(keyspaceName).getColumnFamilyStores()) {
                    n += cfs.getCompactionStrategyManager().getEstimatedRemainingTasks();
                }
            }
            return n + compactions.size();
        }
    });
    public final Gauge<Long> completedTasks;
    public final Meter totalCompactionsCompleted;
    public final Counter bytesCompacted;

    public CompactionMetrics(final ThreadPoolExecutor ... collectors) {
        this.completedTasks = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("CompletedTasks"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                long completedTasks = 0L;
                for (ThreadPoolExecutor collector : collectors) {
                    completedTasks += collector.getCompletedTaskCount();
                }
                return completedTasks;
            }
        });
        this.totalCompactionsCompleted = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("TotalCompactionsCompleted"));
        this.bytesCompacted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("BytesCompacted"));
    }

    @Override
    public void beginCompaction(CompactionInfo.Holder ci) {
        ci.started();
        compactions.add(ci);
    }

    @Override
    public void finishCompaction(CompactionInfo.Holder ci) {
        ci.finished();
        compactions.remove(ci);
        this.bytesCompacted.inc(ci.getCompactionInfo().getTotal());
        this.totalCompactionsCompleted.mark();
    }

    public static List<CompactionInfo.Holder> getCompactions() {
        return new ArrayList<CompactionInfo.Holder>(compactions);
    }
}

