/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hawkular.metrics.core.dropwizard.MetaData;
import org.hawkular.metrics.core.dropwizard.MetricNameService;

public class HawkularMetricRegistry
extends MetricRegistry {
    private Map<String, MetaData> metaDataMap = new ConcurrentHashMap<String, MetaData>();
    private MetricNameService metricNameService;

    public void setMetricNameService(MetricNameService metricNameService) {
        this.metricNameService = metricNameService;
    }

    public void registerMetaData(String name, String scope, String type) {
        this.metaDataMap.put(name, new MetaData(name, scope, type, this.metricNameService.getHostName()));
    }

    public void registerMetaData(MetaData metaData) {
        this.metaDataMap.put(metaData.getName(), metaData);
    }

    public <T extends Metric> T register(String name, String scope, String type, T metric) {
        this.metaDataMap.put(name, new MetaData(name, scope, type, this.metricNameService.getHostName()));
        return super.register(name, metric);
    }

    public MetaData getMetaData(String metric) {
        return this.metaDataMap.get(metric);
    }

    public MetaData removeMetaData(String metric) {
        return this.metaDataMap.remove(metric);
    }
}

