/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hawkular.metrics.core.dropwizard.HawkularMetricRegistry;
import org.hawkular.metrics.core.dropwizard.MetaData;
import org.hawkular.metrics.core.dropwizard.MetricNameService;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import rx.Observable;

public class HawkularMetricsRegistryListener
extends MetricRegistryListener.Base {
    private static Logger logger = Logger.getLogger(HawkularMetricsRegistryListener.class);
    private MetricsService metricsService;
    private HawkularMetricRegistry metricRegistry;
    private MetricNameService metricNameService;

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setMetricRegistry(HawkularMetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public void setMetricNameService(MetricNameService metricNameService) {
        this.metricNameService = metricNameService;
    }

    @Override
    public void onMeterAdded(String name, Meter meter) {
        MetaData metaData = this.metricRegistry.getMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for meter %s that has been added to the registry", (Object)name);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.createMetrics(metricName, Arrays.asList(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-5min"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-15min"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-mean"), metaData.getTags()), new Metric<Long>(new MetricId<Long>(tenantId, MetricType.COUNTER, metricName), metaData.getTags())));
    }

    @Override
    public void onMeterRemoved(String name) {
        MetaData metaData = this.metricRegistry.removeMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for meter %s that has been removed from the registry", (Object)name);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.deleteMetrics(metricName, Arrays.asList(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-5min"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-15min"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-mean"), new MetricId<Long>(tenantId, MetricType.COUNTER, metricName)));
    }

    @Override
    public void onTimerAdded(String name, Timer timer) {
        MetaData metaData = this.metricRegistry.getMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for timer %s that has been added to the registry", (Object)name);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.createMetrics(metricName, Arrays.asList(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-5min"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-15min"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-mean"), metaData.getTags()), new Metric<Long>(new MetricId<Long>(tenantId, MetricType.COUNTER, metricName), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-median"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-max"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-min"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-75p"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-95p"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-99p"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-999p"), metaData.getTags())));
    }

    @Override
    public void onTimerRemoved(String name) {
        MetaData metaData = this.metricRegistry.removeMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for timer %s that has been removed from the registry", new Object[0]);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.deleteMetrics(metricName, Arrays.asList(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-5min"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-15min"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-mean"), new MetricId<Long>(tenantId, MetricType.COUNTER, metricName), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-median"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-max"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-min"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-75p"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-95p"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-99p"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-999p")));
    }

    @Override
    public void onHistogramAdded(String name, Histogram histogram) {
        MetaData metaData = this.metricRegistry.getMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for histogram %s that has been added to the registry", (Object)name);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.createMetrics(metricName, Arrays.asList(new Metric<Long>(new MetricId<Long>(tenantId, MetricType.COUNTER, metricName), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-mean"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-median"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-max"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-min"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-75p"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-95p"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-99p"), metaData.getTags()), new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-999p"), metaData.getTags())));
    }

    @Override
    public void onHistogramRemoved(String name) {
        MetaData metaData = this.metricRegistry.removeMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for histogram %s that has been removed from the registry", new Object[0]);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.deleteMetrics(metricName, Arrays.asList(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-mean"), new MetricId<Long>(tenantId, MetricType.COUNTER, metricName), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-median"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-max"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-min"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-75p"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-95p"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-99p"), new MetricId<Double>(tenantId, MetricType.GAUGE, metricName + "-999p")));
    }

    @Override
    public void onGaugeAdded(String name, Gauge<?> gauge) {
        MetaData metaData = this.metricRegistry.getMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for gauge %s that has been added to the registry", (Object)name);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.createMetrics(metricName, Collections.singletonList(new Metric<Double>(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName), metaData.getTags())));
    }

    @Override
    public void onGaugeRemoved(String name) {
        MetaData metaData = this.metricRegistry.removeMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for gauge %s that has been removed from the registry", new Object[0]);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.deleteMetrics(metricName, Collections.singletonList(new MetricId<Double>(tenantId, MetricType.GAUGE, metricName)));
    }

    @Override
    public void onCounterAdded(String name, Counter counter) {
        MetaData metaData = this.metricRegistry.getMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for counter %s that has been added to the registry", (Object)name);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.createMetrics(metricName, Collections.singletonList(new Metric<Long>(new MetricId<Long>(tenantId, MetricType.COUNTER, metricName), metaData.getTags())));
    }

    @Override
    public void onCounterRemoved(String name) {
        MetaData metaData = this.metricRegistry.removeMetaData(name);
        if (metaData == null) {
            logger.warnf("Did not find meta data for counter %s that has been removed from the registry", new Object[0]);
            return;
        }
        String tenantId = this.metricNameService.getTenantId();
        String metricName = this.metricNameService.createMetricName(metaData);
        this.deleteMetrics(metricName, Collections.singletonList(new MetricId<Long>(tenantId, MetricType.COUNTER, metricName)));
    }

    private void createMetrics(String metricName, List<Metric<?>> metrics) {
        Observable.from(metrics).flatMap(metric -> this.metricsService.createMetric((Metric<?>)metric, true).doOnNext(aVoid -> logger.debugf("Created %s", metric))).toCompletable().subscribe(() -> logger.debugf("Finished creating metrics for %s", (Object)metricName), t -> logger.warnf(t, "Failed to create metrics for %s", (Object)metricName));
    }

    private void deleteMetrics(String metricName, List<MetricId<?>> metrics) {
        Observable.from(metrics).flatMap(metricId -> this.metricsService.deleteMetric(metricId).doOnNext(aVoid -> logger.debugf("Deleted %s", metricId))).toCompletable().subscribe(() -> logger.debugf("Finished deleting metrics for %s", (Object)metricName), t -> logger.warnf(t, "Failed to delete metrics for %s", (Object)metricName));
    }
}

