/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.codahale.metrics.ObjectNameFactory;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hawkular.metrics.core.dropwizard.HawkularMetricRegistry;
import org.hawkular.metrics.core.dropwizard.MetaData;
import org.hawkular.metrics.core.service.log.CoreLogger;
import org.hawkular.metrics.core.service.log.CoreLogging;

public class HawkularObjectNameFactory
implements ObjectNameFactory {
    private static final CoreLogger LOGGER = CoreLogging.getCoreLogger(HawkularObjectNameFactory.class);
    private HawkularMetricRegistry metricRegistry;

    public HawkularObjectNameFactory(HawkularMetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    private boolean needsQuote(String propertyValue) {
        String[] specialCharacters;
        for (String c : specialCharacters = new String[]{"*", "?", "=", ":", ","}) {
            if (!propertyValue.contains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ObjectName createName(String type, String domain, String name) {
        try {
            Hashtable<String, String> table = new Hashtable<String, String>();
            MetaData metaData = this.metricRegistry.getMetaData(name);
            if (metaData == null) {
                LOGGER.warnf("No meta data found for %s", name);
                return new ObjectName(domain, type, name);
            }
            table.putAll(this.metricRegistry.getMetaData(name).getTags());
            table.replaceAll((k, v) -> this.needsQuote((String)v) ? ObjectName.quote(v) : v);
            return new ObjectName(domain, table);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.warn("Unable to register {" + type + "} {" + name + "}", e);
            throw new RuntimeException(e);
        }
    }
}

