/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hawkular.metrics.core.dropwizard.MetaData;

public class MetricNameService {
    public static final String separator = "|";
    private final String adminTenant;
    private final String hostname;

    public MetricNameService() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to get hostname", e);
        }
        this.adminTenant = "admin";
    }

    public MetricNameService(String adminTenant) {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to get hostname", e);
        }
        this.adminTenant = adminTenant;
    }

    public MetricNameService(String hostname, String adminTenant) {
        this.hostname = hostname;
        this.adminTenant = adminTenant;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getTenantId() {
        return this.adminTenant;
    }

    public String createMetricName(MetaData metaData) {
        Preconditions.checkArgument(!metaData.getName().contains(separator), metaData.getName() + " is an invalid metric name. Metric names cannot include " + separator);
        return this.hostname + separator + metaData.getNamespace() + separator + metaData.getName();
    }
}

