/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public class DeleteExpiredMetrics
implements Func1<JobDetails, Completable> {
    private static Logger logger = Logger.getLogger(DeleteExpiredMetrics.class);
    public static final String JOB_NAME = "DELETE_EXPIRED_METRICS";
    private MetricsService metricsService;
    private RxSession session;
    private ConfigurationService configurationService;
    private PreparedStatement findEligibleTenants;
    private PreparedStatement findEligibleMetrics;
    private PreparedStatement findUnexpiredDataPoints;
    private long metricExpirationDelay;

    public DeleteExpiredMetrics(MetricsService metricsService, RxSession session, ConfigurationService configurationService, int metricExpirationDelayInDays) {
        this.metricsService = metricsService;
        this.session = session;
        this.configurationService = configurationService;
        this.findEligibleTenants = session.getSession().prepare("SELECT DISTINCT tenant_id, type FROM metrics_expiration_idx");
        this.findEligibleMetrics = session.getSession().prepare("SELECT tenant_id, type, metric, time FROM metrics_expiration_idx WHERE tenant_id = ? AND type = ?");
        this.findUnexpiredDataPoints = session.getSession().prepare("SELECT * FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = 0 LIMIT 1;");
        this.metricExpirationDelay = (long)(metricExpirationDelayInDays * 24 * 3600) * 1000L;
    }

    public Completable call(JobDetails jobDetails) {
        logger.info((Object)"Starting delete expired metrics job");
        Stopwatch stopwatch = Stopwatch.createStarted();
        String unparsedConfigExpirationTime = jobDetails.getParameters().get("expirationTimestamp");
        Long configuredExpirationTime = null;
        if (unparsedConfigExpirationTime != null && !unparsedConfigExpirationTime.isEmpty()) {
            try {
                configuredExpirationTime = Long.parseLong(unparsedConfigExpirationTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long expirationTime = (configuredExpirationTime != null ? configuredExpirationTime.longValue() : DateTimeService.now.get().getMillis()) - this.metricExpirationDelay;
        Observable expirationIndexResults = this.session.execute((Statement)this.findEligibleTenants.bind()).flatMap(Observable::from).flatMap(row -> this.session.execute((Statement)this.findEligibleMetrics.bind(row.getString(0), row.getByte(1)))).flatMap(Observable::from).filter(row -> row.getTimestamp(3).getTime() < expirationTime).map(row -> new MetricId(row.getString(0), MetricType.fromCode(row.getByte(1)), row.getString(2)));
        String compressJobEnabledConfig = (String)this.configurationService.load("org.hawkular.metrics.jobs.COMPRESS_DATA", "enabled").toBlocking().firstOrDefault(null);
        boolean compressJobEnabled = false;
        if (compressJobEnabledConfig != null && !compressJobEnabledConfig.isEmpty()) {
            try {
                compressJobEnabled = Boolean.parseBoolean(compressJobEnabledConfig);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!compressJobEnabled) {
            expirationIndexResults = expirationIndexResults.flatMap(r -> this.session.execute((Statement)this.findUnexpiredDataPoints.bind(r.getTenantId(), r.getType().getCode(), r.getName())).flatMap(Observable::from).isEmpty().filter(empty -> empty).map(empty -> r));
        }
        return expirationIndexResults.concatMap(metricId -> this.metricsService.deleteMetric(metricId)).onErrorResumeNext(e -> {
            logger.error((Object)"Failed to delete metric data", e);
            return Observable.empty();
        }).doOnError(t -> {
            stopwatch.stop();
            logger.error((Object)("The job for deleting expired metrics failed. Total run time " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"), t);
        }).doOnCompleted(() -> {
            stopwatch.stop();
            logger.info((Object)("The job for deleting expired metrics finished. Total run time " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        }).toCompletable();
    }
}

