/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.PatternUtil;
import org.hawkular.metrics.core.service.tags.parser.TagQueryBaseListener;
import org.hawkular.metrics.core.service.tags.parser.TagQueryLexer;
import org.hawkular.metrics.core.service.tags.parser.TagQueryParser;
import org.hawkular.metrics.core.service.transformers.MetricIdFromMetricIndexRowTransformer;
import org.hawkular.metrics.core.service.transformers.TagsIndexRowTransformerFilter;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import rx.Observable;

public class ExpressionTagQueryParser {
    private DataAccess dataAccess;
    private MetricsService metricsService;

    public ExpressionTagQueryParser(DataAccess dataAccess, MetricsService metricsService) {
        this.dataAccess = dataAccess;
        this.metricsService = metricsService;
    }

    public <T> Observable<Metric<T>> parse(String tenantId, MetricType<T> metricType, String expression) {
        ANTLRInputStream input = new ANTLRInputStream(expression);
        TagQueryLexer tql = new TagQueryLexer(input);
        tql.removeErrorListeners();
        tql.addErrorListener(new ThrowingErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(tql);
        TagQueryParser parser = new TagQueryParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ThrowingErrorListener());
        TagQueryParser.TagqueryContext parseTree = parser.tagquery();
        StorageTagQueryListener<T> listener = new StorageTagQueryListener<T>(tenantId, metricType);
        ParseTreeWalker.DEFAULT.walk(listener, parseTree);
        return listener.getResult();
    }

    private class StorageTagQueryListener<T>
    extends TagQueryBaseListener {
        private Map<Integer, List<String>> arrays = new HashMap<Integer, List<String>>();
        private Map<Integer, List<Observable<MetricId<T>>>> observables = new HashMap<Integer, List<Observable<MetricId<T>>>>();
        private String tenantId;
        private MetricType<T> metricType;

        public StorageTagQueryListener(String tenantId, MetricType<T> metricType) {
            this.tenantId = tenantId;
            this.metricType = metricType;
        }

        public Observable<Metric<T>> getResult() {
            if (this.observables.size() == 1) {
                return this.observables.values().iterator().next().get(0).flatMap(ExpressionTagQueryParser.this.metricsService::findMetric);
            }
            return Observable.empty();
        }

        @Override
        public void exitPair(TagQueryParser.PairContext ctx) {
            String tagName = ctx.key().getText();
            Observable result = null;
            int dataIndex = 3;
            if (ctx.array_operator() != null) {
                List<String> valueArray = this.arrays.get(ctx.array().getText().hashCode());
                ArrayList patterns = new ArrayList(valueArray.size());
                valueArray.forEach(tagValue -> patterns.add(PatternUtil.filterPattern(tagValue)));
                boolean positive = ctx.array_operator().NOT() == null;
                result = ExpressionTagQueryParser.this.dataAccess.findMetricsByTagName(this.tenantId, tagName).filter(r -> {
                    for (Pattern p : patterns) {
                        if (positive && p.matcher(r.getString(dataIndex)).matches()) {
                            return true;
                        }
                        if (positive || !p.matcher(r.getString(dataIndex)).matches()) continue;
                        return false;
                    }
                    return !positive;
                }).compose(new TagsIndexRowTransformerFilter<T>(this.metricType)).distinct();
            } else if (ctx.boolean_operator() != null) {
                String tagValue2;
                if (ctx.value().COMPLEXTEXT() != null) {
                    String tempTagValue = ctx.value().COMPLEXTEXT().getText();
                    tagValue2 = tempTagValue.substring(1, tempTagValue.length() - 1);
                } else {
                    tagValue2 = ctx.value().SIMPLETEXT() != null ? ctx.value().SIMPLETEXT().getText() : null;
                }
                if (tagValue2 != null) {
                    boolean positive;
                    boolean bl = positive = ctx.boolean_operator().EQUAL() != null;
                    result = positive ? ExpressionTagQueryParser.this.dataAccess.findMetricsByTagNameValue(this.tenantId, tagName, tagValue2).compose(new TagsIndexRowTransformerFilter<T>(this.metricType)).distinct() : ExpressionTagQueryParser.this.dataAccess.findMetricsByTagName(this.tenantId, tagName).filter(r -> !tagValue2.equals(r.getString(dataIndex))).compose(new TagsIndexRowTransformerFilter<T>(this.metricType)).distinct();
                }
            } else if (ctx.regex_operator() != null) {
                String tagValue3;
                if (ctx.value().COMPLEXTEXT() != null) {
                    String tempTagValue = ctx.value().COMPLEXTEXT().getText();
                    tagValue3 = tempTagValue.substring(1, tempTagValue.length() - 1);
                } else {
                    tagValue3 = ctx.value().SIMPLETEXT() != null ? ctx.value().SIMPLETEXT().getText() : null;
                }
                if (tagValue3 != null) {
                    Pattern p = PatternUtil.filterPattern(tagValue3);
                    boolean positive = ctx.regex_operator().REGEXMATCH() != null;
                    result = ExpressionTagQueryParser.this.dataAccess.findMetricsByTagName(this.tenantId, tagName).filter(r -> positive == p.matcher(r.getString(dataIndex)).matches()).compose(new TagsIndexRowTransformerFilter<T>(this.metricType)).distinct();
                }
            } else if (ctx.existence_operator() != null) {
                if (ctx.existence_operator().NOT() != null) {
                    if (this.metricType != null) {
                        result = ExpressionTagQueryParser.this.dataAccess.findMetricsInMetricsIndex(this.tenantId, this.metricType).filter(r -> r.getMap(1, String.class, String.class).get(tagName) == null).compose(new MetricIdFromMetricIndexRowTransformer<T>(this.tenantId, this.metricType)).distinct();
                    } else {
                        for (MetricType<?> ltype : MetricType.userTypes()) {
                            Observable lresult = ExpressionTagQueryParser.this.dataAccess.findMetricsInMetricsIndex(this.tenantId, ltype).filter(r -> r.getMap(1, String.class, String.class).get(tagName) == null).compose(new MetricIdFromMetricIndexRowTransformer(this.tenantId, ltype)).distinct();
                            if (result != null) {
                                result = result.concatWith(lresult);
                                continue;
                            }
                            result = lresult;
                        }
                    }
                }
            } else {
                result = ExpressionTagQueryParser.this.dataAccess.findMetricsByTagName(this.tenantId, tagName).compose(new TagsIndexRowTransformerFilter<T>(this.metricType)).distinct();
            }
            this.pushObservable(ctx.getText().hashCode(), result);
        }

        @Override
        public void exitObject(TagQueryParser.ObjectContext ctx) {
            if (ctx.logical_operator() != null) {
                Observable<MetricId<T>> leftObservable = this.popObservable(ctx.object(0).getText().hashCode());
                Observable<MetricId<T>> rightObservable = this.popObservable(ctx.object(1).getText().hashCode());
                this.observables.remove(ctx.object(0).getText().hashCode());
                this.observables.remove(ctx.object(1).getText().hashCode());
                Observable result = leftObservable.concatWith(rightObservable);
                if (ctx.logical_operator().AND() != null) {
                    result = result.groupBy(m -> m).flatMap(s -> s.skip(1).take(1));
                } else if (ctx.logical_operator().OR() != null) {
                    result = result.distinct();
                }
                this.pushObservable(ctx.getText().hashCode(), result);
            } else if (ctx.object(0) != null && ctx.object(0).getText().hashCode() != ctx.getText().hashCode()) {
                Observable<MetricId<T>> expressionObservable = this.popObservable(ctx.object(0).getText().hashCode());
                this.observables.remove(ctx.object(0).getText().hashCode());
                this.pushObservable(ctx.getText().hashCode(), expressionObservable);
            }
        }

        @Override
        public void enterArray(TagQueryParser.ArrayContext ctx) {
            ArrayList<String> arrayContext = new ArrayList<String>();
            for (TagQueryParser.ValueContext node : ctx.value()) {
                String text;
                if (node.COMPLEXTEXT() != null) {
                    text = node.COMPLEXTEXT().getText();
                    arrayContext.add(text.substring(1, text.length() - 1));
                    continue;
                }
                if (node.SIMPLETEXT() == null) continue;
                text = node.SIMPLETEXT().getText();
                arrayContext.add(text);
            }
            this.arrays.put(ctx.getText().hashCode(), arrayContext);
        }

        private void pushObservable(Integer hashCode, Observable<MetricId<T>> observable) {
            List<Observable<MetricId<T>>> hashObservables = this.observables.get(hashCode);
            if (hashObservables != null) {
                hashObservables.add(observable);
            } else {
                hashObservables = new ArrayList<Observable<MetricId<T>>>();
                hashObservables.add(observable);
                this.observables.put(hashCode, hashObservables);
            }
        }

        private Observable<MetricId<T>> popObservable(Integer hashCode) {
            List<Observable<MetricId<T>>> hashObservables = this.observables.get(hashCode);
            if (hashObservables == null || hashObservables.isEmpty()) {
                return null;
            }
            Observable<MetricId<T>> observable = hashObservables.remove(0);
            if (hashObservables.isEmpty()) {
                this.observables.remove(hashCode);
            }
            return observable;
        }
    }

    public class ThrowingErrorListener
    extends BaseErrorListener {
        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

