/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hawkular.metrics.core.service.PatternUtil;
import org.hawkular.metrics.core.service.transformers.TaggedDataPointCollector;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Percentile;
import org.hawkular.metrics.model.TaggedBucketPoint;
import rx.Observable;

public class TaggedBucketPointTransformer
implements Observable.Transformer<DataPoint<? extends Number>, Map<String, TaggedBucketPoint>> {
    private final Map<String, String> tags;
    private final List<Percentile> percentiles;

    public TaggedBucketPointTransformer(Map<String, String> tags, List<Percentile> percentiles) {
        this.tags = tags;
        this.percentiles = percentiles;
    }

    public Observable<Map<String, TaggedBucketPoint>> call(Observable<DataPoint<? extends Number>> dataPoints) {
        Predicate<DataPoint> filter = dataPoint -> true;
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            boolean positive = !entry.getValue().startsWith("!");
            Pattern pattern = PatternUtil.filterPattern(entry.getValue());
            filter = filter.and(dataPoint -> dataPoint.getTags().containsKey(entry.getKey()) && positive == pattern.matcher(dataPoint.getTags().get(entry.getKey())).matches());
        }
        return dataPoints.filter(filter::test).groupBy(dataPoint -> this.tags.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> dataPoint.getTags().get(e.getKey())))).flatMap(group -> group.collect(() -> new TaggedDataPointCollector((Map)group.getKey(), this.percentiles), TaggedDataPointCollector::increment)).map(TaggedDataPointCollector::toBucketPoint).toMap(bucketPoint -> bucketPoint.getTags().entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",")));
    }
}

