/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CQL3CasRequest;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.UpdatesCollector;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class BatchStatement
implements CQLStatement {
    private final int boundTerms;
    public final Type type;
    private final List<ModificationStatement> statements;
    private final Map<UUID, PartitionColumns> updatedColumns;
    private final PartitionColumns conditionColumns;
    private final boolean updatesRegularRows;
    private final boolean updatesStaticRow;
    private final Attributes attrs;
    private final boolean hasConditions;
    private static final Logger logger = LoggerFactory.getLogger(BatchStatement.class);
    private static final String UNLOGGED_BATCH_WARNING = "Unlogged batch covering {} partitions detected against table{} {}. You should use a logged batch for atomicity, or asynchronous writes for performance.";
    private static final String LOGGED_BATCH_LOW_GCGS_WARNING = "Executing a LOGGED BATCH on table{} {}, configured with a gc_grace_seconds of 0. The gc_grace_seconds is used to TTL batchlog entries, so setting gc_grace_seconds too low on tables involved in an atomic batch might cause batchlog entries to expire before being replayed.";

    public BatchStatement(int boundTerms, Type type, List<ModificationStatement> statements, Attributes attrs) {
        this.boundTerms = boundTerms;
        this.type = type;
        this.statements = statements;
        this.attrs = attrs;
        boolean hasConditions = false;
        MultiTableColumnsBuilder regularBuilder = new MultiTableColumnsBuilder();
        PartitionColumns.Builder conditionBuilder = PartitionColumns.builder();
        boolean updateRegular = false;
        boolean updateStatic = false;
        for (ModificationStatement stmt : statements) {
            regularBuilder.addAll(stmt.cfm, stmt.updatedColumns());
            updateRegular |= stmt.updatesRegularRows();
            if (!stmt.hasConditions()) continue;
            hasConditions = true;
            conditionBuilder.addAll(stmt.conditionColumns());
            updateStatic |= stmt.updatesStaticRow();
        }
        this.updatedColumns = regularBuilder.build();
        this.conditionColumns = conditionBuilder.build();
        this.updatesRegularRows = updateRegular;
        this.updatesStaticRow = updateStatic;
        this.hasConditions = hasConditions;
    }

    @Override
    public Iterable<org.apache.cassandra.cql3.functions.Function> getFunctions() {
        ArrayList<org.apache.cassandra.cql3.functions.Function> functions = new ArrayList<org.apache.cassandra.cql3.functions.Function>();
        for (ModificationStatement statement : this.statements) {
            statement.addFunctionsTo(functions);
        }
        return functions;
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        for (ModificationStatement statement : this.statements) {
            statement.checkAccess(state);
        }
    }

    public void validate() throws InvalidRequestException {
        if (this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        boolean timestampSet = this.attrs.isTimestampSet();
        if (timestampSet) {
            if (this.hasConditions) {
                throw new InvalidRequestException("Cannot provide custom timestamp for conditional BATCH");
            }
            if (this.isCounter()) {
                throw new InvalidRequestException("Cannot provide custom timestamp for counter BATCH");
            }
        }
        boolean hasCounters = false;
        boolean hasNonCounters = false;
        for (ModificationStatement statement : this.statements) {
            if (timestampSet && statement.isCounter()) {
                throw new InvalidRequestException("Cannot provide custom timestamp for a BATCH containing counters");
            }
            if (timestampSet && statement.isTimestampSet()) {
                throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
            }
            if (this.isCounter() && !statement.isCounter()) {
                throw new InvalidRequestException("Cannot include non-counter statement in a counter batch");
            }
            if (this.isLogged() && statement.isCounter()) {
                throw new InvalidRequestException("Cannot include a counter statement in a logged batch");
            }
            if (statement.isCounter()) {
                hasCounters = true;
                continue;
            }
            hasNonCounters = true;
        }
        if (hasCounters && hasNonCounters) {
            throw new InvalidRequestException("Counter and non-counter mutations cannot exist in the same batch");
        }
        if (this.hasConditions) {
            String ksName = null;
            String cfName = null;
            for (ModificationStatement stmt : this.statements) {
                if (!(ksName == null || stmt.keyspace().equals(ksName) && stmt.columnFamily().equals(cfName))) {
                    throw new InvalidRequestException("Batch with conditions cannot span multiple tables");
                }
                ksName = stmt.keyspace();
                cfName = stmt.columnFamily();
            }
        }
    }

    private boolean isCounter() {
        return this.type == Type.COUNTER;
    }

    private boolean isLogged() {
        return this.type == Type.LOGGED;
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.validate(state);
        }
    }

    public List<ModificationStatement> getStatements() {
        return this.statements;
    }

    private Collection<? extends IMutation> getMutations(BatchQueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        HashSet<String> tablesWithZeroGcGs = null;
        UpdatesCollector collector = new UpdatesCollector(this.updatedColumns, this.updatedRows());
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            if (this.isLogged() && statement.cfm.params.gcGraceSeconds == 0) {
                if (tablesWithZeroGcGs == null) {
                    tablesWithZeroGcGs = new HashSet<String>();
                }
                tablesWithZeroGcGs.add(String.format("%s.%s", statement.cfm.ksName, statement.cfm.cfName));
            }
            QueryOptions statementOptions = options.forStatement(i);
            long timestamp = this.attrs.getTimestamp(now, statementOptions);
            statement.addUpdates(collector, statementOptions, local, timestamp);
        }
        if (tablesWithZeroGcGs != null) {
            String suffix = tablesWithZeroGcGs.size() == 1 ? "" : "s";
            NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, LOGGED_BATCH_LOW_GCGS_WARNING, suffix, tablesWithZeroGcGs);
            ClientWarn.instance.warn(MessageFormatter.arrayFormat(LOGGED_BATCH_LOW_GCGS_WARNING, new Object[]{suffix, tablesWithZeroGcGs}).getMessage());
        }
        collector.validateIndexedColumns();
        return collector.toMutations();
    }

    private int updatedRows() {
        return this.statements.size();
    }

    public static void verifyBatchSize(Iterable<PartitionUpdate> updates) throws InvalidRequestException {
        long size = 0L;
        long warnThreshold = DatabaseDescriptor.getBatchSizeWarnThreshold();
        long failThreshold = DatabaseDescriptor.getBatchSizeFailThreshold();
        for (PartitionUpdate partitionUpdate : updates) {
            size += (long)partitionUpdate.dataSize();
        }
        if (size > warnThreshold) {
            HashSet<String> tableNames = new HashSet<String>();
            for (PartitionUpdate update : updates) {
                tableNames.add(String.format("%s.%s", update.metadata().ksName, update.metadata().cfName));
            }
            String string = "Batch of prepared statements for {} is of size {}, exceeding specified threshold of {} by {}.{}";
            if (size > failThreshold) {
                Tracing.trace(string, tableNames, size, failThreshold, size - failThreshold, " (see batch_size_fail_threshold_in_kb)");
                logger.error(string, tableNames, size, failThreshold, size - failThreshold, " (see batch_size_fail_threshold_in_kb)");
                throw new InvalidRequestException("Batch too large");
            }
            if (logger.isWarnEnabled()) {
                logger.warn(string, tableNames, size, warnThreshold, size - warnThreshold, "");
            }
            ClientWarn.instance.warn(MessageFormatter.arrayFormat(string, new Object[]{tableNames, size, warnThreshold, size - warnThreshold, ""}).getMessage());
        }
    }

    private void verifyBatchType(Iterable<PartitionUpdate> updates) {
        if (!this.isLogged() && Iterables.size(updates) > 1) {
            HashSet<DecoratedKey> keySet = new HashSet<DecoratedKey>();
            HashSet<String> tableNames = new HashSet<String>();
            for (PartitionUpdate update : updates) {
                keySet.add(update.partitionKey());
                tableNames.add(String.format("%s.%s", update.metadata().ksName, update.metadata().cfName));
            }
            if (keySet.size() > DatabaseDescriptor.getUnloggedBatchAcrossPartitionsWarnThreshold()) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, UNLOGGED_BATCH_WARNING, keySet.size(), tableNames.size() == 1 ? "" : "s", tableNames);
                ClientWarn.instance.warn(MessageFormatter.arrayFormat(UNLOGGED_BATCH_WARNING, new Object[]{keySet.size(), tableNames.size() == 1 ? "" : "s", tableNames}).getMessage());
            }
        }
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.execute(queryState, BatchQueryOptions.withoutPerStatementVariables(options));
    }

    public ResultMessage execute(QueryState queryState, BatchQueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.execute(queryState, options, false, options.getTimestamp(queryState));
    }

    private ResultMessage execute(QueryState queryState, BatchQueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        if (options.getSerialConsistency() == null) {
            throw new InvalidRequestException("Invalid empty serial consistency level");
        }
        if (this.hasConditions) {
            return this.executeWithConditions(options, queryState);
        }
        this.executeWithoutConditions(this.getMutations(options, local, now), options.getConsistency());
        return new ResultMessage.Void();
    }

    private void executeWithoutConditions(Collection<? extends IMutation> mutations, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        if (mutations.isEmpty()) {
            return;
        }
        Iterable<PartitionUpdate> updates = Iterables.concat(Iterables.transform(mutations, new Function<IMutation, Collection<PartitionUpdate>>(){

            @Override
            public Collection<PartitionUpdate> apply(IMutation im) {
                return im.getPartitionUpdates();
            }
        }));
        BatchStatement.verifyBatchSize(updates);
        this.verifyBatchType(updates);
        boolean mutateAtomic = this.isLogged() && mutations.size() > 1;
        StorageProxy.mutateWithTriggers(mutations, cl, mutateAtomic);
    }

    private ResultMessage executeWithConditions(BatchQueryOptions options, QueryState state) throws RequestExecutionException, RequestValidationException {
        Pair<CQL3CasRequest, Set<ColumnDefinition>> p = this.makeCasRequest(options, state);
        CQL3CasRequest casRequest = (CQL3CasRequest)p.left;
        Set columnsWithConditions = (Set)p.right;
        String ksName = casRequest.cfm.ksName;
        String tableName = casRequest.cfm.cfName;
        try (RowIterator result = StorageProxy.cas(ksName, tableName, casRequest.key, casRequest, options.getSerialConsistency(), options.getConsistency(), state.getClientState());){
            ResultMessage.Rows rows = new ResultMessage.Rows(ModificationStatement.buildCasResultSet(ksName, tableName, result, columnsWithConditions, true, options.forStatement(0)));
            return rows;
        }
    }

    private Pair<CQL3CasRequest, Set<ColumnDefinition>> makeCasRequest(BatchQueryOptions options, QueryState state) {
        long now = state.getTimestamp();
        DecoratedKey key = null;
        CQL3CasRequest casRequest = null;
        LinkedHashSet columnsWithConditions = new LinkedHashSet();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            QueryOptions statementOptions = options.forStatement(i);
            long timestamp = this.attrs.getTimestamp(now, statementOptions);
            List<ByteBuffer> pks = statement.buildPartitionKeyNames(statementOptions);
            if (pks.size() > 1) {
                throw new IllegalArgumentException("Batch with conditions cannot span multiple partitions (you cannot use IN on the partition key)");
            }
            if (key == null) {
                key = statement.cfm.decorateKey(pks.get(0));
                casRequest = new CQL3CasRequest(statement.cfm, key, true, this.conditionColumns, this.updatesRegularRows, this.updatesStaticRow);
            } else if (!key.getKey().equals(pks.get(0))) {
                throw new InvalidRequestException("Batch with conditions cannot span multiple partitions");
            }
            NavigableSet<Clustering> clusterings = statement.createClustering(statementOptions);
            RequestValidations.checkFalse(clusterings.size() > 1, "IN on the clustering key columns is not supported with conditional updates");
            Clustering clustering = Iterables.getOnlyElement(clusterings);
            if (statement.hasConditions()) {
                statement.addConditions(clustering, casRequest, statementOptions);
                if (statement.hasIfNotExistCondition() || statement.hasIfExistCondition()) {
                    columnsWithConditions = null;
                } else if (columnsWithConditions != null) {
                    Iterables.addAll(columnsWithConditions, statement.getColumnsWithConditions());
                }
            }
            casRequest.addRowUpdate(clustering, statement, statementOptions, timestamp);
        }
        return Pair.create(casRequest, columnsWithConditions);
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        if (this.hasConditions) {
            return this.executeInternalWithConditions(BatchQueryOptions.withoutPerStatementVariables(options), queryState);
        }
        this.executeInternalWithoutCondition(queryState, options);
        return new ResultMessage.Void();
    }

    private ResultMessage executeInternalWithoutCondition(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        for (IMutation iMutation : this.getMutations(BatchQueryOptions.withoutPerStatementVariables(options), true, queryState.getTimestamp())) {
            assert (iMutation instanceof Mutation || iMutation instanceof CounterMutation);
            if (iMutation instanceof Mutation) {
                ((Mutation)iMutation).apply();
                continue;
            }
            if (!(iMutation instanceof CounterMutation)) continue;
            ((CounterMutation)iMutation).apply();
        }
        return null;
    }

    private ResultMessage executeInternalWithConditions(BatchQueryOptions options, QueryState state) throws RequestExecutionException, RequestValidationException {
        Pair<CQL3CasRequest, Set<ColumnDefinition>> p = this.makeCasRequest(options, state);
        CQL3CasRequest request = (CQL3CasRequest)p.left;
        Set columnsWithConditions = (Set)p.right;
        String ksName = request.cfm.ksName;
        String tableName = request.cfm.cfName;
        try (RowIterator result = ModificationStatement.casInternal(request, state);){
            ResultMessage.Rows rows = new ResultMessage.Rows(ModificationStatement.buildCasResultSet(ksName, tableName, result, columnsWithConditions, true, options.forStatement(0)));
            return rows;
        }
    }

    public String toString() {
        return String.format("BatchStatement(type=%s, statements=%s)", new Object[]{this.type, this.statements});
    }

    private static class MultiTableColumnsBuilder {
        private final Map<UUID, PartitionColumns.Builder> perTableBuilders = new HashMap<UUID, PartitionColumns.Builder>();

        private MultiTableColumnsBuilder() {
        }

        public void addAll(CFMetaData table, PartitionColumns columns) {
            PartitionColumns.Builder builder = this.perTableBuilders.get(table.cfId);
            if (builder == null) {
                builder = PartitionColumns.builder();
                this.perTableBuilders.put(table.cfId, builder);
            }
            builder.addAll(columns);
        }

        public Map<UUID, PartitionColumns> build() {
            HashMap<UUID, PartitionColumns> m = new HashMap<UUID, PartitionColumns>();
            for (Map.Entry<UUID, PartitionColumns.Builder> p : this.perTableBuilders.entrySet()) {
                m.put(p.getKey(), p.getValue().build());
            }
            return m;
        }
    }

    public static class Parsed
    extends CFStatement {
        private final Type type;
        private final Attributes.Raw attrs;
        private final List<ModificationStatement.Parsed> parsedStatements;

        public Parsed(Type type, Attributes.Raw attrs, List<ModificationStatement.Parsed> parsedStatements) {
            super(null);
            this.type = type;
            this.attrs = attrs;
            this.parsedStatements = parsedStatements;
        }

        @Override
        public void prepareKeyspace(ClientState state) throws InvalidRequestException {
            for (ModificationStatement.Parsed statement : this.parsedStatements) {
                statement.prepareKeyspace(state);
            }
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            VariableSpecifications boundNames = this.getBoundVariables();
            String firstKS = null;
            String firstCF = null;
            boolean haveMultipleCFs = false;
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(this.parsedStatements.size());
            for (ModificationStatement.Parsed parsed : this.parsedStatements) {
                if (firstKS == null) {
                    firstKS = parsed.keyspace();
                    firstCF = parsed.columnFamily();
                } else if (!haveMultipleCFs) {
                    haveMultipleCFs = !firstKS.equals(parsed.keyspace()) || !firstCF.equals(parsed.columnFamily());
                }
                statements.add(parsed.prepare(boundNames));
            }
            Attributes prepAttrs = this.attrs.prepare("[batch]", "[batch]");
            prepAttrs.collectMarkerSpecification(boundNames);
            BatchStatement batchStatement = new BatchStatement(boundNames.size(), this.type, statements, prepAttrs);
            batchStatement.validate();
            Short[] partitionKeyBindIndexes = haveMultipleCFs || batchStatement.statements.isEmpty() ? null : boundNames.getPartitionKeyBindIndexes(((ModificationStatement)((BatchStatement)batchStatement).statements.get((int)0)).cfm);
            return new ParsedStatement.Prepared((CQLStatement)batchStatement, boundNames, partitionKeyBindIndexes);
        }
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

