/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingRepairTask
implements Runnable,
StreamEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StreamingRepairTask.class);
    private final RepairJobDesc desc;
    private final SyncRequest request;
    private final long repairedAt;

    public StreamingRepairTask(RepairJobDesc desc, SyncRequest request, long repairedAt) {
        this.desc = desc;
        this.request = request;
        this.repairedAt = repairedAt;
    }

    @Override
    public void run() {
        InetAddress dest = this.request.dst;
        InetAddress preferred = SystemKeyspace.getPreferredIP(dest);
        logger.info(String.format("[streaming task #%s] Performing streaming repair of %d ranges with %s", this.desc.sessionId, this.request.ranges.size(), this.request.dst));
        boolean isIncremental = false;
        if (this.desc.parentSessionId != null) {
            ActiveRepairService.ParentRepairSession prs = ActiveRepairService.instance.getParentRepairSession(this.desc.parentSessionId);
            isIncremental = prs.isIncremental;
        }
        new StreamPlan("Repair", this.repairedAt, 1, false, isIncremental).listeners(this, new StreamEventHandler[0]).flushBeforeTransfer(true).requestRanges(dest, preferred, this.desc.keyspace, this.request.ranges, this.desc.columnFamily).transferRanges(dest, preferred, this.desc.keyspace, this.request.ranges, this.desc.columnFamily).execute();
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
    }

    @Override
    public void onSuccess(StreamState state) {
        logger.info(String.format("[repair #%s] streaming task succeed, returning response to %s", this.desc.sessionId, this.request.initiator));
        MessagingService.instance().sendOneWay(new SyncComplete(this.desc, this.request.src, this.request.dst, true).createMessage(), this.request.initiator);
    }

    @Override
    public void onFailure(Throwable t) {
        MessagingService.instance().sendOneWay(new SyncComplete(this.desc, this.request.src, this.request.dst, false).createMessage(), this.request.initiator);
    }
}

