/*
 * Decompiled with CFR 0.152.
 */
package org.cassalog.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cassalog.core.Bootstrap;
import org.cassalog.core.BootstrapException;
import org.cassalog.core.Cassalog;
import org.cassalog.core.CassandraVersionException;
import org.cassalog.core.ChangeLog;
import org.cassalog.core.ChangeSet;
import org.cassalog.core.ChangeSetAlteredException;
import org.cassalog.core.ChangeSetException;
import org.cassalog.core.ChangeSetListener;
import org.cassalog.core.CqlChangeSet;
import org.cassalog.core.CreateKeyspace;
import org.cassalog.core.KeyspaceUndefinedException;
import org.cassalog.core.SchemaAgreementException;
import org.cassalog.core.SetKeyspace;
import org.cassalog.core.VerificationFunctions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassalogImpl
implements Cassalog,
GroovyObject {
    private static final String CHANGELOG_TABLE = "cassalog";
    private static final int DEFAULT_BUCKET_SIZE = 50;
    private static final ChangeSetListener NO_OP_LISTENER;
    private String keyspace;
    private Session session;
    private String baseScriptsPath;
    private int bucketSize;
    private PreparedStatement insertSchemaChange;
    private PreparedStatement updateAppliedAt;
    private ConsistencyLevel consistencyLevel;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CassalogImpl() {
        MetaClass metaClass;
        int n;
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        this.bucketSize = n = DEFAULT_BUCKET_SIZE;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void execute(URI script) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        callSiteArray[0].callCurrent(this, script, callSiteArray[1].call(Collections.class));
    }

    @Override
    public void execute(URI script, Map vars) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        callSiteArray[2].callCurrent(this, script, callSiteArray[3].call(Collections.class), vars);
    }

    @Override
    public void execute(URI script, Collection tags) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        callSiteArray[4].callCurrent(this, script, tags, ScriptBytecodeAdapter.createMap(new Object[]{"keyspace", this.keyspace}));
    }

    @Override
    public void execute(URI script, Collection tags, Map vars) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        callSiteArray[5].callCurrent(this, script, tags, vars, NO_OP_LISTENER);
    }

    @Override
    public void execute(URI script, Collection tags, Map vars, ChangeSetListener listener) {
        Reference<Collection> tags2 = new Reference<Collection>(tags);
        Reference<ChangeSetListener> listener2 = new Reference<ChangeSetListener>(listener);
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[6].callCurrent(this);
        } else {
            this.verifyCassandraVersion();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[7].callCurrent(this);
        } else {
            this.verifySchemaAgreement();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[8].callCurrent(this);
        } else {
            this.determineConsistencyLevel();
        }
        Object object = DefaultTypeTransformation.booleanUnbox(callSiteArray[9].call(log)) ? callSiteArray[10].call((Object)log, new GStringImpl(new Object[]{ScriptBytecodeAdapter.createMap(new Object[]{"script", script, "tags", tags2.get(), "vars", vars})}, new String[]{"Executing ", ""})) : null;
        List changeSets = ScriptBytecodeAdapter.createList(new Object[0]);
        Reference<Object> changeLog = new Reference<Object>(null);
        changeLog.get();
        GroovyShell shell = (GroovyShell)ScriptBytecodeAdapter.castToType(callSiteArray[11].callConstructor(GroovyShell.class, callSiteArray[12].callCurrent(this, changeSets, vars)), GroovyShell.class);
        callSiteArray[13].call((Object)shell, script);
        if (callSiteArray[14].call((Object)changeSets, 0) instanceof CreateKeyspace) {
            Object object2 = callSiteArray[15].callGetProperty(callSiteArray[16].call((Object)changeSets, 0));
            this.keyspace = ShortTypeHandling.castToString(object2);
            if (DefaultTypeTransformation.booleanUnbox(callSiteArray[17].callGetProperty(callSiteArray[18].call((Object)changeSets, 0)))) {
                Object object3 = DefaultTypeTransformation.booleanUnbox(callSiteArray[19].call(log)) ? callSiteArray[20].call((Object)log, new GStringImpl(new Object[]{this.keyspace}, new String[]{"Dropping keyspace ", ""})) : null;
                callSiteArray[21].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{this.keyspace}, new String[]{"DROP KEYSPACE IF EXISTS ", ""}));
            }
            if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[22].callCurrent(this))) {
                callSiteArray[23].callCurrent(this, callSiteArray[24].call((Object)changeSets, 0), 0, false, listener2.get());
                callSiteArray[25].callCurrent(this);
                callSiteArray[26].callCurrent(this);
                callSiteArray[27].callCurrent((GroovyObject)this, callSiteArray[28].call((Object)this.insertSchemaChange, ArrayUtil.createArray(0, 0, callSiteArray[29].callGetProperty(callSiteArray[30].call((Object)changeSets, 0)), callSiteArray[31].callGetProperty(callSiteArray[32].call((Object)changeSets, 0)), callSiteArray[33].callGetProperty(callSiteArray[34].call((Object)changeSets, 0)), callSiteArray[35].callGetProperty(callSiteArray[36].call((Object)changeSets, 0)), callSiteArray[37].callGetProperty(callSiteArray[38].call((Object)changeSets, 0)))));
                callSiteArray[39].callCurrent((GroovyObject)this, callSiteArray[40].call(this.updateAppliedAt, callSiteArray[41].callConstructor(Date.class), 0, 0));
            }
        }
        class _execute_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _execute_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                return null;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _execute_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_execute_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _execute_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object bootstrap = new _execute_closure1(this, this);
        if (callSiteArray[42].call((Object)changeSets, 0) instanceof Closure) {
            Object object4;
            bootstrap = object4 = callSiteArray[43].call((Object)changeSets, 0);
        }
        callSiteArray[44].callCurrent((GroovyObject)this, changeSets);
        callSiteArray[45].call(bootstrap);
        if (ScriptBytecodeAdapter.compareEqual(this.keyspace, null)) {
            throw (Throwable)callSiteArray[46].callConstructor(KeyspaceUndefinedException.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[47].callCurrent(this);
        } else {
            this.createChangeLogTableIfNecessary();
        }
        Object object5 = callSiteArray[48].callConstructor(ChangeLog.class, ScriptBytecodeAdapter.createMap(new Object[]{"session", this.session, "keyspace", this.keyspace, "bucketSize", this.bucketSize, "consistencyLevel", this.consistencyLevel}));
        changeLog.set(object5);
        callSiteArray[49].call(changeLog.get());
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[50].callCurrent(this);
        } else {
            this.initPreparedStatements();
        }
        class _execute_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tags;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _execute_closure2(Object _outerInstance, Object _thisObject, Reference tags) {
                Reference reference;
                CallSite[] callSiteArray = _execute_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.tags = reference = tags;
            }

            public Object doCall(Object changeSetTags) {
                CallSite[] callSiteArray = _execute_closure2.$getCallSiteArray();
                class _closure27
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tags;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure27(Object _outerInstance, Object _thisObject, Reference tags) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.tags = reference = tags;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                        return callSiteArray[0].call(this.tags.get(), it);
                    }

                    public Collection getTags() {
                        CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                        return (Collection)ScriptBytecodeAdapter.castToType(this.tags.get(), Collection.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "contains";
                        return new CallSiteArray(_closure27.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure27.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return DefaultTypeTransformation.booleanUnbox(callSiteArray[0].callGetProperty(this.tags.get())) || DefaultTypeTransformation.booleanUnbox(callSiteArray[1].call(changeSetTags, new _closure27(this, this.getThisObject(), this.tags)));
            }

            public Collection getTags() {
                CallSite[] callSiteArray = _execute_closure2.$getCallSiteArray();
                return (Collection)ScriptBytecodeAdapter.castToType(this.tags.get(), Collection.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _execute_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "empty";
                stringArray[1] = "any";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _execute_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_execute_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _execute_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference<_execute_closure2> tagsFilter = new Reference<_execute_closure2>(new _execute_closure2(this, this, tags2));
        class _execute_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tagsFilter;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _execute_closure3(Object _outerInstance, Object _thisObject, Reference tagsFilter) {
                Reference reference;
                CallSite[] callSiteArray = _execute_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.tagsFilter = reference = tagsFilter;
            }

            public Object doCall(Object change) {
                CallSite[] callSiteArray = _execute_closure3.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox(callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(change))) || DefaultTypeTransformation.booleanUnbox(callSiteArray[2].call(this.tagsFilter.get(), callSiteArray[3].callGetProperty(change)));
            }

            public Object getTagsFilter() {
                CallSite[] callSiteArray = _execute_closure3.$getCallSiteArray();
                return this.tagsFilter.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _execute_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "empty";
                stringArray[1] = "tags";
                stringArray[2] = "call";
                stringArray[3] = "tags";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _execute_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_execute_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _execute_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        class _execute_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference listener;
            private /* synthetic */ Reference changeLog;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _execute_closure4(Object _outerInstance, Object _thisObject, Reference listener, Reference changeLog) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _execute_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.listener = reference2 = listener;
                this.changeLog = reference = changeLog;
            }

            public Object doCall(Object change, int i) {
                CallSite[] callSiteArray = _execute_closure4.$getCallSiteArray();
                callSiteArray[0].call(change);
                if (change instanceof CreateKeyspace && ScriptBytecodeAdapter.compareEqual(callSiteArray[1].callGetProperty(change), true)) {
                    callSiteArray[2].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{callSiteArray[3].callGroovyObjectGetProperty(this)}, new String[]{"USE ", ""}));
                }
                if (DefaultTypeTransformation.booleanUnbox(callSiteArray[4].callGetProperty(change))) {
                    if (ScriptBytecodeAdapter.compareLessThan(i, callSiteArray[5].callGetProperty(this.changeLog.get()))) {
                        callSiteArray[6].callCurrent(this, change, callSiteArray[7].call(this.changeLog.get(), i));
                        return callSiteArray[8].callCurrent(this, change, i, false, this.listener.get());
                    }
                    return callSiteArray[9].callCurrent(this, change, i, true, this.listener.get());
                }
                if (ScriptBytecodeAdapter.compareLessThan(i, callSiteArray[10].callGetProperty(this.changeLog.get()))) {
                    callSiteArray[11].callCurrent(this, change, callSiteArray[12].call(this.changeLog.get(), i));
                    if (ScriptBytecodeAdapter.compareEqual(callSiteArray[13].callGetProperty(callSiteArray[14].call(this.changeLog.get(), i)), null)) {
                        if (ScriptBytecodeAdapter.compareNotEqual(callSiteArray[15].callGetProperty(change), null) && DefaultTypeTransformation.booleanUnbox(callSiteArray[16].call(change))) {
                            callSiteArray[17].callCurrent(this, i, callSiteArray[18].callGetProperty(callSiteArray[19].call(this.changeLog.get(), i)));
                            return callSiteArray[20].call(this.listener.get(), change);
                        }
                        return callSiteArray[21].callCurrent(this, change, i, true, this.listener.get());
                    }
                    return null;
                }
                Object object = callSiteArray[22].callCurrent(this, change, i, true, this.listener.get());
                try {
                    return object;
                }
                catch (InvalidQueryException e) {
                    throw (Throwable)callSiteArray[23].callConstructor(ChangeSetException.class, e);
                }
            }

            public Object call(Object change, int i) {
                CallSite[] callSiteArray = _execute_closure4.$getCallSiteArray();
                return callSiteArray[24].callCurrent(this, change, i);
            }

            public ChangeSetListener getListener() {
                CallSite[] callSiteArray = _execute_closure4.$getCallSiteArray();
                return (ChangeSetListener)ScriptBytecodeAdapter.castToType(this.listener.get(), ChangeSetListener.class);
            }

            public Object getChangeLog() {
                CallSite[] callSiteArray = _execute_closure4.$getCallSiteArray();
                return this.changeLog.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _execute_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "validate";
                stringArray[1] = "active";
                stringArray[2] = "executeCQL";
                stringArray[3] = "keyspace";
                stringArray[4] = "alwaysRun";
                stringArray[5] = "size";
                stringArray[6] = "validateChange";
                stringArray[7] = "getAt";
                stringArray[8] = "applyChangeSet";
                stringArray[9] = "applyChangeSet";
                stringArray[10] = "size";
                stringArray[11] = "validateChange";
                stringArray[12] = "getAt";
                stringArray[13] = "appliedAt";
                stringArray[14] = "getAt";
                stringArray[15] = "verifyFunction";
                stringArray[16] = "verifyFunction";
                stringArray[17] = "updateAppliedAt";
                stringArray[18] = "timestamp";
                stringArray[19] = "getAt";
                stringArray[20] = "changeSetApplied";
                stringArray[21] = "applyChangeSet";
                stringArray[22] = "applyChangeSet";
                stringArray[23] = "<$constructor$>";
                stringArray[24] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[25];
                _execute_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_execute_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _execute_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[51].call(callSiteArray[52].call((Object)changeSets, new _execute_closure3(this, this, tagsFilter)), new _execute_closure4(this, this, listener2, changeLog));
    }

    @Override
    public List<ChangeSet> load(URI script, Collection tags, Map vars) {
        Reference<Collection> tags2 = new Reference<Collection>(tags);
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        List changeSets = ScriptBytecodeAdapter.createList(new Object[0]);
        GroovyShell shell = (GroovyShell)ScriptBytecodeAdapter.castToType(callSiteArray[53].callConstructor(GroovyShell.class, callSiteArray[54].callCurrent(this, changeSets, vars)), GroovyShell.class);
        callSiteArray[55].call((Object)shell, script);
        if (callSiteArray[56].call((Object)changeSets, 0) instanceof Closure) {
            callSiteArray[57].call((Object)changeSets, 0);
        }
        callSiteArray[58].callCurrent((GroovyObject)this, changeSets);
        class _load_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tags;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _load_closure5(Object _outerInstance, Object _thisObject, Reference tags) {
                Reference reference;
                CallSite[] callSiteArray = _load_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.tags = reference = tags;
            }

            public Object doCall(Object changeSetTags) {
                CallSite[] callSiteArray = _load_closure5.$getCallSiteArray();
                class _closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tags;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure28(Object _outerInstance, Object _thisObject, Reference tags) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.tags = reference = tags;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return callSiteArray[0].call(this.tags.get(), it);
                    }

                    public Collection getTags() {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return (Collection)ScriptBytecodeAdapter.castToType(this.tags.get(), Collection.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "contains";
                        return new CallSiteArray(_closure28.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure28.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return DefaultTypeTransformation.booleanUnbox(callSiteArray[0].callGetProperty(this.tags.get())) || DefaultTypeTransformation.booleanUnbox(callSiteArray[1].call(changeSetTags, new _closure28(this, this.getThisObject(), this.tags)));
            }

            public Collection getTags() {
                CallSite[] callSiteArray = _load_closure5.$getCallSiteArray();
                return (Collection)ScriptBytecodeAdapter.castToType(this.tags.get(), Collection.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _load_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "empty";
                stringArray[1] = "any";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _load_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_load_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _load_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference<_load_closure5> tagsFilter = new Reference<_load_closure5>(new _load_closure5(this, this, tags2));
        class _load_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tags;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _load_closure6(Object _outerInstance, Object _thisObject, Reference tags) {
                Reference reference;
                CallSite[] callSiteArray = _load_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.tags = reference = tags;
            }

            public Object doCall(Object changeSetTags) {
                CallSite[] callSiteArray = _load_closure6.$getCallSiteArray();
                class _closure29
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tags;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure29(Object _outerInstance, Object _thisObject, Reference tags) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.tags = reference = tags;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                        return callSiteArray[0].call(this.tags.get(), it);
                    }

                    public Collection getTags() {
                        CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                        return (Collection)ScriptBytecodeAdapter.castToType(this.tags.get(), Collection.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure29.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "contains";
                        return new CallSiteArray(_closure29.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure29.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return DefaultTypeTransformation.booleanUnbox(callSiteArray[0].callGetProperty(this.tags.get())) || DefaultTypeTransformation.booleanUnbox(callSiteArray[1].call(changeSetTags, new _closure29(this, this.getThisObject(), this.tags)));
            }

            public Collection getTags() {
                CallSite[] callSiteArray = _load_closure6.$getCallSiteArray();
                return (Collection)ScriptBytecodeAdapter.castToType(this.tags.get(), Collection.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _load_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "empty";
                stringArray[1] = "any";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _load_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_load_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _load_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _load_closure6 _load_closure62 = new _load_closure6(this, this, tags2);
        tagsFilter.set((_load_closure5)((Object)_load_closure62));
        class _load_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tagsFilter;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _load_closure7(Object _outerInstance, Object _thisObject, Reference tagsFilter) {
                Reference reference;
                CallSite[] callSiteArray = _load_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.tagsFilter = reference = tagsFilter;
            }

            public Object doCall(Object changeSet) {
                CallSite[] callSiteArray = _load_closure7.$getCallSiteArray();
                return callSiteArray[0].call(this.tagsFilter.get(), callSiteArray[1].callGetProperty(changeSet));
            }

            public Object getTagsFilter() {
                CallSite[] callSiteArray = _load_closure7.$getCallSiteArray();
                return this.tagsFilter.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _load_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "call";
                stringArray[1] = "tags";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _load_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_load_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _load_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType(callSiteArray[59].call((Object)changeSets, new _load_closure7(this, this, tagsFilter)), List.class);
    }

    private void ensureNoBootstrap(List changes) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        class _ensureNoBootstrap_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _ensureNoBootstrap_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _ensureNoBootstrap_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _ensureNoBootstrap_closure8.$getCallSiteArray();
                return it instanceof Closure;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _ensureNoBootstrap_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _ensureNoBootstrap_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_ensureNoBootstrap_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _ensureNoBootstrap_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual(callSiteArray[60].call((Object)changes, new _ensureNoBootstrap_closure8(this, this)), null)) {
            throw (Throwable)callSiteArray[61].callConstructor(BootstrapException.class, "The bootstrap function can only be used before any schemaChange function calls");
        }
    }

    private void validateChange(Object change, Object appliedChange) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual(callSiteArray[62].callGetProperty(appliedChange), callSiteArray[63].callGetProperty(change))) {
            throw (Throwable)callSiteArray[64].callConstructor(ChangeSetAlteredException.class, callSiteArray[65].call((Object)new GStringImpl(new Object[]{callSiteArray[66].callGetProperty(change), change}, new String[]{"The version [", "] for ", " does not match the version "}), new GStringImpl(new Object[]{callSiteArray[67].callGetProperty(appliedChange)}, new String[]{"[", "] in the change log"})));
        }
        if (ScriptBytecodeAdapter.compareNotEqual(callSiteArray[68].callGetProperty(appliedChange), callSiteArray[69].callGetProperty(change))) {
            throw (Throwable)callSiteArray[70].callConstructor(ChangeSetAlteredException.class, callSiteArray[71].call((Object)new GStringImpl(new Object[]{callSiteArray[72].callCurrent((GroovyObject)this, callSiteArray[73].callGetProperty(change)), change}, new String[]{"The hash [", "] for ", " does not match the hash "}), new GStringImpl(new Object[]{callSiteArray[74].callCurrent((GroovyObject)this, callSiteArray[75].callGetProperty(appliedChange))}, new String[]{"[", "] in the change log"})));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Binding createBinding(List schemaChanges, Map vars) {
        void var2_2;
        Reference<List> schemaChanges2 = new Reference<List>(schemaChanges);
        Reference<void> vars2 = new Reference<void>(var2_2);
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Map scriptVars = (Map)ScriptBytecodeAdapter.castToType(callSiteArray[76].callConstructor(HashMap.class, (Map)vars2.get()), Map.class);
        Reference<Binding> binding = new Reference<Binding>((Binding)ScriptBytecodeAdapter.castToType(callSiteArray[77].callConstructor(Binding.class, scriptVars), Binding.class));
        class _createBinding_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference schemaChanges;
            private /* synthetic */ Reference binding;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createBinding_closure9(Object _outerInstance, Object _thisObject, Reference schemaChanges, Reference binding) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createBinding_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.schemaChanges = reference2 = schemaChanges;
                this.binding = reference = binding;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createBinding_closure9.$getCallSiteArray();
                return callSiteArray[0].call(this.schemaChanges.get(), callSiteArray[1].callCurrent(this, it, this.binding.get()));
            }

            public List getSchemaChanges() {
                CallSite[] callSiteArray = _createBinding_closure9.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType(this.schemaChanges.get(), List.class);
            }

            public Binding getBinding() {
                CallSite[] callSiteArray = _createBinding_closure9.$getCallSiteArray();
                return (Binding)ScriptBytecodeAdapter.castToType(this.binding.get(), Binding.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createBinding_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createBinding_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "createKeyspace";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _createBinding_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createBinding_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createBinding_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _createBinding_closure9 _createBinding_closure92 = new _createBinding_closure9(this, this, schemaChanges2, binding);
        ScriptBytecodeAdapter.setProperty(_createBinding_closure92, null, scriptVars, "createKeyspace");
        class _createBinding_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference schemaChanges;
            private /* synthetic */ Reference binding;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createBinding_closure10(Object _outerInstance, Object _thisObject, Reference schemaChanges, Reference binding) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createBinding_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.schemaChanges = reference2 = schemaChanges;
                this.binding = reference = binding;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createBinding_closure10.$getCallSiteArray();
                return callSiteArray[0].call(this.schemaChanges.get(), callSiteArray[1].callCurrent(this, it, this.binding.get()));
            }

            public List getSchemaChanges() {
                CallSite[] callSiteArray = _createBinding_closure10.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType(this.schemaChanges.get(), List.class);
            }

            public Binding getBinding() {
                CallSite[] callSiteArray = _createBinding_closure10.$getCallSiteArray();
                return (Binding)ScriptBytecodeAdapter.castToType(this.binding.get(), Binding.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createBinding_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createBinding_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "bootstrap";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _createBinding_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createBinding_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createBinding_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _createBinding_closure10 _createBinding_closure102 = new _createBinding_closure10(this, this, schemaChanges2, binding);
        ScriptBytecodeAdapter.setProperty(_createBinding_closure102, null, scriptVars, "bootstrap");
        class _createBinding_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference schemaChanges;
            private /* synthetic */ Reference binding;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createBinding_closure11(Object _outerInstance, Object _thisObject, Reference schemaChanges, Reference binding) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createBinding_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.schemaChanges = reference2 = schemaChanges;
                this.binding = reference = binding;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createBinding_closure11.$getCallSiteArray();
                return callSiteArray[0].call(this.schemaChanges.get(), callSiteArray[1].callCurrent(this, it, this.binding.get()));
            }

            public List getSchemaChanges() {
                CallSite[] callSiteArray = _createBinding_closure11.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType(this.schemaChanges.get(), List.class);
            }

            public Binding getBinding() {
                CallSite[] callSiteArray = _createBinding_closure11.$getCallSiteArray();
                return (Binding)ScriptBytecodeAdapter.castToType(this.binding.get(), Binding.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createBinding_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createBinding_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "createCqlChangeSet";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _createBinding_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createBinding_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createBinding_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _createBinding_closure11 _createBinding_closure112 = new _createBinding_closure11(this, this, schemaChanges2, binding);
        ScriptBytecodeAdapter.setProperty(_createBinding_closure112, null, scriptVars, "schemaChange");
        class _createBinding_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference schemaChanges;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createBinding_closure12(Object _outerInstance, Object _thisObject, Reference schemaChanges) {
                Reference reference;
                CallSite[] callSiteArray = _createBinding_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.schemaChanges = reference = schemaChanges;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createBinding_closure12.$getCallSiteArray();
                return callSiteArray[0].call(this.schemaChanges.get(), callSiteArray[1].callConstructor(SetKeyspace.class, ScriptBytecodeAdapter.createMap(new Object[]{"name", callSiteArray[2].callGroovyObjectGetProperty(this)})));
            }

            public List getSchemaChanges() {
                CallSite[] callSiteArray = _createBinding_closure12.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType(this.schemaChanges.get(), List.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createBinding_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createBinding_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "keyspace";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _createBinding_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createBinding_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createBinding_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _createBinding_closure12 _createBinding_closure122 = new _createBinding_closure12(this, this, schemaChanges2);
        ScriptBytecodeAdapter.setProperty(_createBinding_closure122, null, scriptVars, "setKeyspace");
        class _createBinding_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference schemaChanges;
            private /* synthetic */ Reference vars;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createBinding_closure13(Object _outerInstance, Object _thisObject, Reference schemaChanges, Reference vars) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createBinding_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.schemaChanges = reference2 = schemaChanges;
                this.vars = reference = vars;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createBinding_closure13.$getCallSiteArray();
                return callSiteArray[0].call(this.schemaChanges.get(), callSiteArray[1].callCurrent(this, it, this.vars.get()));
            }

            public List getSchemaChanges() {
                CallSite[] callSiteArray = _createBinding_closure13.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType(this.schemaChanges.get(), List.class);
            }

            public Map getVars() {
                CallSite[] callSiteArray = _createBinding_closure13.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType(this.vars.get(), Map.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createBinding_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createBinding_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "addAll";
                stringArray[1] = "include";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _createBinding_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createBinding_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createBinding_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _createBinding_closure13 _createBinding_closure132 = new _createBinding_closure13(this, this, schemaChanges2, vars2);
        ScriptBytecodeAdapter.setProperty(_createBinding_closure132, null, scriptVars, "include");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[78].call((Object)scriptVars, callSiteArray[79].callCurrent(this));
        } else {
            callSiteArray[80].call((Object)scriptVars, this.createScriptHelperFunctions());
        }
        return (Binding)ScriptBytecodeAdapter.castToType(callSiteArray[81].callConstructor(Binding.class, scriptVars), Binding.class);
    }

    public Object createKeyspace(Closure closure, Binding binding) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object object = callSiteArray[82].callConstructor(CreateKeyspace.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, CassalogImpl.class, closure, "delegate");
        Object code = callSiteArray[83].call(closure, callSiteArray[84].callGroovyObjectGetProperty(closure), binding, this);
        Object object2 = callSiteArray[85].callGetProperty(Closure.class);
        ScriptBytecodeAdapter.setProperty(object2, null, code, "resolveStrategy");
        callSiteArray[86].call(code);
        return callSiteArray[87].callGetProperty(code);
    }

    public Object bootstrap(Closure closure, Binding binding) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object object = callSiteArray[88].callConstructor(Bootstrap.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, CassalogImpl.class, closure, "delegate");
        Object object2 = callSiteArray[89].callGetProperty(Closure.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty(object2, CassalogImpl.class, closure, "resolveStrategy");
        return closure;
    }

    public Object createCqlChangeSet(Closure closure, Binding binding) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object object = callSiteArray[90].callConstructor(CqlChangeSet.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, CassalogImpl.class, closure, "delegate");
        Closure code = closure;
        Object object2 = callSiteArray[91].callGetProperty(Closure.class);
        ScriptBytecodeAdapter.setProperty(object2, null, code, "resolveStrategy");
        callSiteArray[92].call(code);
        return callSiteArray[93].callGetProperty(code);
    }

    public Object include(String script, Map vars) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Reference<Map> vars2 = new Reference<Map>(vars);
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Reference<List> dbchanges = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[0]));
        Object scriptVars = callSiteArray[94].callConstructor(HashMap.class, vars2.get());
        Reference<Object> binding = new Reference<Object>(callSiteArray[95].callConstructor(Binding.class, scriptVars));
        class _include_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference binding;
            private /* synthetic */ Reference dbchanges;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _include_closure14(Object _outerInstance, Object _thisObject, Reference binding, Reference dbchanges) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _include_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.binding = reference2 = binding;
                this.dbchanges = reference = dbchanges;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _include_closure14.$getCallSiteArray();
                return callSiteArray[0].call(this.dbchanges.get(), callSiteArray[1].callCurrent(this, it, this.binding.get()));
            }

            public Object getBinding() {
                CallSite[] callSiteArray = _include_closure14.$getCallSiteArray();
                return this.binding.get();
            }

            public Object getDbchanges() {
                CallSite[] callSiteArray = _include_closure14.$getCallSiteArray();
                return this.dbchanges.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _include_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _include_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "createKeyspace";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _include_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_include_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _include_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _include_closure14 _include_closure142 = new _include_closure14(this, this, binding, dbchanges);
        ScriptBytecodeAdapter.setProperty(_include_closure142, null, scriptVars, "createKeyspace");
        class _include_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dbchanges;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _include_closure15(Object _outerInstance, Object _thisObject, Reference dbchanges) {
                Reference reference;
                CallSite[] callSiteArray = _include_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.dbchanges = reference = dbchanges;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _include_closure15.$getCallSiteArray();
                return callSiteArray[0].call(this.dbchanges.get(), it);
            }

            public Object getDbchanges() {
                CallSite[] callSiteArray = _include_closure15.$getCallSiteArray();
                return this.dbchanges.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _include_closure15.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _include_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "leftShift";
                return new CallSiteArray(_include_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _include_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _include_closure15 _include_closure152 = new _include_closure15(this, this, dbchanges);
        ScriptBytecodeAdapter.setProperty(_include_closure152, null, scriptVars, "bootstrap");
        class _include_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference binding;
            private /* synthetic */ Reference dbchanges;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _include_closure16(Object _outerInstance, Object _thisObject, Reference binding, Reference dbchanges) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _include_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.binding = reference2 = binding;
                this.dbchanges = reference = dbchanges;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _include_closure16.$getCallSiteArray();
                return callSiteArray[0].call(this.dbchanges.get(), callSiteArray[1].callCurrent(this, it, this.binding.get()));
            }

            public Object getBinding() {
                CallSite[] callSiteArray = _include_closure16.$getCallSiteArray();
                return this.binding.get();
            }

            public Object getDbchanges() {
                CallSite[] callSiteArray = _include_closure16.$getCallSiteArray();
                return this.dbchanges.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _include_closure16.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _include_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "createCqlChangeSet";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _include_closure16.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_include_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _include_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _include_closure16 _include_closure162 = new _include_closure16(this, this, binding, dbchanges);
        ScriptBytecodeAdapter.setProperty(_include_closure162, null, scriptVars, "schemaChange");
        class _include_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dbchanges;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _include_closure17(Object _outerInstance, Object _thisObject, Reference dbchanges) {
                Reference reference;
                CallSite[] callSiteArray = _include_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.dbchanges = reference = dbchanges;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _include_closure17.$getCallSiteArray();
                return callSiteArray[0].call(this.dbchanges.get(), callSiteArray[1].callConstructor(SetKeyspace.class, ScriptBytecodeAdapter.createMap(new Object[]{"name", callSiteArray[2].callGroovyObjectGetProperty(this)})));
            }

            public Object getDbchanges() {
                CallSite[] callSiteArray = _include_closure17.$getCallSiteArray();
                return this.dbchanges.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _include_closure17.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _include_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "keyspace";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _include_closure17.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_include_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _include_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _include_closure17 _include_closure172 = new _include_closure17(this, this, dbchanges);
        ScriptBytecodeAdapter.setProperty(_include_closure172, null, scriptVars, "setKeyspace");
        class _include_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference vars;
            private /* synthetic */ Reference dbchanges;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _include_closure18(Object _outerInstance, Object _thisObject, Reference vars, Reference dbchanges) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _include_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.vars = reference2 = vars;
                this.dbchanges = reference = dbchanges;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _include_closure18.$getCallSiteArray();
                return callSiteArray[0].call(this.dbchanges.get(), callSiteArray[1].callCurrent(this, it, this.vars.get()));
            }

            public Map getVars() {
                CallSite[] callSiteArray = _include_closure18.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType(this.vars.get(), Map.class);
            }

            public Object getDbchanges() {
                CallSite[] callSiteArray = _include_closure18.$getCallSiteArray();
                return this.dbchanges.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _include_closure18.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _include_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "addAll";
                stringArray[1] = "include";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _include_closure18.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_include_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _include_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _include_closure18 _include_closure182 = new _include_closure18(this, this, vars2, dbchanges);
        ScriptBytecodeAdapter.setProperty(_include_closure182, null, scriptVars, "include");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[96].call(scriptVars, callSiteArray[97].callCurrent(this));
        } else {
            callSiteArray[98].call(scriptVars, this.createScriptHelperFunctions());
        }
        Object shell = callSiteArray[99].callConstructor(GroovyShell.class, binding.get());
        Object scriptURI = null;
        scriptURI = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (ScriptBytecodeAdapter.compareNotEqual(this.baseScriptsPath, null) && ScriptBytecodeAdapter.compareNotEqual(this.baseScriptsPath, "") ? (object4 = callSiteArray[100].call(callSiteArray[101].callConstructor(File.class, callSiteArray[102].call((Object)this.baseScriptsPath, script)))) : (object3 = callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].callCurrent(this), script)))) : (ScriptBytecodeAdapter.compareNotEqual(this.baseScriptsPath, null) && ScriptBytecodeAdapter.compareNotEqual(this.baseScriptsPath, "") ? (object2 = callSiteArray[106].call(callSiteArray[107].callConstructor(File.class, callSiteArray[108].call((Object)this.baseScriptsPath, script)))) : (object = callSiteArray[109].call(callSiteArray[110].call(callSiteArray[111].callCurrent(this), script))));
        callSiteArray[112].call(shell, scriptURI);
        return dbchanges.get();
    }

    public Map createScriptHelperFunctions() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object verificationFunctions = callSiteArray[113].callConstructor(VerificationFunctions.class, ScriptBytecodeAdapter.createMap(new Object[]{"session", this.session}));
        class _createScriptHelperFunctions_closure19
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createScriptHelperFunctions_closure19(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure19.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure19.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createScriptHelperFunctions_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "keyspaceExists";
                return new CallSiteArray(_createScriptHelperFunctions_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createScriptHelperFunctions_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        class _createScriptHelperFunctions_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createScriptHelperFunctions_closure20(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure20.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure20.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createScriptHelperFunctions_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "isSchemaVersioned";
                return new CallSiteArray(_createScriptHelperFunctions_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createScriptHelperFunctions_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        class _createScriptHelperFunctions_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createScriptHelperFunctions_closure21(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Object object;
                Object object2;
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure21.$getCallSiteArray();
                Object resultSet = null;
                Reference<List> tables = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[0]));
                resultSet = ScriptBytecodeAdapter.compareEqual(callSiteArray[0].callGroovyObjectGetProperty(this), 2) ? (object2 = callSiteArray[1].callCurrent((GroovyObject)this, callSiteArray[2].call((Object)"SELECT columnfamily_name FROM system.schema_columnfamilies WHERE ", new GStringImpl(new Object[]{it}, new String[]{"keyspace_name = '", "'"})))) : (object = callSiteArray[3].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{it}, new String[]{"SELECT table_name FROM system_schema.tables WHERE keyspace_name = '", "'"})));
                class _closure30
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tables;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure30(Object _outerInstance, Object _thisObject, Reference tables) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.tables = reference = tables;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return callSiteArray[0].call(this.tables.get(), callSiteArray[1].call(it, 0));
                    }

                    public Object getTables() {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return this.tables.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "leftShift";
                        stringArray[1] = "getString";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure30.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure30.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure30.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[4].call(callSiteArray[5].call(resultSet), new _closure30(this, this.getThisObject(), tables));
                return tables.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure21.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createScriptHelperFunctions_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "cassandraMajorVersion";
                stringArray[1] = "executeCQL";
                stringArray[2] = "plus";
                stringArray[3] = "executeCQL";
                stringArray[4] = "each";
                stringArray[5] = "all";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _createScriptHelperFunctions_closure21.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createScriptHelperFunctions_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createScriptHelperFunctions_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        class _createScriptHelperFunctions_closure22
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createScriptHelperFunctions_closure22(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Object object;
                Object object2;
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure22.$getCallSiteArray();
                Object resultSet = null;
                Reference<List> types = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[0]));
                resultSet = ScriptBytecodeAdapter.compareEqual(callSiteArray[0].callGroovyObjectGetProperty(this), 2) ? (object2 = callSiteArray[1].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{it}, new String[]{"SELECT type_name FROM system.schema_usertypes WHERE keyspace_name = '", "'"}))) : (object = callSiteArray[2].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{it}, new String[]{"SELECT type_name FROM system_schema.types WHERE keyspace_name = '", "'"})));
                class _closure31
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference types;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure31(Object _outerInstance, Object _thisObject, Reference types) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.types = reference = types;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                        return callSiteArray[0].call(this.types.get(), callSiteArray[1].call(it, 0));
                    }

                    public Object getTypes() {
                        CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                        return this.types.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure31.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "leftShift";
                        stringArray[1] = "getString";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure31.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure31.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure31.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[3].call(callSiteArray[4].call(resultSet), new _closure31(this, this.getThisObject(), types));
                return types.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createScriptHelperFunctions_closure22.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createScriptHelperFunctions_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "cassandraMajorVersion";
                stringArray[1] = "executeCQL";
                stringArray[2] = "executeCQL";
                stringArray[3] = "each";
                stringArray[4] = "all";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _createScriptHelperFunctions_closure22.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createScriptHelperFunctions_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createScriptHelperFunctions_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return ScriptBytecodeAdapter.createMap(new Object[]{"keyspaceExists", new _createScriptHelperFunctions_closure19(this, this), "isSchemaVersioned", new _createScriptHelperFunctions_closure20(this, this), "getTables", new _createScriptHelperFunctions_closure21(this, this), "getUDTs", new _createScriptHelperFunctions_closure22(this, this), "tableExists", ScriptBytecodeAdapter.getMethodPointer(verificationFunctions, "tableExists"), "tableDoesNotExist", ScriptBytecodeAdapter.getMethodPointer(verificationFunctions, "tableDoesNotExist"), "columnExists", ScriptBytecodeAdapter.getMethodPointer(verificationFunctions, "columnExists"), "columnDoesNotExist", ScriptBytecodeAdapter.getMethodPointer(verificationFunctions, "columnDoesNotExist"), "typeExists", ScriptBytecodeAdapter.getMethodPointer(verificationFunctions, "typeExists"), "typeDoesNotExist", ScriptBytecodeAdapter.getMethodPointer(verificationFunctions, "typeDoesNotExist")});
    }

    public boolean keyspaceExists() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox(callSiteArray[114].callCurrent((GroovyObject)this, this.keyspace));
        }
        return this.keyspaceExists(this.keyspace);
    }

    public boolean keyspaceExists(String keyspace) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object resultSet = null;
        resultSet = ScriptBytecodeAdapter.compareEqual(callSiteArray[115].callGroovyObjectGetProperty(this), 2) ? (object2 = callSiteArray[116].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{keyspace}, new String[]{"SELECT keyspace_name FROM system.schema_keyspaces WHERE keyspace_name = '", "'"}))) : (object = callSiteArray[117].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{keyspace}, new String[]{"SELECT keyspace_name FROM system_schema.keyspaces WHERE keyspace_name = '", "'"})));
        return !DefaultTypeTransformation.booleanUnbox(callSiteArray[118].callGetProperty(resultSet));
    }

    public Object initPreparedStatements() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual(this.insertSchemaChange, null)) {
            return null;
        }
        Object object = callSiteArray[119].call((Object)this.session, new GStringImpl(new Object[]{this.keyspace, CHANGELOG_TABLE}, new String[]{"\n      INSERT INTO ", ".", " (bucket, revision, version, hash, author, description, tags)\n      VALUES (?, ?, ?, ?, ?, ?, ?)\n      "}));
        this.insertSchemaChange = (PreparedStatement)ScriptBytecodeAdapter.castToType(object, PreparedStatement.class);
        Object object2 = callSiteArray[120].call((Object)this.session, new GStringImpl(new Object[]{this.keyspace, CHANGELOG_TABLE}, new String[]{"UPDATE ", ".", " SET applied_at = ? WHERE bucket = ? AND revision = ?"}));
        this.updateAppliedAt = (PreparedStatement)ScriptBytecodeAdapter.castToType(object2, PreparedStatement.class);
        return object2;
    }

    public Object createChangeLogTableIfNecessary() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[121].callCurrent(this))) {
                Object object = DefaultTypeTransformation.booleanUnbox(callSiteArray[122].call(log)) ? callSiteArray[123].call((Object)log, new GStringImpl(new Object[]{this.keyspace, CHANGELOG_TABLE}, new String[]{"Creating change log table ", ".", ""})) : null;
                return callSiteArray[124].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{this.keyspace, CHANGELOG_TABLE}, new String[]{"\nCREATE TABLE ", ".", "(\n  bucket int,\n  revision int,\n  version text,\n  applied_at timestamp,\n  hash blob,\n  author text,\n  description text,\n  tags set<text>,\n  PRIMARY KEY (bucket, revision)\n)\n"}));
            }
            return null;
        }
        if (!this.isSchemaVersioned()) {
            Object object = DefaultTypeTransformation.booleanUnbox(callSiteArray[125].call(log)) ? callSiteArray[126].call((Object)log, new GStringImpl(new Object[]{this.keyspace, CHANGELOG_TABLE}, new String[]{"Creating change log table ", ".", ""})) : null;
            return callSiteArray[127].callCurrent((GroovyObject)this, new GStringImpl(new Object[]{this.keyspace, CHANGELOG_TABLE}, new String[]{"\nCREATE TABLE ", ".", "(\n  bucket int,\n  revision int,\n  version text,\n  applied_at timestamp,\n  hash blob,\n  author text,\n  description text,\n  tags set<text>,\n  PRIMARY KEY (bucket, revision)\n)\n"}));
        }
        return null;
    }

    public boolean isSchemaVersioned() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox(callSiteArray[128].callCurrent((GroovyObject)this, this.keyspace));
        }
        return this.isSchemaVersioned(this.keyspace);
    }

    public boolean isSchemaVersioned(String keyspace) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object resultSet = null;
        resultSet = ScriptBytecodeAdapter.compareEqual(callSiteArray[129].callGroovyObjectGetProperty(this), 2) ? (object2 = callSiteArray[130].callCurrent((GroovyObject)this, callSiteArray[131].call((Object)"SELECT * FROM system.schema_columnfamilies ", new GStringImpl(new Object[]{keyspace, CHANGELOG_TABLE}, new String[]{"WHERE keyspace_name = '", "' AND columnfamily_name = '", "'"})))) : (object = callSiteArray[132].callCurrent((GroovyObject)this, callSiteArray[133].call((Object)"SELECT * FROM system_schema.tables ", new GStringImpl(new Object[]{keyspace, CHANGELOG_TABLE}, new String[]{"WHERE keyspace_name = '", "' AND table_name = '", "'"}))));
        return !DefaultTypeTransformation.booleanUnbox(callSiteArray[134].callGetProperty(resultSet));
    }

    public Object applyChangeSet(ChangeSet changeSet, int index, boolean updateChangeLog, ChangeSetListener listener) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox(callSiteArray[135].call(log)) ? callSiteArray[136].call((Object)log, new GStringImpl(new Object[]{callSiteArray[137].callGetProperty(changeSet), callSiteArray[138].call(callSiteArray[139].callGetProperty(changeSet), "\n")}, new String[]{"Applying ChangeSet\n-- version: ", "\n", "\n--"})) : null;
        if (updateChangeLog) {
            callSiteArray[140].callCurrent(this, changeSet, index);
        }
        class _applyChangeSet_closure23
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _applyChangeSet_closure23(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _applyChangeSet_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _applyChangeSet_closure23.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _applyChangeSet_closure23.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _applyChangeSet_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "executeCQL";
                return new CallSiteArray(_applyChangeSet_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _applyChangeSet_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[141].call(callSiteArray[142].callGetProperty(changeSet), new _applyChangeSet_closure23(this, this));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (updateChangeLog) {
                callSiteArray[143].callCurrent((GroovyObject)this, index);
            }
        } else if (updateChangeLog) {
            this.updateAppliedAt(index);
        }
        return callSiteArray[144].call((Object)listener, changeSet);
    }

    public Object insertChangeSet(ChangeSet changeSet, int index) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        int bucket = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[145].call((Object)index, this.bucketSize);
            bucket = DefaultTypeTransformation.intUnbox(object);
        } else {
            int n;
            bucket = n = index / this.bucketSize;
        }
        return callSiteArray[146].callCurrent((GroovyObject)this, callSiteArray[147].call((Object)this.insertSchemaChange, ArrayUtil.createArray(bucket, index, callSiteArray[148].callGetProperty(changeSet), callSiteArray[149].callGetProperty(changeSet), callSiteArray[150].callGetProperty(changeSet), callSiteArray[151].callGetProperty(changeSet), callSiteArray[152].callGetProperty(changeSet))));
    }

    public Object updateAppliedAt(int index) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        return callSiteArray[153].callCurrent(this, index, callSiteArray[154].callConstructor(Date.class));
    }

    public Object updateAppliedAt(int index, Date timestamp) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        int bucket = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[155].call((Object)index, this.bucketSize);
            bucket = DefaultTypeTransformation.intUnbox(object);
        } else {
            int n;
            bucket = n = index / this.bucketSize;
        }
        return callSiteArray[156].callCurrent((GroovyObject)this, callSiteArray[157].call(this.updateAppliedAt, timestamp, bucket, index));
    }

    public Object toHex(ByteBuffer buffer) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        return callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].call(buffer)));
    }

    public Object executeCQL(String cql) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object statement = callSiteArray[161].callConstructor(SimpleStatement.class, cql);
        ConsistencyLevel consistencyLevel = this.consistencyLevel;
        ScriptBytecodeAdapter.setProperty((Object)consistencyLevel, null, statement, "consistencyLevel");
        return callSiteArray[162].call((Object)this.session, statement);
    }

    public Object executeCQL(BoundStatement statement) {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        ConsistencyLevel consistencyLevel = this.consistencyLevel;
        ScriptBytecodeAdapter.setProperty((Object)consistencyLevel, null, statement, "consistencyLevel");
        Object object = callSiteArray[163].call((Object)this.session, statement);
        try {
            return object;
        }
        catch (Exception e) {
            callSiteArray[164].call(log, "CQL error", e);
            Object var6_6 = null;
            return var6_6;
        }
    }

    public Object determineConsistencyLevel() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Object resultSet = callSiteArray[165].call((Object)this.session, "SELECT peer FROM system.peers");
        int clusterSize = DefaultTypeTransformation.intUnbox(callSiteArray[166].call(callSiteArray[167].call(resultSet)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (clusterSize == 0) {
                Object object = callSiteArray[168].callGetProperty(ConsistencyLevel.class);
                this.consistencyLevel = (ConsistencyLevel)ShortTypeHandling.castToEnum(object, ConsistencyLevel.class);
                return object;
            }
            Object object = callSiteArray[169].callGetProperty(ConsistencyLevel.class);
            this.consistencyLevel = (ConsistencyLevel)ShortTypeHandling.castToEnum(object, ConsistencyLevel.class);
            return object;
        }
        if (clusterSize == 0) {
            Object object = callSiteArray[170].callGetProperty(ConsistencyLevel.class);
            this.consistencyLevel = (ConsistencyLevel)ShortTypeHandling.castToEnum(object, ConsistencyLevel.class);
            return object;
        }
        Object object = callSiteArray[171].callGetProperty(ConsistencyLevel.class);
        this.consistencyLevel = (ConsistencyLevel)ShortTypeHandling.castToEnum(object, ConsistencyLevel.class);
        return object;
    }

    public Object verifyCassandraVersion() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        Reference<Object> majorVersion = new Reference<Object>(null);
        class _verifyCassandraVersion_closure24
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference majorVersion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _verifyCassandraVersion_closure24(Object _outerInstance, Object _thisObject, Reference majorVersion) {
                Reference reference;
                CallSite[] callSiteArray = _verifyCassandraVersion_closure24.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.majorVersion = reference = majorVersion;
            }

            public Object doCall(Object host) {
                CallSite[] callSiteArray = _verifyCassandraVersion_closure24.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual(this.majorVersion.get(), null)) {
                        Object object = callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(host));
                        this.majorVersion.set(object);
                        return object;
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual(callSiteArray[2].callGetProperty(host), null) && ScriptBytecodeAdapter.compareNotEqual(callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(host)), this.majorVersion.get())) {
                        throw (Throwable)callSiteArray[5].callConstructor(CassandraVersionException.class, "All Cassandra nodes should be running the same major version.");
                    }
                    return null;
                }
                if (ScriptBytecodeAdapter.compareEqual(this.majorVersion.get(), null)) {
                    Object object = callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty(host));
                    this.majorVersion.set(object);
                    return object;
                }
                if (ScriptBytecodeAdapter.compareNotEqual(callSiteArray[8].callGetProperty(host), null) && ScriptBytecodeAdapter.compareNotEqual(callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(host)), this.majorVersion.get())) {
                    throw (Throwable)callSiteArray[11].callConstructor(CassandraVersionException.class, "All Cassandra nodes should be running the same major version.");
                }
                return null;
            }

            public Object getMajorVersion() {
                CallSite[] callSiteArray = _verifyCassandraVersion_closure24.$getCallSiteArray();
                return this.majorVersion.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _verifyCassandraVersion_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "major";
                stringArray[1] = "cassandraVersion";
                stringArray[2] = "cassandraVersion";
                stringArray[3] = "major";
                stringArray[4] = "cassandraVersion";
                stringArray[5] = "<$constructor$>";
                stringArray[6] = "major";
                stringArray[7] = "cassandraVersion";
                stringArray[8] = "cassandraVersion";
                stringArray[9] = "major";
                stringArray[10] = "cassandraVersion";
                stringArray[11] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[12];
                _verifyCassandraVersion_closure24.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_verifyCassandraVersion_closure24.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _verifyCassandraVersion_closure24.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[172].call(callSiteArray[173].callGetProperty(callSiteArray[174].callGetProperty(callSiteArray[175].callGetProperty(this.session))), new _verifyCassandraVersion_closure24(this, this, majorVersion));
        if (ScriptBytecodeAdapter.compareEqual(majorVersion.get(), 1)) {
            throw (Throwable)callSiteArray[176].callConstructor(CassandraVersionException.class, "Cassandra 1.x is not supported.");
        }
        return null;
    }

    public int getCassandraMajorVersion() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        class _getCassandraMajorVersion_closure25
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getCassandraMajorVersion_closure25(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getCassandraMajorVersion_closure25.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object host) {
                CallSite[] callSiteArray = _getCassandraMajorVersion_closure25.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareNotEqual(callSiteArray[0].callGetProperty(host), null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _getCassandraMajorVersion_closure25.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "cassandraVersion";
                return new CallSiteArray(_getCassandraMajorVersion_closure25.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getCassandraMajorVersion_closure25.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.intUnbox(callSiteArray[177].callGetProperty(callSiteArray[178].callGetProperty(callSiteArray[179].call(callSiteArray[180].callGetProperty(callSiteArray[181].callGetProperty(callSiteArray[182].callGetProperty(this.session))), new _getCassandraMajorVersion_closure25(this, this)))));
    }

    public Object verifySchemaAgreement() {
        CallSite[] callSiteArray = CassalogImpl.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[183].call(callSiteArray[184].callGetProperty(callSiteArray[185].callGetProperty(this.session))))) {
            throw (Throwable)callSiteArray[186].callConstructor(SchemaAgreementException.class);
        }
        return null;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CassalogImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    static {
        class __clinit__closure26
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure26(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure26.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = __clinit__closure26.$getCallSiteArray();
                return null;
            }

            public Object doCall() {
                CallSite[] callSiteArray = __clinit__closure26.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != __clinit__closure26.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(__clinit__closure26.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure26.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure26 __clinit__closure262 = new __clinit__closure26(CassalogImpl.class, CassalogImpl.class);
        NO_OP_LISTENER = (ChangeSetListener)ScriptBytecodeAdapter.castToType(__clinit__closure262, ChangeSetListener.class);
        Object object = CassalogImpl.$getCallSiteArray()[187].call(LoggerFactory.class, "org.cassalog.core.CassalogImpl");
        log = (Logger)ScriptBytecodeAdapter.castToType(object, Logger.class);
    }

    public static final String getCHANGELOG_TABLE() {
        return CHANGELOG_TABLE;
    }

    public static final int getDEFAULT_BUCKET_SIZE() {
        return DEFAULT_BUCKET_SIZE;
    }

    public static final ChangeSetListener getNO_OP_LISTENER() {
        return NO_OP_LISTENER;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String string) {
        this.keyspace = string;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getBaseScriptsPath() {
        return this.baseScriptsPath;
    }

    public void setBaseScriptsPath(String string) {
        this.baseScriptsPath = string;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public void setBucketSize(int n) {
        this.bucketSize = n;
    }

    public PreparedStatement getInsertSchemaChange() {
        return this.insertSchemaChange;
    }

    public void setInsertSchemaChange(PreparedStatement preparedStatement) {
        this.insertSchemaChange = preparedStatement;
    }

    public PreparedStatement getUpdateAppliedAt() {
        return this.updateAppliedAt;
    }

    public void setUpdateAppliedAt(PreparedStatement preparedStatement) {
        this.updateAppliedAt = preparedStatement;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "execute";
        stringArray[1] = "emptySet";
        stringArray[2] = "execute";
        stringArray[3] = "emptySet";
        stringArray[4] = "execute";
        stringArray[5] = "execute";
        stringArray[6] = "verifyCassandraVersion";
        stringArray[7] = "verifySchemaAgreement";
        stringArray[8] = "determineConsistencyLevel";
        stringArray[9] = "isInfoEnabled";
        stringArray[10] = "info";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "createBinding";
        stringArray[13] = "evaluate";
        stringArray[14] = "getAt";
        stringArray[15] = "name";
        stringArray[16] = "getAt";
        stringArray[17] = "recreate";
        stringArray[18] = "getAt";
        stringArray[19] = "isDebugEnabled";
        stringArray[20] = "debug";
        stringArray[21] = "executeCQL";
        stringArray[22] = "keyspaceExists";
        stringArray[23] = "applyChangeSet";
        stringArray[24] = "getAt";
        stringArray[25] = "createChangeLogTableIfNecessary";
        stringArray[26] = "initPreparedStatements";
        stringArray[27] = "executeCQL";
        stringArray[28] = "bind";
        stringArray[29] = "version";
        stringArray[30] = "getAt";
        stringArray[31] = "hash";
        stringArray[32] = "getAt";
        stringArray[33] = "author";
        stringArray[34] = "getAt";
        stringArray[35] = "description";
        stringArray[36] = "getAt";
        stringArray[37] = "tags";
        stringArray[38] = "getAt";
        stringArray[39] = "executeCQL";
        stringArray[40] = "bind";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "getAt";
        stringArray[43] = "remove";
        stringArray[44] = "ensureNoBootstrap";
        stringArray[45] = "call";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "createChangeLogTableIfNecessary";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "load";
        stringArray[50] = "initPreparedStatements";
        stringArray[51] = "eachWithIndex";
        stringArray[52] = "findAll";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "createBinding";
        stringArray[55] = "evaluate";
        stringArray[56] = "getAt";
        stringArray[57] = "remove";
        stringArray[58] = "ensureNoBootstrap";
        stringArray[59] = "findAll";
        stringArray[60] = "find";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "version";
        stringArray[63] = "version";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "plus";
        stringArray[66] = "version";
        stringArray[67] = "version";
        stringArray[68] = "hash";
        stringArray[69] = "hash";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "plus";
        stringArray[72] = "toHex";
        stringArray[73] = "hash";
        stringArray[74] = "toHex";
        stringArray[75] = "hash";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "putAll";
        stringArray[79] = "createScriptHelperFunctions";
        stringArray[80] = "putAll";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "rehydrate";
        stringArray[84] = "delegate";
        stringArray[85] = "DELEGATE_FIRST";
        stringArray[86] = "call";
        stringArray[87] = "delegate";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "DELEGATE_FIRST";
        stringArray[90] = "<$constructor$>";
        stringArray[91] = "DELEGATE_FIRST";
        stringArray[92] = "call";
        stringArray[93] = "delegate";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "<$constructor$>";
        stringArray[96] = "putAll";
        stringArray[97] = "createScriptHelperFunctions";
        stringArray[98] = "putAll";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "toURI";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "plus";
        stringArray[103] = "toURI";
        stringArray[104] = "getResource";
        stringArray[105] = "getClass";
        stringArray[106] = "toURI";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "plus";
        stringArray[109] = "toURI";
        stringArray[110] = "getResource";
        stringArray[111] = "getClass";
        stringArray[112] = "evaluate";
        stringArray[113] = "<$constructor$>";
        stringArray[114] = "keyspaceExists";
        stringArray[115] = "cassandraMajorVersion";
        stringArray[116] = "executeCQL";
        stringArray[117] = "executeCQL";
        stringArray[118] = "exhausted";
        stringArray[119] = "prepare";
        stringArray[120] = "prepare";
        stringArray[121] = "isSchemaVersioned";
        stringArray[122] = "isInfoEnabled";
        stringArray[123] = "info";
        stringArray[124] = "executeCQL";
        stringArray[125] = "isInfoEnabled";
        stringArray[126] = "info";
        stringArray[127] = "executeCQL";
        stringArray[128] = "isSchemaVersioned";
        stringArray[129] = "cassandraMajorVersion";
        stringArray[130] = "executeCQL";
        stringArray[131] = "plus";
        stringArray[132] = "executeCQL";
        stringArray[133] = "plus";
        stringArray[134] = "exhausted";
        stringArray[135] = "isInfoEnabled";
        stringArray[136] = "info";
        stringArray[137] = "version";
        stringArray[138] = "join";
        stringArray[139] = "cql";
        stringArray[140] = "insertChangeSet";
        stringArray[141] = "each";
        stringArray[142] = "cql";
        stringArray[143] = "updateAppliedAt";
        stringArray[144] = "changeSetApplied";
        stringArray[145] = "div";
        stringArray[146] = "executeCQL";
        stringArray[147] = "bind";
        stringArray[148] = "version";
        stringArray[149] = "hash";
        stringArray[150] = "author";
        stringArray[151] = "description";
        stringArray[152] = "tags";
        stringArray[153] = "updateAppliedAt";
        stringArray[154] = "<$constructor$>";
        stringArray[155] = "div";
        stringArray[156] = "executeCQL";
        stringArray[157] = "bind";
        stringArray[158] = "toString";
        stringArray[159] = "encodeHex";
        stringArray[160] = "array";
        stringArray[161] = "<$constructor$>";
        stringArray[162] = "execute";
        stringArray[163] = "execute";
        stringArray[164] = "error";
        stringArray[165] = "execute";
        stringArray[166] = "size";
        stringArray[167] = "all";
        stringArray[168] = "LOCAL_ONE";
        stringArray[169] = "LOCAL_QUORUM";
        stringArray[170] = "LOCAL_ONE";
        stringArray[171] = "LOCAL_QUORUM";
        stringArray[172] = "each";
        stringArray[173] = "allHosts";
        stringArray[174] = "metadata";
        stringArray[175] = "cluster";
        stringArray[176] = "<$constructor$>";
        stringArray[177] = "major";
        stringArray[178] = "cassandraVersion";
        stringArray[179] = "find";
        stringArray[180] = "allHosts";
        stringArray[181] = "metadata";
        stringArray[182] = "cluster";
        stringArray[183] = "checkSchemaAgreement";
        stringArray[184] = "metadata";
        stringArray[185] = "cluster";
        stringArray[186] = "<$constructor$>";
        stringArray[187] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[188];
        CassalogImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CassalogImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CassalogImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

