/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorSession;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorUtils;
import org.openjdk.jmh.generators.core.BenchmarkInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.CompilerControlPlugin;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.GenerationException;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.MethodGroup;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.Paddings;
import org.openjdk.jmh.generators.core.ParameterInfo;
import org.openjdk.jmh.generators.core.StateObjectHandler;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.results.AverageTimeResult;
import org.openjdk.jmh.results.BenchmarkTaskResult;
import org.openjdk.jmh.results.RawResults;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.results.SampleTimeResult;
import org.openjdk.jmh.results.SingleShotResult;
import org.openjdk.jmh.results.ThroughputResult;
import org.openjdk.jmh.runner.BenchmarkListEntry;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.InfraControl;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.SampleBuffer;

public class BenchmarkGenerator {
    private static final String JMH_STUB_SUFFIX = "_jmhStub";
    private final Set<BenchmarkInfo> benchmarkInfos = new HashSet<BenchmarkInfo>();
    private final CompilerControlPlugin compilerControl;
    private final Set<String> processedBenchmarks = new HashSet<String>();
    private final BenchmarkGeneratorSession session;
    static String[] INDENTS = new String[0];

    public BenchmarkGenerator() {
        this.compilerControl = new CompilerControlPlugin();
        this.session = new BenchmarkGeneratorSession();
    }

    public void generate(GeneratorSource source, GeneratorDestination destination) {
        try {
            Multimap<ClassInfo, MethodInfo> clazzes = this.buildAnnotatedSet(source);
            for (ClassInfo clazz : clazzes.keys()) {
                if (!this.processedBenchmarks.add(clazz.getQualifiedName())) continue;
                try {
                    this.validateBenchmark(clazz, clazzes.get(clazz));
                    Collection<BenchmarkInfo> infos = this.makeBenchmarkInfo(clazz, clazzes.get(clazz));
                    for (BenchmarkInfo info : infos) {
                        this.generateClass(source, destination, clazz, info);
                    }
                    this.benchmarkInfos.addAll(infos);
                }
                catch (GenerationException ge) {
                    destination.printError(ge.getMessage(), ge.getElement());
                }
            }
            for (Mode mode : Mode.values()) {
                this.compilerControl.alwaysDontInline("*", "*_" + mode.shortLabel() + JMH_STUB_SUFFIX);
            }
            this.compilerControl.process(source, destination);
        }
        catch (Throwable t) {
            destination.printError("Annotation generator had thrown the exception.", t);
        }
    }

    public void complete(GeneratorSource source, GeneratorDestination destination) {
        this.compilerControl.finish(source, destination);
        HashSet<BenchmarkListEntry> entries = new HashSet<BenchmarkListEntry>();
        HashMultimap<String, BenchmarkListEntry> entriesByQName = new HashMultimap<String, BenchmarkListEntry>();
        try {
            for (String line : this.readBenchmarkList(destination)) {
                BenchmarkListEntry br = new BenchmarkListEntry(line);
                entries.add(br);
                entriesByQName.put(br.getUserClassQName(), br);
            }
        }
        catch (UnsupportedOperationException e) {
            destination.printWarning("Unable to read the existing benchmark list, because of UnsupportedOperationException. Run on JDK 7 or higher.");
        }
        for (BenchmarkInfo info : this.benchmarkInfos) {
            try {
                MethodGroup group = info.methodGroup;
                for (Mode m : group.getModes()) {
                    BenchmarkListEntry br = new BenchmarkListEntry(info.userClassQName, info.generatedClassQName, group.getName(), m, group.getTotalThreadCount(), group.getGroupThreads(), group.getGroupLabels(), group.getWarmupIterations(), group.getWarmupTime(), group.getWarmupBatchSize(), group.getMeasurementIterations(), group.getMeasurementTime(), group.getMeasurementBatchSize(), group.getForks(), group.getWarmupForks(), group.getJvm(), group.getJvmArgs(), group.getJvmArgsPrepend(), group.getJvmArgsAppend(), group.getParams(), group.getOutputTimeUnit(), group.getOperationsPerInvocation(), group.getTimeout());
                    if (entriesByQName.keys().contains(info.userClassQName)) {
                        destination.printNote("Benchmark entries for " + info.userClassQName + " already exist, overwriting");
                        entries.removeAll(entriesByQName.get(info.userClassQName));
                        entriesByQName.remove(info.userClassQName);
                    }
                    entries.add(br);
                }
            }
            catch (GenerationException ge) {
                destination.printError(ge.getMessage(), ge.getElement());
            }
        }
        this.writeBenchmarkList(destination, entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> readBenchmarkList(GeneratorDestination destination) {
        Reader reader = null;
        try {
            reader = destination.getResource("/META-INF/BenchmarkList".substring(1));
            Collection<String> collection = FileUtils.readAllLines(reader);
            return collection;
        }
        catch (IOException iOException) {
        }
        finally {
            FileUtils.safelyClose(reader);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBenchmarkList(GeneratorDestination destination, Collection<BenchmarkListEntry> entries) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(destination.newResource("/META-INF/BenchmarkList".substring(1)));
            for (BenchmarkListEntry entry : entries) {
                writer.println(entry.toLine());
            }
        }
        catch (IOException ex) {
            destination.printError("Error writing benchmark list", ex);
        }
        finally {
            FileUtils.safelyClose(writer);
        }
    }

    private Multimap<ClassInfo, MethodInfo> buildAnnotatedSet(GeneratorSource source) {
        HashMultimap<ClassInfo, MethodInfo> result = new HashMultimap<ClassInfo, MethodInfo>();
        Iterator<ClassInfo> iterator = source.getClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo currentClass;
            ClassInfo walk = currentClass = iterator.next();
            do {
                if (currentClass.getQualifiedName().contains("generated") || currentClass.isAbstract()) continue;
                for (MethodInfo mi : walk.getMethods()) {
                    Benchmark ann = mi.getAnnotation(Benchmark.class);
                    if (ann == null) continue;
                    result.put(currentClass, mi);
                }
            } while ((walk = walk.getSuperClass()) != null);
        }
        return result;
    }

    private void validateBenchmark(ClassInfo clazz, Collection<MethodInfo> methods) {
        boolean explicitState;
        if (clazz.getPackageName().isEmpty()) {
            throw new GenerationException("Benchmark class should have package other than default.", clazz);
        }
        if (clazz.isFinal()) {
            throw new GenerationException("Benchmark classes should not be final.", clazz);
        }
        for (MethodInfo e : methods) {
            StateObjectHandler.validateStateArgs(e);
        }
        boolean bl = explicitState = BenchmarkGeneratorUtils.getAnnSuper(clazz, State.class) != null;
        if (explicitState) {
            StateObjectHandler.validateState(clazz);
        }
        for (MethodInfo e : methods) {
            StateObjectHandler.validateNoCycles(e);
        }
        if (!explicitState || clazz.isAbstract()) {
            for (FieldInfo fi : BenchmarkGeneratorUtils.getAllFields(clazz)) {
                if (fi.isStatic()) continue;
                throw new GenerationException("Field \"" + fi.getName() + "\" is declared within the class not having @" + State.class.getSimpleName() + " annotation. This can result in unspecified behavior, and prohibited.", fi);
            }
        }
        BenchmarkGeneratorUtils.checkAnnotations(clazz);
        for (FieldInfo fi : BenchmarkGeneratorUtils.getAllFields(clazz)) {
            BenchmarkGeneratorUtils.checkAnnotations(fi);
        }
        for (MethodInfo mi : methods) {
            BenchmarkGeneratorUtils.checkAnnotations(mi);
        }
        for (MethodInfo m : methods) {
            if (!m.isPublic()) {
                throw new GenerationException("@" + Benchmark.class.getSimpleName() + " method should be public.", m);
            }
            if (m.isAbstract()) {
                throw new GenerationException("@" + Benchmark.class.getSimpleName() + " method can not be abstract.", m);
            }
            if (!m.isSynchronized()) continue;
            State annState = BenchmarkGeneratorUtils.getAnnSuper(m, State.class);
            if (annState == null) {
                throw new GenerationException("@" + Benchmark.class.getSimpleName() + " method can only be synchronized if the enclosing class is annotated with @" + State.class.getSimpleName() + ".", m);
            }
            if (!m.isStatic() || annState.value() == Scope.Benchmark) continue;
            throw new GenerationException("@" + Benchmark.class.getSimpleName() + " method can only be static and synchronized if the enclosing class is annotated with @" + State.class.getSimpleName() + "(" + Scope.class.getSimpleName() + "." + (Object)((Object)Scope.Benchmark) + ").", m);
        }
        for (MethodInfo m : methods) {
            OperationsPerInvocation opi = BenchmarkGeneratorUtils.getAnnSuper(m, clazz, OperationsPerInvocation.class);
            if (opi == null || opi.value() >= 1) continue;
            throw new GenerationException("The " + OperationsPerInvocation.class.getSimpleName() + " needs to be greater than 0.", m);
        }
        for (MethodInfo m : methods) {
            if (m.getAnnotation(Group.class) == null || m.getAnnotation(Threads.class) == null) continue;
            throw new GenerationException("@" + Threads.class.getSimpleName() + " annotation is placed within the benchmark method with @" + Group.class.getSimpleName() + " annotation. This has ambiguous behavioral effect, and prohibited. Did you mean @" + GroupThreads.class.getSimpleName() + " instead?", m);
        }
    }

    private void validateBenchmarkInfo(BenchmarkInfo info) {
        MethodGroup group = info.methodGroup;
        if (group.methods().size() == 1) {
            MethodInfo meth = group.methods().iterator().next();
            if (meth.getAnnotation(Group.class) == null) {
                for (ParameterInfo param : meth.getParameters()) {
                    State stateAnn = BenchmarkGeneratorUtils.getAnnSuper(param.getType(), State.class);
                    if (stateAnn == null || stateAnn.value() != Scope.Group) continue;
                    throw new GenerationException("Only @" + Group.class.getSimpleName() + " methods can reference @" + State.class.getSimpleName() + "(" + Scope.class.getSimpleName() + "." + (Object)((Object)Scope.Group) + ") states.", meth);
                }
                State stateAnn = BenchmarkGeneratorUtils.getAnnSuper(meth.getDeclaringClass(), State.class);
                if (stateAnn != null && stateAnn.value() == Scope.Group) {
                    throw new GenerationException("Only @" + Group.class.getSimpleName() + " methods can implicitly reference @" + State.class.getSimpleName() + "(" + Scope.class.getSimpleName() + "." + (Object)((Object)Scope.Group) + ") states.", meth);
                }
            }
        } else {
            for (MethodInfo m : group.methods()) {
                if (m.getAnnotation(Group.class) != null) continue;
                throw new GenerationException("Internal error: multiple methods per @" + Group.class.getSimpleName() + ", but not all methods have @" + Group.class.getSimpleName(), m);
            }
        }
    }

    private Collection<BenchmarkInfo> makeBenchmarkInfo(ClassInfo clazz, Collection<MethodInfo> methods) {
        TreeMap<String, MethodGroup> result = new TreeMap<String, MethodGroup>();
        for (MethodInfo method : methods) {
            BenchmarkMode mbAn;
            String groupName;
            Group groupAnn = method.getAnnotation(Group.class);
            String string = groupName = groupAnn != null ? groupAnn.value() : method.getName();
            if (!BenchmarkGeneratorUtils.checkJavaIdentifier(groupName)) {
                throw new GenerationException("Group name should be the legal Java identifier.", method);
            }
            MethodGroup group = (MethodGroup)result.get(groupName);
            if (group == null) {
                group = new MethodGroup(clazz, groupName);
                result.put(groupName, group);
            }
            if ((mbAn = BenchmarkGeneratorUtils.getAnnSuper(method, clazz, BenchmarkMode.class)) != null) {
                group.addModes(mbAn.value());
            }
            group.addStrictFP(clazz.isStrictFP());
            group.addStrictFP(method.isStrictFP());
            group.addMethod(method, method.getAnnotation(GroupThreads.class) != null ? method.getAnnotation(GroupThreads.class).value() : 1);
            for (ParameterInfo pi : method.getParameters()) {
                BenchmarkGeneratorUtils.addParameterValuesToGroup(pi.getType(), group);
            }
            BenchmarkGeneratorUtils.addParameterValuesToGroup(clazz, group);
        }
        for (MethodGroup group : result.values()) {
            if (!group.getModes().isEmpty()) continue;
            group.addModes(Defaults.BENCHMARK_MODE);
        }
        ArrayList<BenchmarkInfo> benchmarks = new ArrayList<BenchmarkInfo>();
        for (MethodGroup group : result.values()) {
            String sourcePackage = clazz.getPackageName();
            String generatedPackageName = sourcePackage + ".generated";
            String generatedClassName = BenchmarkGeneratorUtils.getGeneratedName(clazz) + "_" + group.getName() + "_jmhTest";
            BenchmarkInfo info = new BenchmarkInfo(clazz.getQualifiedName(), generatedPackageName, generatedClassName, group);
            this.validateBenchmarkInfo(info);
            benchmarks.add(info);
        }
        return benchmarks;
    }

    private void generateClass(GeneratorSource source, GeneratorDestination destination, ClassInfo classInfo, BenchmarkInfo info) throws IOException {
        StateObjectHandler states = new StateObjectHandler(this.compilerControl);
        states.bindMethods(classInfo, info.methodGroup);
        PrintWriter writer = new PrintWriter(destination.newClass(info.generatedClassQName), false);
        writer.println("package " + info.generatedPackageName + ';');
        writer.println();
        this.generateImport(writer);
        states.addImports(writer);
        writer.println("public final class " + info.generatedClassName + " {");
        writer.println();
        Paddings.padding(writer);
        writer.println(BenchmarkGenerator.ident(1) + "int startRndMask;");
        writer.println(BenchmarkGenerator.ident(1) + "BenchmarkParams benchmarkParams;");
        writer.println(BenchmarkGenerator.ident(1) + "IterationParams iterationParams;");
        writer.println(BenchmarkGenerator.ident(1) + "ThreadParams threadParams;");
        writer.println(BenchmarkGenerator.ident(1) + "Blackhole blackhole;");
        writer.println(BenchmarkGenerator.ident(1) + "Control notifyControl;");
        for (Mode benchmarkKind : Mode.values()) {
            if (benchmarkKind == Mode.All) continue;
            this.generateMethod(classInfo, benchmarkKind, writer, info.methodGroup, states);
        }
        for (String s : states.getStateInitializers()) {
            writer.println(BenchmarkGenerator.ident(1) + s);
        }
        writer.println();
        for (String s : states.getFields()) {
            writer.println(BenchmarkGenerator.ident(1) + s);
        }
        writer.println();
        states.writeStateOverrides(this.session, destination);
        writer.println("}");
        writer.println();
        writer.close();
    }

    private void generateImport(PrintWriter writer) {
        Class[] imports;
        for (Class c : imports = new Class[]{List.class, AtomicInteger.class, Collection.class, ArrayList.class, TimeUnit.class, CompilerControl.class, InfraControl.class, ThreadParams.class, BenchmarkTaskResult.class, Result.class, ThroughputResult.class, AverageTimeResult.class, SampleTimeResult.class, SingleShotResult.class, SampleBuffer.class, Mode.class, Fork.class, Measurement.class, Threads.class, Warmup.class, BenchmarkMode.class, RawResults.class, ResultRole.class, Field.class, BenchmarkParams.class, IterationParams.class, Blackhole.class, Control.class}) {
            writer.println("import " + c.getName() + ';');
        }
        writer.println();
    }

    private void generateMethod(ClassInfo classInfo, Mode benchmarkKind, PrintWriter writer, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println();
        switch (benchmarkKind) {
            case Throughput: {
                this.generateThroughput(classInfo, writer, benchmarkKind, methodGroup, states);
                break;
            }
            case AverageTime: {
                this.generateAverageTime(classInfo, writer, benchmarkKind, methodGroup, states);
                break;
            }
            case SampleTime: {
                this.generateSampleTime(classInfo, writer, benchmarkKind, methodGroup, states);
                break;
            }
            case SingleShotTime: {
                this.generateSingleShotTime(classInfo, writer, benchmarkKind, methodGroup, states);
                break;
            }
            default: {
                throw new AssertionError((Object)"Shouldn't be here");
            }
        }
    }

    private void generateThroughput(ClassInfo classInfo, PrintWriter writer, Mode benchmarkKind, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println(BenchmarkGenerator.ident(1) + "public BenchmarkTaskResult " + methodGroup.getName() + "_" + (Object)((Object)benchmarkKind) + "(InfraControl control, ThreadParams threadParams) throws Throwable {");
        this.methodProlog(writer, methodGroup);
        boolean isSingleMethod = methodGroup.methods().size() == 1;
        int subGroup = -1;
        for (MethodInfo method : methodGroup.methods()) {
            writer.println(BenchmarkGenerator.ident(2) + "if (threadParams.getSubgroupIndex() == " + ++subGroup + ") {");
            writer.println(BenchmarkGenerator.ident(3) + "RawResults res = new RawResults();");
            this.iterationProlog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmupReady();");
            writer.println(BenchmarkGenerator.ident(3) + "while (control.warmupShouldWait) {");
            this.invocationProlog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + "res.allOps++;");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println();
            writer.println(BenchmarkGenerator.ident(3) + "notifyControl.startMeasurement = true;");
            writer.println(BenchmarkGenerator.ident(3) + method.getName() + "_" + benchmarkKind.shortLabel() + JMH_STUB_SUFFIX + "(" + this.getStubArgs() + this.prefix(states.getArgList(method)) + ");");
            writer.println(BenchmarkGenerator.ident(3) + "notifyControl.stopMeasurement = true;");
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmdownReady();");
            writer.println(BenchmarkGenerator.ident(3) + "try {");
            writer.println(BenchmarkGenerator.ident(4) + "while (control.warmdownShouldWait) {");
            this.invocationProlog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + "res.allOps++;");
            writer.println(BenchmarkGenerator.ident(4) + "}");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDown();");
            writer.println(BenchmarkGenerator.ident(3) + "} catch (InterruptedException ie) {");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDownForce();");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            this.iterationEpilog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps += res.measuredOps;");
            writer.println(BenchmarkGenerator.ident(3) + "int batchSize = iterationParams.getBatchSize();");
            writer.println(BenchmarkGenerator.ident(3) + "int opsPerInv = benchmarkParams.getOpsPerInvocation();");
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps *= opsPerInv;");
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps /= batchSize;");
            writer.println(BenchmarkGenerator.ident(3) + "res.measuredOps *= opsPerInv;");
            writer.println(BenchmarkGenerator.ident(3) + "res.measuredOps /= batchSize;");
            writer.println(BenchmarkGenerator.ident(3) + "BenchmarkTaskResult results = new BenchmarkTaskResult(res.allOps, res.measuredOps);");
            writer.println(BenchmarkGenerator.ident(3) + "results.add(new ThroughputResult(ResultRole.PRIMARY, \"" + method.getName() + "\", res.measuredOps, res.getTime(), benchmarkParams.getTimeUnit()));");
            if (!isSingleMethod) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new ThroughputResult(ResultRole.SECONDARY, \"" + method.getName() + "\", res.measuredOps, res.getTime(), benchmarkParams.getTimeUnit()));");
            }
            for (String ops : states.getAuxResultNames(method)) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new ThroughputResult(ResultRole.SECONDARY, \"" + ops + "\", " + states.getAuxResultAccessor(method, ops) + ", res.getTime(), benchmarkParams.getTimeUnit()));");
            }
            this.methodEpilog(writer, methodGroup);
            writer.println(BenchmarkGenerator.ident(3) + "return results;");
            writer.println(BenchmarkGenerator.ident(2) + "} else");
        }
        writer.println(BenchmarkGenerator.ident(3) + "throw new IllegalStateException(\"Harness failed to distribute threads among groups properly\");");
        writer.println(BenchmarkGenerator.ident(1) + "}");
        writer.println();
        for (MethodInfo method : methodGroup.methods()) {
            String methodName = method.getName() + "_" + benchmarkKind.shortLabel() + JMH_STUB_SUFFIX;
            this.compilerControl.defaultForceInline(method);
            writer.println(BenchmarkGenerator.ident(1) + "public static" + (methodGroup.isStrictFP() ? " strictfp" : "") + " void " + methodName + "(" + this.getStubTypeArgs() + this.prefix(states.getTypeArgList(method)) + ") throws Throwable {");
            writer.println(BenchmarkGenerator.ident(2) + "long operations = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "long realTime = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "result.startTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "do {");
            this.invocationProlog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + "operations++;");
            writer.println(BenchmarkGenerator.ident(2) + "} while(!control.isDone);");
            writer.println(BenchmarkGenerator.ident(2) + "result.stopTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "result.realTime = realTime;");
            writer.println(BenchmarkGenerator.ident(2) + "result.measuredOps = operations;");
            writer.println(BenchmarkGenerator.ident(1) + "}");
            writer.println();
        }
    }

    private void generateAverageTime(ClassInfo classInfo, PrintWriter writer, Mode benchmarkKind, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println(BenchmarkGenerator.ident(1) + "public BenchmarkTaskResult " + methodGroup.getName() + "_" + (Object)((Object)benchmarkKind) + "(InfraControl control, ThreadParams threadParams) throws Throwable {");
        this.methodProlog(writer, methodGroup);
        boolean isSingleMethod = methodGroup.methods().size() == 1;
        int subGroup = -1;
        for (MethodInfo method : methodGroup.methods()) {
            writer.println(BenchmarkGenerator.ident(2) + "if (threadParams.getSubgroupIndex() == " + ++subGroup + ") {");
            writer.println(BenchmarkGenerator.ident(3) + "RawResults res = new RawResults();");
            this.iterationProlog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmupReady();");
            writer.println(BenchmarkGenerator.ident(3) + "while (control.warmupShouldWait) {");
            this.invocationProlog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + "res.allOps++;");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println();
            writer.println(BenchmarkGenerator.ident(3) + "notifyControl.startMeasurement = true;");
            writer.println(BenchmarkGenerator.ident(3) + method.getName() + "_" + benchmarkKind.shortLabel() + JMH_STUB_SUFFIX + "(" + this.getStubArgs() + this.prefix(states.getArgList(method)) + ");");
            writer.println(BenchmarkGenerator.ident(3) + "notifyControl.stopMeasurement = true;");
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmdownReady();");
            writer.println(BenchmarkGenerator.ident(3) + "try {");
            writer.println(BenchmarkGenerator.ident(4) + "while (control.warmdownShouldWait) {");
            this.invocationProlog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + "res.allOps++;");
            writer.println(BenchmarkGenerator.ident(4) + "}");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDown();");
            writer.println(BenchmarkGenerator.ident(3) + "} catch (InterruptedException ie) {");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDownForce();");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            this.iterationEpilog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps += res.measuredOps;");
            writer.println(BenchmarkGenerator.ident(3) + "int batchSize = iterationParams.getBatchSize();");
            writer.println(BenchmarkGenerator.ident(3) + "int opsPerInv = benchmarkParams.getOpsPerInvocation();");
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps *= opsPerInv;");
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps /= batchSize;");
            writer.println(BenchmarkGenerator.ident(3) + "res.measuredOps *= opsPerInv;");
            writer.println(BenchmarkGenerator.ident(3) + "res.measuredOps /= batchSize;");
            writer.println(BenchmarkGenerator.ident(3) + "BenchmarkTaskResult results = new BenchmarkTaskResult(res.allOps, res.measuredOps);");
            writer.println(BenchmarkGenerator.ident(3) + "results.add(new AverageTimeResult(ResultRole.PRIMARY, \"" + method.getName() + "\", res.measuredOps, res.getTime(), benchmarkParams.getTimeUnit()));");
            if (!isSingleMethod) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new AverageTimeResult(ResultRole.SECONDARY, \"" + method.getName() + "\", res.measuredOps, res.getTime(), benchmarkParams.getTimeUnit()));");
            }
            for (String ops : states.getAuxResultNames(method)) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new AverageTimeResult(ResultRole.SECONDARY, \"" + ops + "\", " + states.getAuxResultAccessor(method, ops) + ", res.getTime(), benchmarkParams.getTimeUnit()));");
            }
            this.methodEpilog(writer, methodGroup);
            writer.println(BenchmarkGenerator.ident(3) + "return results;");
            writer.println(BenchmarkGenerator.ident(2) + "} else");
        }
        writer.println(BenchmarkGenerator.ident(3) + "throw new IllegalStateException(\"Harness failed to distribute threads among groups properly\");");
        writer.println(BenchmarkGenerator.ident(1) + "}");
        writer.println();
        for (MethodInfo method : methodGroup.methods()) {
            String methodName = method.getName() + "_" + benchmarkKind.shortLabel() + JMH_STUB_SUFFIX;
            this.compilerControl.defaultForceInline(method);
            writer.println(BenchmarkGenerator.ident(1) + "public static" + (methodGroup.isStrictFP() ? " strictfp" : "") + " void " + methodName + "(" + this.getStubTypeArgs() + this.prefix(states.getTypeArgList(method)) + ") throws Throwable {");
            writer.println(BenchmarkGenerator.ident(2) + "long operations = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "long realTime = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "result.startTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "do {");
            this.invocationProlog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + "operations++;");
            writer.println(BenchmarkGenerator.ident(2) + "} while(!control.isDone);");
            writer.println(BenchmarkGenerator.ident(2) + "result.stopTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "result.realTime = realTime;");
            writer.println(BenchmarkGenerator.ident(2) + "result.measuredOps = operations;");
            writer.println(BenchmarkGenerator.ident(1) + "}");
            writer.println();
        }
    }

    private String getStubArgs() {
        return "control, res, benchmarkParams, iterationParams, threadParams, blackhole, notifyControl, startRndMask";
    }

    private String getStubTypeArgs() {
        return "InfraControl control, RawResults result, BenchmarkParams benchmarkParams, IterationParams iterationParams, ThreadParams threadParams, Blackhole blackhole, Control notifyControl, int startRndMask";
    }

    private void methodProlog(PrintWriter writer, MethodGroup methodGroup) {
        writer.println(BenchmarkGenerator.ident(2) + "this.benchmarkParams = control.benchmarkParams;");
        writer.println(BenchmarkGenerator.ident(2) + "this.iterationParams = control.iterationParams;");
        writer.println(BenchmarkGenerator.ident(2) + "this.threadParams    = threadParams;");
        writer.println(BenchmarkGenerator.ident(2) + "this.notifyControl   = new Control();");
        writer.println(BenchmarkGenerator.ident(2) + "this.blackhole       = new Blackhole(\"Today's password is swordfish. I understand instantiating Blackholes directly is dangerous.\");");
    }

    private void methodEpilog(PrintWriter writer, MethodGroup methodGroup) {
        writer.println(BenchmarkGenerator.ident(3) + "this.blackhole = null;");
    }

    private String prefix(String argList) {
        if (argList.trim().isEmpty()) {
            return "";
        }
        return ", " + argList;
    }

    private void generateSampleTime(ClassInfo classInfo, PrintWriter writer, Mode benchmarkKind, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println(BenchmarkGenerator.ident(1) + "public BenchmarkTaskResult " + methodGroup.getName() + "_" + (Object)((Object)benchmarkKind) + "(InfraControl control, ThreadParams threadParams) throws Throwable {");
        this.methodProlog(writer, methodGroup);
        boolean isSingleMethod = methodGroup.methods().size() == 1;
        int subGroup = -1;
        for (MethodInfo method : methodGroup.methods()) {
            writer.println(BenchmarkGenerator.ident(2) + "if (threadParams.getSubgroupIndex() == " + ++subGroup + ") {");
            writer.println(BenchmarkGenerator.ident(3) + "RawResults res = new RawResults();");
            this.iterationProlog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmupReady();");
            writer.println(BenchmarkGenerator.ident(3) + "while (control.warmupShouldWait) {");
            this.invocationProlog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + "res.allOps++;");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println();
            writer.println(BenchmarkGenerator.ident(3) + "notifyControl.startMeasurement = true;");
            writer.println(BenchmarkGenerator.ident(3) + "int targetSamples = (int) (control.getDuration(TimeUnit.MILLISECONDS) * 20); // at max, 20 timestamps per millisecond");
            writer.println(BenchmarkGenerator.ident(3) + "int batchSize = iterationParams.getBatchSize();");
            writer.println(BenchmarkGenerator.ident(3) + "int opsPerInv = benchmarkParams.getOpsPerInvocation();");
            writer.println(BenchmarkGenerator.ident(3) + "SampleBuffer buffer = new SampleBuffer();");
            writer.println(BenchmarkGenerator.ident(3) + method.getName() + "_" + benchmarkKind.shortLabel() + JMH_STUB_SUFFIX + "(" + this.getStubArgs() + ", buffer, targetSamples, opsPerInv, batchSize" + this.prefix(states.getArgList(method)) + ");");
            writer.println(BenchmarkGenerator.ident(3) + "notifyControl.stopMeasurement = true;");
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmdownReady();");
            writer.println(BenchmarkGenerator.ident(3) + "try {");
            writer.println(BenchmarkGenerator.ident(4) + "while (control.warmdownShouldWait) {");
            this.invocationProlog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + "res.allOps++;");
            writer.println(BenchmarkGenerator.ident(4) + "}");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDown();");
            writer.println(BenchmarkGenerator.ident(3) + "} catch (InterruptedException ie) {");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDownForce();");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            this.iterationEpilog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps += res.measuredOps * batchSize;");
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps *= opsPerInv;");
            writer.println(BenchmarkGenerator.ident(3) + "res.allOps /= batchSize;");
            writer.println(BenchmarkGenerator.ident(3) + "res.measuredOps *= opsPerInv;");
            writer.println(BenchmarkGenerator.ident(3) + "BenchmarkTaskResult results = new BenchmarkTaskResult(res.allOps, res.measuredOps);");
            writer.println(BenchmarkGenerator.ident(3) + "results.add(new SampleTimeResult(ResultRole.PRIMARY, \"" + method.getName() + "\", buffer, benchmarkParams.getTimeUnit()));");
            if (!isSingleMethod) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new SampleTimeResult(ResultRole.SECONDARY, \"" + method.getName() + "\", buffer, benchmarkParams.getTimeUnit()));");
            }
            this.methodEpilog(writer, methodGroup);
            writer.println(BenchmarkGenerator.ident(3) + "return results;");
            writer.println(BenchmarkGenerator.ident(2) + "} else");
        }
        writer.println(BenchmarkGenerator.ident(3) + "throw new IllegalStateException(\"Harness failed to distribute threads among groups properly\");");
        writer.println(BenchmarkGenerator.ident(1) + "}");
        writer.println();
        for (MethodInfo method : methodGroup.methods()) {
            String methodName = method.getName() + "_" + benchmarkKind.shortLabel() + JMH_STUB_SUFFIX;
            this.compilerControl.defaultForceInline(method);
            writer.println(BenchmarkGenerator.ident(1) + "public static" + (methodGroup.isStrictFP() ? " strictfp" : "") + " void " + methodName + "(" + this.getStubTypeArgs() + ", SampleBuffer buffer, int targetSamples, long opsPerInv, int batchSize" + this.prefix(states.getTypeArgList(method)) + ") throws Throwable {");
            writer.println(BenchmarkGenerator.ident(2) + "long realTime = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "long operations = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "int rnd = (int)System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "int rndMask = startRndMask;");
            writer.println(BenchmarkGenerator.ident(2) + "long time = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "int currentStride = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "do {");
            this.invocationProlog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + "rnd = (rnd * 1664525 + 1013904223);");
            writer.println(BenchmarkGenerator.ident(3) + "boolean sample = (rnd & rndMask) == 0;");
            writer.println(BenchmarkGenerator.ident(3) + "if (sample) {");
            writer.println(BenchmarkGenerator.ident(4) + "time = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println(BenchmarkGenerator.ident(3) + "for (int b = 0; b < batchSize; b++) {");
            writer.println(BenchmarkGenerator.ident(4) + "if (control.volatileSpoiler) return;");
            writer.println(BenchmarkGenerator.ident(4) + "" + this.emitCall(method, states) + ';');
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println(BenchmarkGenerator.ident(3) + "if (sample) {");
            writer.println(BenchmarkGenerator.ident(4) + "buffer.add((System.nanoTime() - time) / opsPerInv);");
            writer.println(BenchmarkGenerator.ident(4) + "if (currentStride++ > targetSamples) {");
            writer.println(BenchmarkGenerator.ident(5) + "buffer.half();");
            writer.println(BenchmarkGenerator.ident(5) + "currentStride = 0;");
            writer.println(BenchmarkGenerator.ident(5) + "rndMask = (rndMask << 1) + 1;");
            writer.println(BenchmarkGenerator.ident(4) + "}");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            this.invocationEpilog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + "operations++;");
            writer.println(BenchmarkGenerator.ident(2) + "} while(!control.isDone);");
            writer.println(BenchmarkGenerator.ident(2) + "startRndMask = Math.max(startRndMask, rndMask);");
            writer.println(BenchmarkGenerator.ident(2) + "result.realTime = realTime;");
            writer.println(BenchmarkGenerator.ident(2) + "result.measuredOps = operations;");
            writer.println(BenchmarkGenerator.ident(1) + "}");
            writer.println();
        }
    }

    private void generateSingleShotTime(ClassInfo classInfo, PrintWriter writer, Mode benchmarkKind, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println(BenchmarkGenerator.ident(1) + "public BenchmarkTaskResult " + methodGroup.getName() + "_" + (Object)((Object)benchmarkKind) + "(InfraControl control, ThreadParams threadParams) throws Throwable {");
        this.methodProlog(writer, methodGroup);
        boolean isSingleMethod = methodGroup.methods().size() == 1;
        int subGroup = -1;
        for (MethodInfo method : methodGroup.methods()) {
            this.compilerControl.defaultForceInline(method);
            writer.println(BenchmarkGenerator.ident(2) + "if (threadParams.getSubgroupIndex() == " + ++subGroup + ") {");
            this.iterationProlog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "RawResults res = new RawResults();");
            writer.println(BenchmarkGenerator.ident(3) + "int batchSize = iterationParams.getBatchSize();");
            writer.println(BenchmarkGenerator.ident(3) + method.getName() + "_" + benchmarkKind.shortLabel() + JMH_STUB_SUFFIX + "(" + this.getStubArgs() + ", batchSize" + this.prefix(states.getArgList(method)) + ");");
            writer.println(BenchmarkGenerator.ident(3) + "control.preTearDown();");
            this.iterationEpilog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "int opsPerInv = control.benchmarkParams.getOpsPerInvocation();");
            writer.println(BenchmarkGenerator.ident(3) + "long totalOps = opsPerInv;");
            writer.println(BenchmarkGenerator.ident(3) + "BenchmarkTaskResult results = new BenchmarkTaskResult(totalOps, totalOps);");
            writer.println(BenchmarkGenerator.ident(3) + "results.add(new SingleShotResult(ResultRole.PRIMARY, \"" + method.getName() + "\", res.getTime(), benchmarkParams.getTimeUnit()));");
            if (!isSingleMethod) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new SingleShotResult(ResultRole.SECONDARY, \"" + method.getName() + "\", res.getTime(), benchmarkParams.getTimeUnit()));");
            }
            this.methodEpilog(writer, methodGroup);
            writer.println(BenchmarkGenerator.ident(3) + "return results;");
            writer.println(BenchmarkGenerator.ident(2) + "} else");
        }
        writer.println(BenchmarkGenerator.ident(3) + "throw new IllegalStateException(\"Harness failed to distribute threads among groups properly\");");
        writer.println(BenchmarkGenerator.ident(1) + "}");
        writer.println();
        for (MethodInfo method : methodGroup.methods()) {
            String methodName = method.getName() + "_" + benchmarkKind.shortLabel() + JMH_STUB_SUFFIX;
            this.compilerControl.defaultForceInline(method);
            writer.println(BenchmarkGenerator.ident(1) + "public static" + (methodGroup.isStrictFP() ? " strictfp" : "") + " void " + methodName + "(" + this.getStubTypeArgs() + ", int batchSize" + this.prefix(states.getTypeArgList(method)) + ") throws Throwable {");
            writer.println(BenchmarkGenerator.ident(2) + "long realTime = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "result.startTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "for (int b = 0; b < batchSize; b++) {");
            writer.println(BenchmarkGenerator.ident(3) + "if (control.volatileSpoiler) return;");
            this.invocationProlog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(2) + "}");
            writer.println(BenchmarkGenerator.ident(2) + "result.stopTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "result.realTime = realTime;");
            writer.println(BenchmarkGenerator.ident(1) + "}");
            writer.println();
        }
    }

    private void invocationProlog(PrintWriter writer, int prefix, MethodInfo method, StateObjectHandler states, boolean pauseMeasurement) {
        if (states.hasInvocationStubs(method)) {
            for (String s : states.getInvocationSetups(method)) {
                writer.println(BenchmarkGenerator.ident(prefix) + s);
            }
            if (pauseMeasurement) {
                writer.println(BenchmarkGenerator.ident(prefix) + "long rt = System.nanoTime();");
            }
        }
    }

    private void invocationEpilog(PrintWriter writer, int prefix, MethodInfo method, StateObjectHandler states, boolean pauseMeasurement) {
        if (states.hasInvocationStubs(method)) {
            if (pauseMeasurement) {
                writer.println(BenchmarkGenerator.ident(prefix) + "realTime += (System.nanoTime() - rt);");
            }
            for (String s : states.getInvocationTearDowns(method)) {
                writer.println(BenchmarkGenerator.ident(prefix) + s);
            }
        }
    }

    private void iterationProlog(PrintWriter writer, int prefix, MethodInfo method, StateObjectHandler states) {
        for (String s : states.getStateGetters(method)) {
            writer.println(BenchmarkGenerator.ident(prefix) + s);
        }
        writer.println();
        writer.println(BenchmarkGenerator.ident(prefix) + "control.preSetup();");
        for (String s : states.getIterationSetups(method)) {
            writer.println(BenchmarkGenerator.ident(prefix) + s);
        }
        writer.println();
    }

    private void iterationEpilog(PrintWriter writer, int prefix, MethodInfo method, StateObjectHandler states) {
        for (String s : states.getIterationTearDowns(method)) {
            writer.println(BenchmarkGenerator.ident(prefix) + s);
        }
        writer.println();
        writer.println(BenchmarkGenerator.ident(prefix) + "if (control.isLastIteration()) {");
        for (String s : states.getRunTearDowns(method)) {
            writer.println(BenchmarkGenerator.ident(prefix + 1) + s);
        }
        for (String s : states.getStateDestructors(method)) {
            writer.println(BenchmarkGenerator.ident(prefix + 1) + s);
        }
        writer.println(BenchmarkGenerator.ident(prefix) + "}");
    }

    private String emitCall(MethodInfo method, StateObjectHandler states) {
        if ("void".equalsIgnoreCase(method.getReturnType())) {
            return states.getImplicit((String)"bench").localIdentifier + "." + method.getName() + "(" + states.getBenchmarkArgList(method) + ")";
        }
        return "blackhole.consume(" + states.getImplicit((String)"bench").localIdentifier + "." + method.getName() + "(" + states.getBenchmarkArgList(method) + "))";
    }

    static String ident(int tabs) {
        int TAB_SIZE = 4;
        if (tabs >= INDENTS.length) {
            INDENTS = new String[tabs + 1];
            for (int p = 0; p <= tabs; ++p) {
                char[] chars = new char[p * 4];
                Arrays.fill(chars, ' ');
                BenchmarkGenerator.INDENTS[p] = new String(chars);
            }
        }
        return INDENTS[tabs];
    }
}

