/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;

public class ClassloaderProfiler
implements InternalProfiler {
    private long loadedClasses;
    private long unloadedClasses;
    private long beforeTime;
    private long afterTime;

    @Override
    public String getDescription() {
        return "Classloader profiling via standard MBeans";
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        this.beforeTime = System.nanoTime();
        try {
            this.loadedClasses = cl.getTotalLoadedClassCount();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.unloadedClasses = cl.getUnloadedClassCount();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        this.afterTime = System.nanoTime();
        ArrayList<ProfilerResult> results = new ArrayList<ProfilerResult>();
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        long allOps = result.getMetadata().getAllOps();
        double time = 1.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)(this.afterTime - this.beforeTime);
        try {
            long loadedClassCount = cl.getTotalLoadedClassCount();
            long loaded = loadedClassCount - this.loadedClasses;
            results.add(new ProfilerResult("\u00b7class.load", (double)loaded / time, "classes/sec", AggregationPolicy.AVG));
            results.add(new ProfilerResult("\u00b7class.load.norm", 1.0 * (double)loaded / (double)allOps, "classes/op", AggregationPolicy.AVG));
        }
        catch (UnsupportedOperationException loadedClassCount) {
            // empty catch block
        }
        try {
            long unloadedClassCount = cl.getUnloadedClassCount();
            long unloaded = unloadedClassCount - this.unloadedClasses;
            results.add(new ProfilerResult("\u00b7class.unload", (double)unloaded / time, "classes/sec", AggregationPolicy.AVG));
            results.add(new ProfilerResult("\u00b7class.unload.norm", 1.0 * (double)unloaded / (double)allOps, "classes/op", AggregationPolicy.AVG));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return results;
    }
}

