/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitOutput;

public class GorillaCompressor {
    private int storedLeadingZeros = Integer.MAX_VALUE;
    private int storedTrailingZeros = 0;
    private long storedVal = 0L;
    private long storedTimestamp = 0L;
    private int storedDelta = 0;
    private long blockTimestamp = 0L;
    public static final int FIRST_DELTA_BITS = 27;
    private static int DELTAD_7_MASK = 256;
    private static int DELTAD_9_MASK = 3072;
    private static int DELTAD_12_MASK = 57344;
    private BitOutput out;

    public GorillaCompressor(long timestamp, BitOutput output) {
        this.blockTimestamp = timestamp;
        this.out = output;
        this.addHeader(timestamp);
    }

    private void addHeader(long timestamp) {
        this.out.writeBits(timestamp, 64);
    }

    public void addValue(long timestamp, long value) {
        if (this.storedTimestamp == 0L) {
            this.writeFirst(timestamp, value);
        } else {
            this.compressTimestamp(timestamp);
            this.compressValue(value);
        }
    }

    public void addValue(long timestamp, double value) {
        if (this.storedTimestamp == 0L) {
            this.writeFirst(timestamp, Double.doubleToRawLongBits(value));
            return;
        }
        this.compressTimestamp(timestamp);
        this.compressValue(Double.doubleToRawLongBits(value));
    }

    private void writeFirst(long timestamp, long value) {
        this.storedDelta = (int)(timestamp - this.blockTimestamp);
        this.storedTimestamp = timestamp;
        this.storedVal = value;
        this.out.writeBits(this.storedDelta, 27);
        this.out.writeBits(this.storedVal, 64);
    }

    public void close() {
        this.out.writeBits(15L, 4);
        this.out.writeBits(-1L, 32);
        this.out.skipBit();
        this.out.flush();
    }

    private void compressTimestamp(long timestamp) {
        int newDelta = (int)(timestamp - this.storedTimestamp);
        int deltaD = newDelta - this.storedDelta;
        if (deltaD == 0) {
            this.out.skipBit();
        } else {
            deltaD = GorillaCompressor.encodeZigZag32(deltaD);
            int bitsRequired = 32 - Integer.numberOfLeadingZeros(--deltaD);
            switch (bitsRequired) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.out.writeBits(deltaD |= DELTAD_7_MASK, 9);
                    break;
                }
                case 8: 
                case 9: {
                    this.out.writeBits(deltaD |= DELTAD_9_MASK, 12);
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    this.out.writeBits(deltaD | DELTAD_12_MASK, 16);
                    break;
                }
                default: {
                    this.out.writeBits(15L, 4);
                    this.out.writeBits(deltaD, 32);
                }
            }
            this.storedDelta = newDelta;
        }
        this.storedTimestamp = timestamp;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    private void compressValue(long value) {
        long xor = this.storedVal ^ value;
        if (xor == 0L) {
            this.out.skipBit();
        } else {
            int leadingZeros = Long.numberOfLeadingZeros(xor);
            int trailingZeros = Long.numberOfTrailingZeros(xor);
            this.out.writeBit();
            if (leadingZeros >= this.storedLeadingZeros && trailingZeros >= this.storedTrailingZeros) {
                this.writeExistingLeading(xor);
            } else {
                this.writeNewLeading(xor, leadingZeros, trailingZeros);
            }
        }
        this.storedVal = value;
    }

    private void writeExistingLeading(long xor) {
        this.out.skipBit();
        int significantBits = 64 - this.storedLeadingZeros - this.storedTrailingZeros;
        this.out.writeBits(xor >>>= this.storedTrailingZeros, significantBits);
    }

    private void writeNewLeading(long xor, int leadingZeros, int trailingZeros) {
        this.out.writeBit();
        int significantBits = 64 - leadingZeros - trailingZeros;
        this.out.writeBits(leadingZeros, 6);
        this.out.writeBits(significantBits - 1, 6);
        this.out.writeBits(xor >>> trailingZeros, significantBits);
        this.storedLeadingZeros = leadingZeros;
        this.storedTrailingZeros = trailingZeros;
    }
}

