/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitInput;
import fi.iki.yak.ts.compression.gorilla.Pair;

public class GorillaDecompressor {
    private int storedLeadingZeros = Integer.MAX_VALUE;
    private int storedTrailingZeros = 0;
    private long storedVal = 0L;
    private long storedTimestamp = 0L;
    private long storedDelta = 0L;
    private long blockTimestamp = 0L;
    private boolean endOfStream = false;
    private BitInput in;

    public GorillaDecompressor(BitInput input) {
        this.in = input;
        this.readHeader();
    }

    private void readHeader() {
        this.blockTimestamp = this.in.getLong(64);
    }

    public Pair readPair() {
        this.next();
        if (this.endOfStream) {
            return null;
        }
        Pair pair = new Pair(this.storedTimestamp, this.storedVal);
        return pair;
    }

    private void next() {
        if (this.storedTimestamp == 0L) {
            this.first();
            return;
        }
        this.nextTimestamp();
    }

    private void first() {
        this.storedDelta = this.in.getLong(27);
        if (this.storedDelta == 0x7FFFFFFL) {
            this.endOfStream = true;
            return;
        }
        this.storedVal = this.in.getLong(64);
        this.storedTimestamp = this.blockTimestamp + this.storedDelta;
    }

    private void nextTimestamp() {
        long deltaDelta;
        int readInstruction = this.in.nextClearBit(4);
        switch (readInstruction) {
            case 0: {
                this.storedTimestamp = this.storedDelta + this.storedTimestamp;
                this.nextValue();
                return;
            }
            case 2: {
                deltaDelta = this.in.getLong(7);
                break;
            }
            case 6: {
                deltaDelta = this.in.getLong(9);
                break;
            }
            case 14: {
                deltaDelta = this.in.getLong(12);
                break;
            }
            case 15: {
                deltaDelta = this.in.getLong(32);
                if ((int)deltaDelta != -1) break;
                this.endOfStream = true;
                return;
            }
            default: {
                return;
            }
        }
        ++deltaDelta;
        deltaDelta = GorillaDecompressor.decodeZigZag32((int)deltaDelta);
        this.storedDelta += deltaDelta;
        this.storedTimestamp = this.storedDelta + this.storedTimestamp;
        this.nextValue();
    }

    private void nextValue() {
        int val = this.in.nextClearBit(2);
        switch (val) {
            case 3: {
                this.storedLeadingZeros = (int)this.in.getLong(6);
                byte significantBits = (byte)this.in.getLong(6);
                significantBits = (byte)(significantBits + 1);
                this.storedTrailingZeros = 64 - significantBits - this.storedLeadingZeros;
            }
            case 2: {
                long value = this.in.getLong(64 - this.storedLeadingZeros - this.storedTrailingZeros);
                value <<= this.storedTrailingZeros;
                this.storedVal = value = this.storedVal ^ value;
            }
        }
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }
}

