/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.cassandra.cache.CacheProvider;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.utils.Pair;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;

public class OHCProvider
implements CacheProvider<RowCacheKey, IRowCacheEntry> {
    @Override
    public ICache<RowCacheKey, IRowCacheEntry> create() {
        OHCacheBuilder builder = OHCacheBuilder.newBuilder();
        builder.capacity(DatabaseDescriptor.getRowCacheSizeInMB() * 1024L * 1024L).keySerializer(KeySerializer.instance).valueSerializer(ValueSerializer.instance).throwOOME(true);
        return new OHCacheAdapter(builder.build());
    }

    private static class ValueSerializer
    implements CacheSerializer<IRowCacheEntry> {
        private static ValueSerializer instance = new ValueSerializer();

        private ValueSerializer() {
        }

        @Override
        public void serialize(IRowCacheEntry entry, ByteBuffer buf) {
            assert (entry != null);
            try (DataOutputBufferFixed out = new DataOutputBufferFixed(buf);){
                boolean isSentinel = entry instanceof RowCacheSentinel;
                out.writeBoolean(isSentinel);
                if (isSentinel) {
                    out.writeLong(((RowCacheSentinel)entry).sentinelId);
                } else {
                    CachedPartition.cacheSerializer.serialize((CachedPartition)entry, out);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public IRowCacheEntry deserialize(ByteBuffer buf) {
            try {
                DataInputBuffer in = new DataInputBuffer(buf, false);
                boolean isSentinel = in.readBoolean();
                if (isSentinel) {
                    return new RowCacheSentinel(in.readLong());
                }
                return CachedPartition.cacheSerializer.deserialize(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int serializedSize(IRowCacheEntry entry) {
            int size = TypeSizes.sizeof(true);
            size = entry instanceof RowCacheSentinel ? (size += TypeSizes.sizeof(((RowCacheSentinel)entry).sentinelId)) : (int)((long)size + CachedPartition.cacheSerializer.serializedSize((CachedPartition)entry));
            return size;
        }
    }

    private static class KeySerializer
    implements CacheSerializer<RowCacheKey> {
        private static KeySerializer instance = new KeySerializer();

        private KeySerializer() {
        }

        @Override
        public void serialize(RowCacheKey rowCacheKey, ByteBuffer buf) {
            DataOutputBufferFixed dataOutput = new DataOutputBufferFixed(buf);
            try {
                dataOutput.writeUTF((String)rowCacheKey.ksAndCFName.left);
                dataOutput.writeUTF((String)rowCacheKey.ksAndCFName.right);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            buf.putInt(rowCacheKey.key.length);
            buf.put(rowCacheKey.key);
        }

        @Override
        public RowCacheKey deserialize(ByteBuffer buf) {
            DataInputBuffer dataInput = new DataInputBuffer(buf, false);
            String ksName = null;
            String cfName = null;
            try {
                ksName = dataInput.readUTF();
                cfName = dataInput.readUTF();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] key = new byte[buf.getInt()];
            buf.get(key);
            return new RowCacheKey(Pair.create(ksName, cfName), key);
        }

        @Override
        public int serializedSize(RowCacheKey rowCacheKey) {
            return TypeSizes.sizeof((String)rowCacheKey.ksAndCFName.left) + TypeSizes.sizeof((String)rowCacheKey.ksAndCFName.right) + 4 + rowCacheKey.key.length;
        }
    }

    private static class OHCacheAdapter
    implements ICache<RowCacheKey, IRowCacheEntry> {
        private final OHCache<RowCacheKey, IRowCacheEntry> ohCache;

        public OHCacheAdapter(OHCache<RowCacheKey, IRowCacheEntry> ohCache) {
            this.ohCache = ohCache;
        }

        @Override
        public long capacity() {
            return this.ohCache.capacity();
        }

        @Override
        public void setCapacity(long capacity) {
            this.ohCache.setCapacity(capacity);
        }

        @Override
        public void put(RowCacheKey key, IRowCacheEntry value) {
            this.ohCache.put(key, value);
        }

        @Override
        public boolean putIfAbsent(RowCacheKey key, IRowCacheEntry value) {
            return this.ohCache.putIfAbsent(key, value);
        }

        @Override
        public boolean replace(RowCacheKey key, IRowCacheEntry old, IRowCacheEntry value) {
            return this.ohCache.addOrReplace(key, old, value);
        }

        @Override
        public IRowCacheEntry get(RowCacheKey key) {
            return this.ohCache.get(key);
        }

        @Override
        public void remove(RowCacheKey key) {
            this.ohCache.remove(key);
        }

        @Override
        public int size() {
            return (int)this.ohCache.size();
        }

        @Override
        public long weightedSize() {
            return this.ohCache.memUsed();
        }

        @Override
        public void clear() {
            this.ohCache.clear();
        }

        @Override
        public Iterator<RowCacheKey> hotKeyIterator(int n) {
            return this.ohCache.hotKeyIterator(n);
        }

        @Override
        public Iterator<RowCacheKey> keyIterator() {
            return this.ohCache.keyIterator();
        }

        @Override
        public boolean containsKey(RowCacheKey key) {
            return this.ohCache.containsKey(key);
        }
    }
}

