/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.SecurityThreadGroup;
import org.apache.cassandra.cql3.functions.ThreadAwareSecurityManager;
import org.apache.cassandra.cql3.functions.UDFExecutorService;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;

final class ScriptBasedUDFunction
extends UDFunction {
    private static final ProtectionDomain protectionDomain;
    private static final AccessControlContext accessControlContext;
    private static final String[] allowedPackagesArray;
    private static final UDFExecutorService executor;
    private static final ClassFilter classFilter;
    private static final NashornScriptEngine scriptEngine;
    private final CompiledScript script;

    ScriptBasedUDFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body) {
        super(name, argNames, argTypes, returnType, calledOnNullInput, language, body);
        if (!"JavaScript".equalsIgnoreCase(language) || scriptEngine == null) {
            throw new InvalidRequestException(String.format("Invalid language '%s' for function '%s'", language, name));
        }
        try {
            this.script = AccessController.doPrivileged(() -> scriptEngine.compile(body), accessControlContext);
        }
        catch (PrivilegedActionException x) {
            Throwable e = x.getCause();
            logger.info("Failed to compile function '{}' for language {}: ", name, language, e);
            throw new InvalidRequestException(String.format("Failed to compile function '%s' for language %s: %s", name, language, e));
        }
    }

    @Override
    protected ExecutorService executor() {
        return executor;
    }

    @Override
    public ByteBuffer executeUserDefined(int protocolVersion, List<ByteBuffer> parameters) {
        Class<?> resultType;
        Object result;
        Object[] params = new Object[this.argTypes.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.compose(protocolVersion, i, parameters.get(i));
        }
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("javax.script.filename", this.name.toString(), 100);
        Bindings bindings = scriptContext.getBindings(100);
        for (int i = 0; i < params.length; ++i) {
            bindings.put(((ColumnIdentifier)this.argNames.get(i)).toString(), params[i]);
        }
        try {
            result = this.script.eval(scriptContext);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            return null;
        }
        Class<?> javaReturnType = UDHelper.asJavaClass(this.returnCodec);
        if (!javaReturnType.isAssignableFrom(resultType = result.getClass()) && result instanceof Number) {
            Number rNumber = (Number)result;
            if (javaReturnType == Integer.class) {
                result = rNumber.intValue();
            } else if (javaReturnType == Long.class) {
                result = rNumber.longValue();
            } else if (javaReturnType == Short.class) {
                result = rNumber.shortValue();
            } else if (javaReturnType == Byte.class) {
                result = rNumber.byteValue();
            } else if (javaReturnType == Float.class) {
                result = Float.valueOf(rNumber.floatValue());
            } else if (javaReturnType == Double.class) {
                result = rNumber.doubleValue();
            } else if (javaReturnType == BigInteger.class) {
                if (javaReturnType == Integer.class) {
                    result = rNumber.intValue();
                } else if (javaReturnType == Short.class) {
                    result = rNumber.shortValue();
                } else if (javaReturnType == Byte.class) {
                    result = rNumber.byteValue();
                } else if (javaReturnType == Long.class) {
                    result = rNumber.longValue();
                } else if (javaReturnType == Float.class) {
                    result = Float.valueOf(rNumber.floatValue());
                } else if (javaReturnType == Double.class) {
                    result = rNumber.doubleValue();
                } else if (javaReturnType == BigInteger.class) {
                    result = rNumber instanceof BigDecimal ? ((BigDecimal)rNumber).toBigInteger() : (rNumber instanceof Double || rNumber instanceof Float ? new BigDecimal(rNumber.toString()).toBigInteger() : BigInteger.valueOf(rNumber.longValue()));
                } else if (javaReturnType == BigDecimal.class) {
                    result = new BigDecimal(rNumber.toString());
                }
            } else if (javaReturnType == BigDecimal.class) {
                result = new BigDecimal(rNumber.toString());
            }
        }
        return this.decompose(protocolVersion, result);
    }

    static {
        allowedPackagesArray = new String[]{"", "com", "edu", "java", "javax", "javafx", "org", "java.lang", "java.lang.invoke", "java.lang.reflect", "java.nio.charset", "java.util", "java.util.concurrent", "javax.script", "sun.reflect", "jdk.internal.org.objectweb.asm.commons", "jdk.nashorn.internal.runtime", "jdk.nashorn.internal.runtime.linker", "java.math", "java.nio", "java.text", "com.google.common.base", "com.google.common.collect", "com.google.common.reflect", "com.datastax.driver.core", "com.datastax.driver.core.utils"};
        executor = new UDFExecutorService(new NamedThreadFactory("UserDefinedScriptFunctions", 1, udfClassLoader, new SecurityThreadGroup("UserDefinedScriptFunctions", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(allowedPackagesArray))), UDFunction::initializeThread)), "userscripts");
        classFilter = clsName -> ScriptBasedUDFunction.secureResource(clsName.replace('.', '/') + ".class");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine engine = scriptEngineManager.getEngineByName("nashorn");
        NashornScriptEngineFactory factory = engine != null ? (NashornScriptEngineFactory)engine.getFactory() : null;
        scriptEngine = factory != null ? (NashornScriptEngine)factory.getScriptEngine(new String[0], udfClassLoader, classFilter) : null;
        try {
            protectionDomain = new ProtectionDomain(new CodeSource(new URL("udf", "localhost", 0, "/script", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) {
                    return null;
                }
            }), (Certificate[])null), ThreadAwareSecurityManager.noPermissions);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }
}

