/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.partitions.PurgeFunction;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.index.transactions.CompactionTransaction;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.metrics.CompactionMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionIterator
extends CompactionInfo.Holder
implements UnfilteredPartitionIterator {
    private static final Logger logger = LoggerFactory.getLogger(CompactionIterator.class);
    private static final long UNFILTERED_TO_UPDATE_PROGRESS = 100L;
    private final OperationType type;
    private final CompactionController controller;
    private final List<ISSTableScanner> scanners;
    private final int nowInSec;
    private final UUID compactionId;
    private final long totalBytes;
    private long bytesRead;
    private final long[] mergeCounters;
    private final UnfilteredPartitionIterator compacted;
    private final CompactionMetrics metrics;

    public CompactionIterator(OperationType type, List<ISSTableScanner> scanners, CompactionController controller, int nowInSec, UUID compactionId) {
        this(type, scanners, controller, nowInSec, compactionId, null);
    }

    public CompactionIterator(OperationType type, List<ISSTableScanner> scanners, CompactionController controller, int nowInSec, UUID compactionId, CompactionMetrics metrics) {
        this.controller = controller;
        this.type = type;
        this.scanners = scanners;
        this.nowInSec = nowInSec;
        this.compactionId = compactionId;
        this.bytesRead = 0L;
        long bytes = 0L;
        for (ISSTableScanner scanner : scanners) {
            bytes += scanner.getLengthInBytes();
        }
        this.totalBytes = bytes;
        this.mergeCounters = new long[scanners.size()];
        this.metrics = metrics;
        if (metrics != null) {
            metrics.beginCompaction(this);
        }
        UnfilteredPartitionIterator merged = scanners.isEmpty() ? EmptyIterators.unfilteredPartition(controller.cfs.metadata, false) : UnfilteredPartitionIterators.merge(scanners, nowInSec, this.listener());
        boolean isForThrift = merged.isForThrift();
        this.compacted = Transformation.apply(merged, new Purger(isForThrift, controller, nowInSec));
    }

    @Override
    public boolean isForThrift() {
        return false;
    }

    @Override
    public CFMetaData metadata() {
        return this.controller.cfs.metadata;
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.controller.cfs.metadata, this.type, this.bytesRead, this.totalBytes, this.compactionId);
    }

    private void updateCounterFor(int rows) {
        assert (rows > 0 && rows - 1 < this.mergeCounters.length);
        int n = rows - 1;
        this.mergeCounters[n] = this.mergeCounters[n] + 1L;
    }

    public long[] getMergedRowCounts() {
        return this.mergeCounters;
    }

    private UnfilteredPartitionIterators.MergeListener listener() {
        return new UnfilteredPartitionIterators.MergeListener(){

            @Override
            public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
                int merged = 0;
                for (UnfilteredRowIterator iter2 : versions) {
                    if (iter2 == null) continue;
                    ++merged;
                }
                assert (merged > 0);
                CompactionIterator.this.updateCounterFor(merged);
                if (CompactionIterator.this.type != OperationType.COMPACTION || !((CompactionIterator)CompactionIterator.this).controller.cfs.indexManager.hasIndexes()) {
                    return null;
                }
                Columns statics = Columns.NONE;
                Columns regulars = Columns.NONE;
                for (UnfilteredRowIterator iter3 : versions) {
                    if (iter3 == null) continue;
                    statics = statics.mergeTo(iter3.columns().statics);
                    regulars = regulars.mergeTo(iter3.columns().regulars);
                }
                PartitionColumns partitionColumns = new PartitionColumns(statics, regulars);
                final CompactionTransaction indexTransaction = ((CompactionIterator)CompactionIterator.this).controller.cfs.indexManager.newCompactionTransaction(partitionKey, partitionColumns, versions.size(), CompactionIterator.this.nowInSec);
                return new UnfilteredRowIterators.MergeListener(){

                    @Override
                    public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                    }

                    @Override
                    public void onMergedRows(Row merged, Row[] versions) {
                        indexTransaction.start();
                        indexTransaction.onRowMerge(merged, versions);
                        indexTransaction.commit();
                    }

                    @Override
                    public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker mergedMarker, RangeTombstoneMarker[] versions) {
                    }

                    @Override
                    public void close() {
                    }
                };
            }

            @Override
            public void close() {
            }
        };
    }

    private void updateBytesRead() {
        long n = 0L;
        for (ISSTableScanner scanner : this.scanners) {
            n += scanner.getCurrentPosition();
        }
        this.bytesRead = n;
    }

    @Override
    public boolean hasNext() {
        return this.compacted.hasNext();
    }

    @Override
    public UnfilteredRowIterator next() {
        return (UnfilteredRowIterator)this.compacted.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        try {
            this.compacted.close();
        }
        finally {
            if (this.metrics != null) {
                this.metrics.finishCompaction(this);
            }
        }
    }

    public String toString() {
        return this.getCompactionInfo().toString();
    }

    private class Purger
    extends PurgeFunction {
        private final CompactionController controller;
        private DecoratedKey currentKey;
        private Predicate<Long> purgeEvaluator;
        private long compactedUnfiltered;

        private Purger(boolean isForThrift, CompactionController controller, int nowInSec) {
            super(isForThrift, nowInSec, controller.gcBefore, controller.compactingRepaired() ? Integer.MAX_VALUE : Integer.MIN_VALUE, controller.cfs.getCompactionStrategyManager().onlyPurgeRepairedTombstones());
            this.controller = controller;
        }

        @Override
        protected void onEmptyPartitionPostPurge(DecoratedKey key) {
            if (CompactionIterator.this.type == OperationType.COMPACTION) {
                this.controller.cfs.invalidateCachedPartition(key);
            }
        }

        @Override
        protected void onNewPartition(DecoratedKey key) {
            this.currentKey = key;
            this.purgeEvaluator = null;
        }

        @Override
        protected void updateProgress() {
            if (++this.compactedUnfiltered % 100L == 0L) {
                CompactionIterator.this.updateBytesRead();
            }
        }

        @Override
        protected Predicate<Long> getPurgeEvaluator() {
            if (this.purgeEvaluator == null) {
                this.purgeEvaluator = this.controller.getPurgeEvaluator(this.currentKey);
            }
            return this.purgeEvaluator;
        }
    }
}

