/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.io.sstable.IndexSummaryManagerMBean;
import org.apache.cassandra.io.sstable.IndexSummaryRedistribution;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSummaryManager
implements IndexSummaryManagerMBean {
    private static final Logger logger = LoggerFactory.getLogger(IndexSummaryManager.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=IndexSummaries";
    public static final IndexSummaryManager instance = new IndexSummaryManager();
    private int resizeIntervalInMinutes = 0;
    private long memoryPoolBytes;
    private final DebuggableScheduledThreadPoolExecutor executor = new DebuggableScheduledThreadPoolExecutor(1, "IndexSummaryManager", 1);
    private ScheduledFuture future;

    private IndexSummaryManager() {
        long indexSummarySizeInMB = DatabaseDescriptor.getIndexSummaryCapacityInMB();
        int interval = DatabaseDescriptor.getIndexSummaryResizeIntervalInMinutes();
        logger.info("Initializing index summary manager with a memory pool size of {} MB and a resize interval of {} minutes", (Object)indexSummarySizeInMB, (Object)interval);
        this.setMemoryPoolCapacityInMB(DatabaseDescriptor.getIndexSummaryCapacityInMB());
        this.setResizeIntervalInMinutes(DatabaseDescriptor.getIndexSummaryResizeIntervalInMinutes());
    }

    @Override
    public int getResizeIntervalInMinutes() {
        return this.resizeIntervalInMinutes;
    }

    @Override
    public void setResizeIntervalInMinutes(int resizeIntervalInMinutes) {
        long initialDelay;
        int oldInterval = this.resizeIntervalInMinutes;
        this.resizeIntervalInMinutes = resizeIntervalInMinutes;
        if (this.future != null) {
            initialDelay = oldInterval < 0 ? (long)resizeIntervalInMinutes : Math.max(0L, (long)resizeIntervalInMinutes - ((long)oldInterval - this.future.getDelay(TimeUnit.MINUTES)));
            this.future.cancel(false);
        } else {
            initialDelay = resizeIntervalInMinutes;
        }
        if (this.resizeIntervalInMinutes < 0) {
            this.future = null;
            return;
        }
        this.future = this.executor.scheduleWithFixedDelay(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                IndexSummaryManager.this.redistributeSummaries();
            }
        }, initialDelay, resizeIntervalInMinutes, TimeUnit.MINUTES);
    }

    @VisibleForTesting
    Long getTimeToNextResize(TimeUnit timeUnit) {
        if (this.future == null) {
            return null;
        }
        return this.future.getDelay(timeUnit);
    }

    @Override
    public long getMemoryPoolCapacityInMB() {
        return this.memoryPoolBytes / 1024L / 1024L;
    }

    @Override
    public Map<String, Integer> getIndexIntervals() {
        List<SSTableReader> sstables = this.getAllSSTables();
        HashMap<String, Integer> intervals = new HashMap<String, Integer>(sstables.size());
        for (SSTableReader sstable : sstables) {
            intervals.put(sstable.getFilename(), (int)Math.round(sstable.getEffectiveIndexInterval()));
        }
        return intervals;
    }

    @Override
    public double getAverageIndexInterval() {
        List<SSTableReader> sstables = this.getAllSSTables();
        double total = 0.0;
        for (SSTableReader sstable : sstables) {
            total += sstable.getEffectiveIndexInterval();
        }
        return total / (double)sstables.size();
    }

    @Override
    public void setMemoryPoolCapacityInMB(long memoryPoolCapacityInMB) {
        this.memoryPoolBytes = memoryPoolCapacityInMB * 1024L * 1024L;
    }

    @Override
    public double getMemoryPoolSizeInMB() {
        long total = 0L;
        for (SSTableReader sstable : this.getAllSSTables()) {
            total += sstable.getIndexSummaryOffHeapSize();
        }
        return (double)total / 1024.0 / 1024.0;
    }

    private List<SSTableReader> getAllSSTables() {
        ArrayList<SSTableReader> result = new ArrayList<SSTableReader>();
        for (Keyspace ks : Keyspace.all()) {
            for (ColumnFamilyStore cfStore : ks.getColumnFamilyStores()) {
                result.addAll(cfStore.getLiveSSTables());
            }
        }
        return result;
    }

    private Pair<List<SSTableReader>, Map<UUID, LifecycleTransaction>> getCompactingAndNonCompactingSSTables() {
        ArrayList<SSTableReader> allCompacting = new ArrayList<SSTableReader>();
        HashMap<UUID, LifecycleTransaction> allNonCompacting = new HashMap<UUID, LifecycleTransaction>();
        for (Keyspace ks : Keyspace.all()) {
            for (ColumnFamilyStore cfStore : ks.getColumnFamilyStores()) {
                ImmutableSet<SSTableReader> allSSTables;
                ImmutableSet<SSTableReader> nonCompacting;
                LifecycleTransaction txn = null;
                do {
                    View view = cfStore.getTracker().getView();
                    allSSTables = ImmutableSet.copyOf(view.select(SSTableSet.CANONICAL));
                    nonCompacting = ImmutableSet.copyOf(view.getUncompacting(allSSTables));
                } while (null == (txn = cfStore.getTracker().tryModify(nonCompacting, OperationType.UNKNOWN)));
                allNonCompacting.put(cfStore.metadata.cfId, txn);
                allCompacting.addAll(Sets.difference(allSSTables, nonCompacting));
            }
        }
        return Pair.create(allCompacting, allNonCompacting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redistributeSummaries() throws IOException {
        Pair<List<SSTableReader>, Map<UUID, LifecycleTransaction>> compactingAndNonCompacting = this.getCompactingAndNonCompactingSSTables();
        try {
            IndexSummaryManager.redistributeSummaries(new IndexSummaryRedistribution((List)compactingAndNonCompacting.left, (Map)compactingAndNonCompacting.right, this.memoryPoolBytes));
        }
        finally {
            for (LifecycleTransaction modifier : ((Map)compactingAndNonCompacting.right).values()) {
                modifier.close();
            }
        }
    }

    @VisibleForTesting
    public static List<SSTableReader> redistributeSummaries(IndexSummaryRedistribution redistribution) throws IOException {
        return CompactionManager.instance.runIndexSummaryRedistribution(redistribution);
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

